/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.editor;

import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.eclipse.nebula.widgets.cdatetime.CDateTime;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.ModelMessages;
import org.eclipse.wb.internal.core.model.property.GenericProperty;
import org.eclipse.wb.internal.core.model.property.IConfigurablePropertyObject;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.AbstractTextPropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.IValueSourcePropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.presentation.ButtonPropertyEditorPresentation;
import org.eclipse.wb.internal.core.model.property.editor.presentation.PropertyEditorPresentation;
import org.eclipse.wb.internal.core.model.property.table.PropertyTable;
import org.eclipse.wb.internal.core.model.util.ScriptUtils;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.utils.state.EditorState;
import org.eclipse.wb.internal.core.utils.ui.UiUtils;
import org.eclipse.wb.internal.core.utils.ui.dialogs.ReusableDialog;

public final class DatePropertyEditor
extends AbstractTextPropertyEditor
implements IValueSourcePropertyEditor,
IConfigurablePropertyObject {
    private EditorState m_state;
    private String m_toStringScript;
    private String m_toDateScript;
    private String m_functions;
    private String m_sourceTemplate;
    private boolean m_isLongValue;
    private final PropertyEditorPresentation PRESENTATION = new ButtonPropertyEditorPresentation(){

        protected Image getImage() {
            return DesignerPlugin.getImage((String)"properties/dt.png");
        }

        protected void onClick(PropertyTable propertyTable, Property property) throws Exception {
            DateDialog dialog = new DateDialog(DesignerPlugin.getShell());
            if (property.getValue() != null && property.getValue() != Property.UNKNOWN_VALUE) {
                if (DatePropertyEditor.this.m_isLongValue) {
                    dialog.setValue((Long)property.getValue());
                } else {
                    dialog.setValue((Date)property.getValue());
                }
            }
            if (dialog.open() == 0) {
                property.setValue((Object)dialog.getValue());
            }
        }
    };

    public PropertyEditorPresentation getPresentation() {
        return this.PRESENTATION;
    }

    public String getText(Property property) throws Exception {
        Object value = property.getValue();
        if (value instanceof Long) {
            value = new Date((Long)value);
        }
        if (value instanceof Date) {
            TreeMap variables = Maps.newTreeMap();
            if (property instanceof GenericProperty) {
                GenericProperty genericProperty = (GenericProperty)property;
                variables.put("control", genericProperty.getJavaInfo().getObject());
            }
            variables.put("value", value);
            return (String)this.evaluate(this.m_toStringScript, variables);
        }
        return null;
    }

    protected String getEditorText(Property property) throws Exception {
        return this.getText(property);
    }

    protected boolean setEditorText(Property property, String text) throws Exception {
        Object value;
        String valueText = text.trim();
        if (valueText.length() == 0) {
            value = Property.UNKNOWN_VALUE;
        } else {
            try {
                TreeMap variables = Maps.newTreeMap();
                variables.put("value", valueText);
                if (property instanceof GenericProperty) {
                    GenericProperty genericProperty = (GenericProperty)property;
                    variables.put("control", genericProperty.getJavaInfo().getObject());
                }
                value = this.evaluate(this.m_toDateScript, variables);
            }
            catch (Throwable e) {
                UiUtils.openWarning((Shell)DesignerPlugin.getShell(), (String)property.getTitle(), (String)MessageFormat.format(ModelMessages.DatePropertyEditor_notValidDate, valueText));
                return false;
            }
        }
        property.setValue(value);
        return true;
    }

    public String getValueSource(Object value) throws Exception {
        if (value instanceof Date) {
            String source;
            Long millisecs = ReflectionUtils.getFieldLong((Object)value, (String)"fastTime");
            if (StringUtils.isEmpty((String)this.m_sourceTemplate)) {
                source = "new java.util.Date(%millisecs%)";
            } else {
                TreeMap variables = Maps.newTreeMap();
                variables.put("value", value);
                String valueText = (String)this.evaluate(this.m_toStringScript, variables);
                source = StringUtils.replace((String)this.m_sourceTemplate, (String)"%value%", (String)valueText);
            }
            return StringUtils.replace((String)source, (String)"%millisecs%", (String)(String.valueOf(millisecs.toString()) + "L"));
        }
        return value == null ? "(java.util.Date) null" : value.toString();
    }

    @Override
    public void configure(EditorState state, Map<String, Object> parameters) throws Exception {
        this.m_state = state;
        String FUNCTIONS_PARAM = "functions";
        this.m_functions = parameters.containsKey("functions") ? (String)parameters.get("functions") : "";
        String TO_STRING_PARAM = "toString";
        String toStringScript = "";
        if (parameters.containsKey("toString")) {
            toStringScript = (String)parameters.get("toString");
        }
        toStringScript = StringUtils.isEmpty((String)toStringScript) ? StringUtils.join((Object[])new String[]{"import java.text.SimpleDateFormat;", this.m_functions, "(new SimpleDateFormat()).format(value)"}) : String.valueOf(this.m_functions) + "\n" + toStringScript;
        this.m_toStringScript = toStringScript;
        String TO_DATE_PARAM = "toDate";
        String toDateScript = "";
        if (parameters.containsKey("toDate")) {
            toDateScript = (String)parameters.get("toDate");
        }
        toDateScript = StringUtils.isEmpty((String)toDateScript) ? StringUtils.join((Object[])new String[]{"import java.text.SimpleDateFormat;", this.m_functions, "(new java.text.SimpleDateFormat()).parse(value)"}) : String.valueOf(this.m_functions) + "\n" + toDateScript;
        this.m_toDateScript = toDateScript;
        String SOURCE_PARAM = "source";
        this.m_sourceTemplate = parameters.containsKey("source") ? (String)parameters.get("source") : "";
        String IS_LONG_VALUE_PARAM = "isLongValue";
        this.m_isLongValue = parameters.containsKey("isLongValue") ? ((String)parameters.get("isLongValue")).equals("true") : false;
    }

    private Object evaluate(String script, Map<String, Object> variables) throws Exception {
        if (this.m_state == null) {
            return ScriptUtils.evaluate((String)script, variables);
        }
        return ScriptUtils.evaluate((ClassLoader)this.m_state.getEditorLoader(), (String)script, variables);
    }

    public static class DateDialog
    extends ReusableDialog {
        private Date m_value;
        private boolean m_changed;
        private CDateTime m_control;

        public DateDialog(Shell parentShell) {
            super(parentShell);
        }

        protected void onBeforeOpen() {
            super.onBeforeOpen();
            this.m_changed = false;
        }

        public void setValue(Date value) {
            this.m_value = value;
        }

        public void setValue(Long value) {
            this.m_value = new Date(value);
        }

        public Date getValue() {
            if (this.isChanged()) {
                this.m_value = this.m_control.getSelection();
            }
            return this.m_value;
        }

        public boolean isChanged() {
            return this.m_changed;
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText(ModelMessages.DatePropertyEditor_dialogTitle);
        }

        protected Control createDialogArea(Composite parent) {
            Composite area = (Composite)super.createDialogArea(parent);
            area.setLayout((Layout)new FillLayout());
            this.m_control = new CDateTime(area, 18874372);
            this.m_control.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    m_changed = true;
                }
            });
            this.m_control.setSelection(this.m_value);
            return area;
        }
    }
}

