/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.xml.editor.palette.command;

import java.util.List;
import java.util.ListIterator;
import org.eclipse.wb.internal.core.xml.editor.palette.command.Command;
import org.eclipse.wb.internal.core.xml.editor.palette.model.CategoryInfo;
import org.eclipse.wb.internal.core.xml.editor.palette.model.EntryInfo;
import org.eclipse.wb.internal.core.xml.editor.palette.model.PaletteInfo;
import org.xml.sax.Attributes;

public final class EntryMoveCommand
extends Command {
    public static final String ID = "moveEntry";
    private final String m_id;
    private final String m_categoryId;
    private final String m_nextEntryId;

    public EntryMoveCommand(EntryInfo entry, CategoryInfo category, EntryInfo nextEntry) {
        this.m_id = entry.getId();
        this.m_categoryId = category.getId();
        this.m_nextEntryId = nextEntry != null ? nextEntry.getId() : null;
    }

    public EntryMoveCommand(Attributes attributes) {
        this.m_id = attributes.getValue("id");
        this.m_categoryId = attributes.getValue("category");
        this.m_nextEntryId = attributes.getValue("nextEntry");
    }

    @Override
    public void execute(PaletteInfo palette) {
        EntryInfo entry = palette.getEntry(this.m_id);
        if (entry == null) {
            return;
        }
        CategoryInfo category = palette.getCategory(this.m_categoryId);
        if (category == null) {
            return;
        }
        if (this.m_id.equals(this.m_nextEntryId)) {
            return;
        }
        entry.getCategory().removeEntry(entry);
        EntryInfo nextEntry = palette.getEntry(this.m_nextEntryId);
        if (nextEntry != null) {
            int index = category.getEntries().indexOf(nextEntry);
            category.addEntry(index, entry);
        } else {
            category.addEntry(entry);
        }
    }

    @Override
    protected void addAttributes() {
        this.addAttribute("id", this.m_id);
        this.addAttribute("category", this.m_categoryId);
        this.addAttribute("nextEntry", this.m_nextEntryId);
    }

    @Override
    public void addToCommandList(List<Command> commands) {
        ListIterator<Command> I = commands.listIterator(commands.size());
        while (I.hasPrevious()) {
            Command command = I.previous();
            if (!(command instanceof EntryMoveCommand)) continue;
            EntryMoveCommand moveCommand = (EntryMoveCommand)command;
            if (this.m_id.equals(moveCommand.m_id)) {
                I.remove();
                continue;
            }
            if (this.m_id.equals(moveCommand.m_nextEntryId)) break;
        }
        commands.add(this);
    }
}

