/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.transport.sshd.pkcs11;

import java.io.IOException;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.security.auth.login.FailedLoginException;
import org.apache.sshd.agent.SshAgent;
import org.apache.sshd.agent.SshAgentKeyConstraint;
import org.apache.sshd.client.auth.pubkey.KeyAgentIdentity;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.signature.BuiltinSignatures;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.internal.transport.sshd.pkcs11.SecurityCallback;
import org.eclipse.jgit.transport.URIish;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pkcs11Provider {
    private static final Logger LOG = LoggerFactory.getLogger(Pkcs11Provider.class);
    private static final SshAgent NULL_AGENT = new SshAgent(){

        public boolean isOpen() {
            return true;
        }

        public void close() throws IOException {
        }

        public Iterable<? extends Map.Entry<PublicKey, String>> getIdentities() throws IOException {
            throw new UnsupportedOperationException();
        }

        public Map.Entry<String, byte[]> sign(SessionContext session, PublicKey key, String algo, byte[] data) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void addIdentity(KeyPair key, String comment, SshAgentKeyConstraint ... constraints) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void removeIdentity(PublicKey key) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void removeAllIdentities() throws IOException {
            throw new UnsupportedOperationException();
        }
    };
    private static final Map<String, Pkcs11Provider> PROVIDERS = new ConcurrentHashMap<String, Pkcs11Provider>();
    private static final AtomicInteger COUNT = new AtomicInteger();
    private final Provider provider;
    private final SecurityCallback prompter;
    private final KeyStore.Builder builder;
    private KeyStore keys;

    public static Pkcs11Provider getProvider(@NonNull Path library, int slotListIndex) throws IOException {
        int slotIndex = slotListIndex < 0 ? 0 : slotListIndex;
        Path libPath = library.toAbsolutePath();
        String key = String.valueOf(libPath.toString()) + '/' + slotIndex;
        return PROVIDERS.computeIfAbsent(key, sharedLib -> {
            Provider pkcs11 = Security.getProvider("SunPKCS11");
            if (pkcs11 == null) {
                throw new UnsupportedOperationException();
            }
            String name = libPath.getFileName().toString().replaceAll("\\s", "");
            name = "JGit-" + slotIndex + '-' + name;
            String property = "pkcs11-" + COUNT.incrementAndGet() + '-' + name;
            System.setProperty(property, libPath.toString());
            String config = "--name = " + name + '\n' + "library = ${" + property + "}\n" + "slotListIndex = " + slotIndex + '\n';
            if (LOG.isDebugEnabled()) {
                LOG.debug("{}: configuring provider with system property {}={} and config:{}{}", new Object[]{name, property, libPath, System.lineSeparator(), config});
            }
            pkcs11 = pkcs11.configure(config);
            String path2 = "pkcs11:?module-path=" + libPath;
            if (slotListIndex > 0) {
                path2 = String.valueOf(path2) + "&slot-list-index=" + slotListIndex;
            }
            SecurityCallback callback = new SecurityCallback(new URIish().setPath(path2));
            return new Pkcs11Provider(pkcs11, callback);
        });
    }

    private Pkcs11Provider(Provider pkcs11, SecurityCallback prompter) {
        this.provider = pkcs11;
        this.prompter = prompter;
        this.builder = KeyStore.Builder.newInstance("PKCS11", this.provider, new KeyStore.CallbackHandlerProtection(prompter));
    }

    private synchronized void load(SessionContext session) throws GeneralSecurityException, IOException {
        if (this.keys == null) {
            int numberOfPrompts = this.prompter.init(session);
            for (int attempt = 0; attempt < numberOfPrompts; ++attempt) {
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("{}: Loading PKCS#11 KeyStore (attempt {})", (Object)this.getName(), (Object)Integer.toString(attempt));
                    }
                    this.keys = this.builder.getKeyStore();
                    this.prompter.passwordTried(null);
                    return;
                }
                catch (GeneralSecurityException e) {
                    if (this.prompter.passwordTried(e) && attempt < numberOfPrompts && this.isWrongPin(e)) continue;
                    throw e;
                }
            }
        }
    }

    synchronized byte[] sign(SessionContext session, String algorithm, String alias, byte[] data) throws GeneralSecurityException, IOException {
        int numberOfPrompts = this.prompter.init(session);
        for (int attempt = 0; attempt < numberOfPrompts; ++attempt) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{}: Signing with PKCS#11 key {}, algorithm {} (attempt {})", new Object[]{this.getName(), alias, algorithm, Integer.toString(attempt)});
                }
                Signature signer = Signature.getInstance(algorithm, this.provider);
                PrivateKey privKey = (PrivateKey)this.keys.getKey(alias, null);
                signer.initSign(privKey);
                signer.update(data);
                byte[] signature = signer.sign();
                this.prompter.passwordTried(null);
                return signature;
            }
            catch (GeneralSecurityException e) {
                if (this.prompter.passwordTried(e) && attempt < numberOfPrompts && this.isWrongPin(e)) continue;
                throw e;
            }
        }
        return null;
    }

    private boolean isWrongPin(Throwable e) {
        Throwable t = e;
        while (t != null) {
            if (t instanceof FailedLoginException) {
                return true;
            }
            t = t.getCause();
        }
        return false;
    }

    public String getName() {
        return this.provider.getName();
    }

    public Iterable<KeyAgentIdentity> getKeys(SessionContext session) throws IOException, GeneralSecurityException {
        this.load(session);
        ArrayList<KeyAgentIdentity> result = new ArrayList<KeyAgentIdentity>(2);
        Enumeration<String> aliases = this.keys.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            Certificate certificate = this.keys.getCertificate(alias);
            if (certificate == null) continue;
            PublicKey pubKey = certificate.getPublicKey();
            if (pubKey == null) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("{}: certificate {} has no public key??", (Object)this.getName(), (Object)alias);
                continue;
            }
            if (LOG.isDebugEnabled()) {
                if (certificate instanceof X509Certificate) {
                    String msg;
                    X509Certificate x509 = (X509Certificate)certificate;
                    try {
                        x509.checkValidity();
                        msg = "Certificate is valid";
                    }
                    catch (CertificateExpiredException | CertificateNotYetValidException e) {
                        msg = "Certificate is INVALID";
                    }
                    boolean[] usage = x509.getKeyUsage();
                    if (usage != null) {
                        msg = String.valueOf(msg) + ", signing " + (usage[0] ? "allowed" : "NOT allowed");
                    }
                    LOG.debug("{}: Loaded X.509 certificate {}, key type {}. {}.", new Object[]{this.getName(), alias, pubKey.getAlgorithm(), msg});
                } else {
                    LOG.debug("{}: Loaded certificate {}, key type {}.", new Object[]{this.getName(), alias, pubKey.getAlgorithm()});
                }
            }
            result.add(new Pkcs11Identity(pubKey, alias));
        }
        return result;
    }

    private class Pkcs11Identity
    extends KeyAgentIdentity {
        Pkcs11Identity(PublicKey key, String alias) {
            super(NULL_AGENT, key, alias);
        }

        public Map.Entry<String, byte[]> sign(SessionContext session, String algo, byte[] data) throws Exception {
            BuiltinSignatures factory = BuiltinSignatures.fromFactoryName((String)algo);
            String javaSignatureName = ((org.apache.sshd.common.signature.Signature)factory.create()).getAlgorithm();
            return new AbstractMap.SimpleImmutableEntry<String, byte[]>(algo, Pkcs11Provider.this.sign(session, javaSignatureName, this.getComment(), data));
        }
    }
}

