/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui.internal.utils;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.annotation.Nullable;

public abstract class MarkerConfig {
    public final String tag;
    public final Type type;

    public static Set<MarkerConfig> getDefaults() {
        HashSet<MarkerConfig> defaults = new HashSet<MarkerConfig>();
        defaults.add(new ProblemMarkerConfig("ATTN", ProblemSeverity.INFO));
        defaults.add(new ProblemMarkerConfig("NOTE", ProblemSeverity.INFO));
        defaults.add(new TaskMarkerConfig("BUG", TaskPriority.HIGH));
        defaults.add(new TaskMarkerConfig("FIXME", TaskPriority.HIGH));
        defaults.add(new TaskMarkerConfig("HACK", TaskPriority.NORMAL));
        defaults.add(new TaskMarkerConfig("OPTIMIZE", TaskPriority.NORMAL));
        defaults.add(new TaskMarkerConfig("TODO", TaskPriority.NORMAL));
        defaults.add(new TaskMarkerConfig("XXX", TaskPriority.NORMAL));
        return defaults;
    }

    private MarkerConfig(String tag, Type type) {
        this.tag = tag;
        this.type = type;
    }

    public boolean isProblem() {
        return this.type == Type.PROBLEM;
    }

    public boolean isTask() {
        return this.type == Type.TASK;
    }

    public ProblemMarkerConfig asProblemMarkerConfig() {
        return (ProblemMarkerConfig)this;
    }

    public TaskMarkerConfig asTaskMarkerConfig() {
        return (TaskMarkerConfig)this;
    }

    public static final class ProblemMarkerConfig
    extends MarkerConfig {
        public final ProblemSeverity severity;

        public ProblemMarkerConfig(String tag, ProblemSeverity severity) {
            super(tag, Type.PROBLEM);
            this.severity = severity;
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            Object object = obj;
            if (object instanceof ProblemMarkerConfig) {
                void other;
                ProblemMarkerConfig problemMarkerConfig = (ProblemMarkerConfig)object;
                ProblemMarkerConfig cfr_ignored_0 = (ProblemMarkerConfig)object;
                return this.type == other.type && this.severity == other.severity && this.tag.equals(other.tag);
            }
            return false;
        }

        public int hashCode() {
            int result = 31 + this.severity.hashCode();
            result = 31 * result + this.tag.hashCode();
            return 31 * result + this.type.hashCode();
        }

        public String toString() {
            return "ProblemMarkerConfig [tag=" + this.tag + ", severity=" + (Object)((Object)this.severity) + "]";
        }
    }

    public static enum ProblemSeverity {
        ERROR(2),
        WARNING(1),
        INFO(0);

        public final int value;

        private ProblemSeverity(int value) {
            this.value = value;
        }
    }

    public static final class TaskMarkerConfig
    extends MarkerConfig {
        public final TaskPriority priority;

        public TaskMarkerConfig(String tag, TaskPriority priority) {
            super(tag, Type.TASK);
            this.priority = priority;
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            Object object = obj;
            if (object instanceof TaskMarkerConfig) {
                void other;
                TaskMarkerConfig taskMarkerConfig = (TaskMarkerConfig)object;
                TaskMarkerConfig cfr_ignored_0 = (TaskMarkerConfig)object;
                return this.type == other.type && this.priority == other.priority && this.tag.equals(other.tag);
            }
            return false;
        }

        public int hashCode() {
            int result = 31 + this.priority.hashCode();
            result = 31 * result + this.tag.hashCode();
            return 31 * result + this.type.hashCode();
        }

        public String toString() {
            return "TaskMarkerConfig [tag=" + this.tag + ", priority=" + (Object)((Object)this.priority) + "]";
        }
    }

    public static enum TaskPriority {
        HIGH(2),
        NORMAL(1),
        LOW(0);

        public final int value;

        private TaskPriority(int value) {
            this.value = value;
        }
    }

    public static enum Type {
        PROBLEM,
        TASK;

    }
}

