/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.ui.actions;

import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.rse.ui.actions.ISystemAction;
import org.eclipse.rse.ui.actions.SystemBaseSubMenuAction;
import org.eclipse.swt.widgets.Shell;

public class SystemSubMenuManager
extends MenuManager {
    protected String toolTipText;
    protected ImageDescriptor image = null;
    protected Shell shell = null;
    protected Viewer viewer = null;
    protected boolean deferPopulation;
    protected boolean traceSelections = false;
    protected String traceTarget;
    protected ISelection selection;
    protected String label;
    protected SystemBaseSubMenuAction parentCascadingAction;

    public SystemSubMenuManager(SystemBaseSubMenuAction parentAction) {
        this.parentCascadingAction = parentAction;
    }

    public SystemSubMenuManager(SystemBaseSubMenuAction parentAction, String text) {
        super(text);
        this.label = text;
        this.parentCascadingAction = parentAction;
    }

    public SystemSubMenuManager(SystemBaseSubMenuAction parentAction, String text, String id) {
        super(text, id);
        this.label = text;
        this.parentCascadingAction = parentAction;
    }

    public SystemSubMenuManager(SystemBaseSubMenuAction parentAction, String text, String id, ImageDescriptor image) {
        super(text, id);
        this.label = text;
        this.image = image;
        this.parentCascadingAction = parentAction;
    }

    public SystemBaseSubMenuAction getParentCascadingAction() {
        return this.parentCascadingAction;
    }

    public void setToolTipText(String tip) {
        this.toolTipText = tip;
    }

    public String getToolTipText() {
        return this.toolTipText;
    }

    public String getLabel() {
        return this.label;
    }

    public void setInputs(Shell shell, Viewer v, ISelection selection) {
        if (this.traceSelections) {
            this.issueTraceMessage(" INSIDE SETINPUTS FOR SUBMENUMGR FOR '" + this.label + "'");
        }
        this.shell = shell;
        this.viewer = v;
        this.selection = selection;
        if (this.parentCascadingAction != null) {
            this.parentCascadingAction.setInputsFromSubMenuManager(shell, v, selection);
        }
        this.cascadeAllInputs();
    }

    public void setShell(Shell shell) {
        this.shell = shell;
        IContributionItem[] items = this.getItems();
        int idx = 0;
        while (idx < items.length) {
            Object item;
            if (items[idx] instanceof ActionContributionItem && ((ActionContributionItem)items[idx]).getAction() instanceof ISystemAction) {
                item = (ISystemAction)((ActionContributionItem)items[idx]).getAction();
                item.setShell(shell);
            } else if (items[idx] instanceof SystemSubMenuManager) {
                item = (SystemSubMenuManager)items[idx];
                ((SystemSubMenuManager)((Object)item)).setShell(shell);
            }
            ++idx;
        }
        if (this.traceSelections) {
            this.issueTraceMessage("*** INSIDE SETSHELL FOR SUBMENUMGR " + this.label + ". #ITEMS = " + items.length);
        }
    }

    public void setSelection(ISelection selection) {
        this.selection = selection;
        IContributionItem[] items = this.getItems();
        int idx = 0;
        while (idx < items.length) {
            Object item;
            if (items[idx] instanceof ActionContributionItem && ((ActionContributionItem)items[idx]).getAction() instanceof ISystemAction) {
                item = (ISystemAction)((ActionContributionItem)items[idx]).getAction();
                item.setSelection(selection);
            } else if (items[idx] instanceof SystemSubMenuManager) {
                item = (SystemSubMenuManager)items[idx];
                ((SystemSubMenuManager)((Object)item)).setSelection(selection);
            }
            ++idx;
        }
        if (this.traceSelections) {
            this.issueTraceMessage("*** INSIDE SETSELECTION FOR SUBMENUMGR" + this.label + ". #ITEMS = " + items.length);
        }
    }

    public void setViewer(Viewer v) {
        this.viewer = v;
        IContributionItem[] items = this.getItems();
        int idx = 0;
        while (idx < items.length) {
            Object item;
            if (items[idx] instanceof ActionContributionItem && ((ActionContributionItem)items[idx]).getAction() instanceof ISystemAction) {
                item = (ISystemAction)((ActionContributionItem)items[idx]).getAction();
                item.setViewer(this.viewer);
            } else if (items[idx] instanceof SystemSubMenuManager) {
                item = (SystemSubMenuManager)items[idx];
                ((SystemSubMenuManager)((Object)item)).setViewer(this.viewer);
            }
            ++idx;
        }
    }

    public Viewer getViewer() {
        return this.viewer;
    }

    public Shell getShell() {
        return this.shell;
    }

    public IStructuredSelection getSelection() {
        return (IStructuredSelection)this.selection;
    }

    public void appendToGroup(String groupName, IAction action) {
        super.appendToGroup(groupName, action);
        if (action instanceof ISystemAction) {
            this.cascadeAllInputs((ISystemAction)action);
        }
    }

    public void appendToGroup(String groupName, IContributionItem item) {
        super.appendToGroup(groupName, item);
        if (item instanceof SystemSubMenuManager) {
            this.cascadeAllInputs((SystemSubMenuManager)item);
        }
    }

    public void add(IContributionItem item) {
        super.add(item);
        if (item instanceof ActionContributionItem) {
            IAction action = ((ActionContributionItem)item).getAction();
            if (action instanceof ISystemAction) {
                this.cascadeAllInputs((ISystemAction)action);
            }
        } else if (item instanceof SystemSubMenuManager) {
            this.cascadeAllInputs((SystemSubMenuManager)item);
        }
    }

    protected void cascadeAllInputs() {
        IContributionItem[] items = this.getItems();
        if (this.traceSelections) {
            this.issueTraceMessage("INSIDE CASCADEALLINPUTS FOR SUBMENUMGR FOR " + this.label + ". NBR ITEMS = " + items.length);
        }
        int idx = 0;
        while (idx < items.length) {
            Object item;
            if (items[idx] instanceof ActionContributionItem && ((ActionContributionItem)items[idx]).getAction() instanceof ISystemAction) {
                item = (ISystemAction)((ActionContributionItem)items[idx]).getAction();
                if (!item.isDummy()) {
                    this.cascadeAllInputs((ISystemAction)item);
                }
            } else if (items[idx] instanceof SystemSubMenuManager) {
                item = (SystemSubMenuManager)items[idx];
                this.cascadeAllInputs((SystemSubMenuManager)((Object)item));
            }
            ++idx;
        }
    }

    protected void cascadeAllInputs(ISystemAction action) {
        if (action.isDummy()) {
            return;
        }
        if (this.shell != null) {
            action.setShell(this.shell);
        }
        if (this.viewer != null) {
            action.setViewer(this.viewer);
        }
        if (this.selection != null) {
            action.setSelection(this.selection);
        }
    }

    protected void cascadeAllInputs(SystemSubMenuManager submenu) {
        if (this.shell != null) {
            submenu.setShell(this.shell);
        }
        if (this.viewer != null) {
            submenu.setViewer(this.viewer);
        }
        if (this.selection != null) {
            submenu.setSelection(this.selection);
        }
    }

    public void setTracing(boolean tracing) {
        this.traceSelections = tracing;
    }

    public void setTracing(String tracingClassTarget) {
        this.traceSelections = tracingClassTarget != null;
        this.traceTarget = tracingClassTarget;
    }

    public void setTracing(boolean tracing, String tracingClassTarget) {
        this.traceSelections = tracing;
        this.traceTarget = tracingClassTarget;
    }

    protected void issueTraceMessage(String msg) {
        if (this.traceSelections) {
            String className = ((Object)((Object)this)).getClass().getName();
            if (this.traceTarget == null || className.indexOf(this.traceTarget) >= 0) {
                className = className.substring(className.lastIndexOf(46));
                SystemBasePlugin.logInfo(String.valueOf(className) + ": " + msg);
            }
        }
    }
}

