/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.server;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.lsp4e.server.StreamConnectionProvider;

public abstract class ProcessStreamConnectionProvider
implements StreamConnectionProvider {
    private @Nullable Process process;
    private List<String> commands;
    private @Nullable String workingDir;

    protected ProcessStreamConnectionProvider() {
    }

    protected ProcessStreamConnectionProvider(List<String> commands) {
        this.commands = commands;
    }

    protected ProcessStreamConnectionProvider(List<String> commands, String workingDir) {
        this.commands = commands;
        this.workingDir = workingDir;
    }

    @Override
    public void start() throws IOException {
        Process p;
        if (this.commands == null || this.commands.isEmpty() || this.commands.stream().anyMatch(Objects::isNull)) {
            throw new IOException("Unable to start language server: " + this);
        }
        ProcessBuilder builder = this.createProcessBuilder();
        this.process = p = builder.start();
        if (!p.isAlive()) {
            throw new IOException("Unable to start language server: " + this);
        }
    }

    protected ProcessBuilder createProcessBuilder() {
        ProcessBuilder builder = new ProcessBuilder(this.getCommands());
        if (this.getWorkingDirectory() != null) {
            builder.directory(new File(this.getWorkingDirectory()));
        }
        builder.redirectError(ProcessBuilder.Redirect.INHERIT);
        return builder;
    }

    @Override
    public @Nullable InputStream getInputStream() {
        Process p = this.process;
        return p == null ? null : p.getInputStream();
    }

    @Override
    public @Nullable InputStream getErrorStream() {
        Process p = this.process;
        return p == null ? null : p.getErrorStream();
    }

    @Override
    public @Nullable OutputStream getOutputStream() {
        Process p = this.process;
        return p == null ? null : p.getOutputStream();
    }

    @Override
    public void stop() {
        Process p = this.process;
        if (p != null) {
            p.destroy();
        }
    }

    protected List<String> getCommands() {
        return this.commands;
    }

    public void setCommands(List<String> commands) {
        this.commands = commands;
    }

    protected @Nullable String getWorkingDirectory() {
        return this.workingDir;
    }

    public void setWorkingDirectory(String workingDir) {
        this.workingDir = workingDir;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        Object object = obj;
        if (object instanceof ProcessStreamConnectionProvider) {
            void other;
            ProcessStreamConnectionProvider processStreamConnectionProvider = (ProcessStreamConnectionProvider)object;
            ProcessStreamConnectionProvider cfr_ignored_0 = (ProcessStreamConnectionProvider)object;
            if (Objects.equals(this.getCommands(), other.getCommands()) && Objects.equals(this.getWorkingDirectory(), other.getWorkingDirectory())) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getCommands(), this.getWorkingDirectory());
    }

    public String toString() {
        return "ProcessStreamConnectionProvider [commands=" + this.getCommands() + ", workingDir=" + this.getWorkingDirectory() + "]";
    }
}

