/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.references;

import java.net.URI;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServers;
import org.eclipse.lsp4e.operations.references.LSSearchResult;
import org.eclipse.lsp4e.ui.Messages;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.ReferenceContext;
import org.eclipse.lsp4j.ReferenceParams;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.osgi.util.NLS;
import org.eclipse.search.internal.ui.text.FileMatch;
import org.eclipse.search.internal.ui.text.FileSearchQuery;
import org.eclipse.search.internal.ui.text.LineElement;
import org.eclipse.search.ui.text.Match;

public class LSSearchQuery
extends FileSearchQuery {
    private final @NonNull IDocument document;
    private final int offset;
    private LSSearchResult result;
    private long startTime;

    public LSSearchQuery(int offset, @NonNull IDocument document) throws BadLocationException {
        super("", false, false, null);
        this.document = document;
        this.offset = offset;
    }

    public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
        this.startTime = System.currentTimeMillis();
        this.getSearchResult().removeAll();
        try {
            ReferenceParams params = new ReferenceParams();
            params.setContext(new ReferenceContext(false));
            params.setTextDocument(LSPEclipseUtils.toTextDocumentIdentifier(this.document));
            params.setPosition(LSPEclipseUtils.toPosition(this.offset, this.document));
            ((LanguageServers.LanguageServerDocumentExecutor)LanguageServers.forDocument(this.document).withCapability(ServerCapabilities::getReferencesProvider)).collectAll(languageServer -> ((CompletableFuture)languageServer.getTextDocumentService().references(params).thenAcceptAsync(locations -> {
                if (locations != null) {
                    locations.stream().filter(Objects::nonNull).map(LSSearchQuery::toMatch).filter(Objects::nonNull).forEach(arg_0 -> ((LSSearchResult)this.result).addMatch(arg_0));
                }
            })).exceptionally(e -> {
                LanguageServerPlugin.logError(e);
                return null;
            }));
            return Status.OK_STATUS;
        }
        catch (Exception ex) {
            return new Status(4, LanguageServerPlugin.getDefault().getBundle().getSymbolicName(), ex.getMessage(), (Throwable)ex);
        }
    }

    private static Match toMatch(@NonNull Location location) {
        IResource resource = LSPEclipseUtils.findResourceFor(location.getUri());
        if (resource != null) {
            boolean temporaryLoadDocument;
            IDocument document = LSPEclipseUtils.getExistingDocument(resource);
            boolean bl = temporaryLoadDocument = document == null;
            if (temporaryLoadDocument) {
                document = LSPEclipseUtils.getDocument(resource);
            }
            if (document != null) {
                try {
                    int startOffset = LSPEclipseUtils.toOffset(location.getRange().getStart(), document);
                    int endOffset = LSPEclipseUtils.toOffset(location.getRange().getEnd(), document);
                    IRegion lineInformation = document.getLineInformationOfOffset(startOffset);
                    LineElement lineEntry = new LineElement(resource, document.getLineOfOffset(startOffset), lineInformation.getOffset(), document.get(lineInformation.getOffset(), lineInformation.getLength()));
                    FileMatch fileMatch = new FileMatch((IFile)resource, startOffset, endOffset - startOffset, lineEntry);
                    return fileMatch;
                }
                catch (BadLocationException ex) {
                    LanguageServerPlugin.logError(ex);
                }
                finally {
                    if (temporaryLoadDocument) {
                        try {
                            FileBuffers.getTextFileBufferManager().disconnect(resource.getFullPath(), LocationKind.IFILE, (IProgressMonitor)new NullProgressMonitor());
                        }
                        catch (CoreException e) {
                            LanguageServerPlugin.logError(e);
                        }
                    }
                }
            }
            Position startPosition = location.getRange().getStart();
            LineElement lineEntry = new LineElement(resource, startPosition.getLine(), 0, String.format("%s:%s", startPosition.getLine(), startPosition.getCharacter()));
            return new FileMatch((IFile)resource, 0, 0, lineEntry);
        }
        return null;
    }

    public LSSearchResult getSearchResult() {
        if (this.result == null) {
            this.result = new LSSearchResult(this);
        }
        return this.result;
    }

    public String getLabel() {
        return Messages.LSSearchQuery_label;
    }

    public String getResultLabel(int nMatches) {
        Position position;
        URI uri;
        long time = 0L;
        if (this.startTime > 0L) {
            time = System.currentTimeMillis() - this.startTime;
        }
        String filename = (uri = LSPEclipseUtils.toUri(this.document)) != null ? Path.fromPortableString((String)uri.getPath()).lastSegment() : "unkown";
        try {
            position = LSPEclipseUtils.toPosition(this.offset, this.document);
        }
        catch (BadLocationException ex) {
            LanguageServerPlugin.logError(ex);
            position = new Position(0, 0);
        }
        if (nMatches == 1) {
            return NLS.bind((String)Messages.LSSearchQuery_singularReference, (Object[])new Object[]{filename, position.getLine() + 1, position.getCharacter() + 1, time});
        }
        return NLS.bind((String)Messages.LSSearchQuery_pluralReferences, (Object[])new Object[]{filename, position.getLine() + 1, position.getCharacter() + 1, nMatches, time});
    }

    public boolean isFileNameSearch() {
        return false;
    }
}

