/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.rename;

import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.lsp4e.operations.rename.LSPRenameProcessor;
import org.eclipse.lsp4e.ui.Messages;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class LSPRenameRefactoringWizard
extends RefactoringWizard {
    public LSPRenameRefactoringWizard(Refactoring refactoring) {
        super(refactoring, 4);
        super.setWindowTitle(Messages.rename_title);
    }

    protected void addUserInputPages() {
        LSPRenameProcessor processor = (LSPRenameProcessor)((Object)this.getRefactoring().getAdapter(LSPRenameProcessor.class));
        this.addPage((IWizardPage)new RenameInputWizardPage(processor));
    }

    class RenameInputWizardPage
    extends UserInputWizardPage {
        private Text nameText;
        private final LSPRenameProcessor processor;

        RenameInputWizardPage(LSPRenameProcessor processor) {
            super(RenameInputWizardPage.class.getSimpleName());
            this.processor = processor;
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout(2, false));
            composite.setLayoutData((Object)new GridData(4, 4, true, true));
            composite.setFont(parent.getFont());
            Label label = new Label(composite, 0);
            label.setLayoutData((Object)new GridData());
            label.setText(Messages.rename_label);
            this.nameText = new Text(composite, 2048);
            this.nameText.setText(this.processor.getPlaceholder());
            this.nameText.setFont(composite.getFont());
            this.nameText.setLayoutData((Object)new GridData(4, 1, true, false));
            this.nameText.addModifyListener(e -> this.validatePage());
            this.nameText.selectAll();
            this.setControl((Control)composite);
            this.validatePage();
        }

        public IWizardPage getNextPage() {
            this.setNewName();
            return super.getNextPage();
        }

        public void setVisible(boolean visible) {
            if (visible) {
                this.nameText.setFocus();
            }
            super.setVisible(visible);
        }

        protected boolean performFinish() {
            this.setNewName();
            return super.performFinish();
        }

        private void setNewName() {
            this.processor.setNewName(this.nameText.getText());
        }

        private final void validatePage() {
            RefactoringStatus status = this.validateName();
            this.setPageComplete(status);
        }

        private RefactoringStatus validateName() {
            if (this.nameText.getText().trim().length() == 0) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.rename_processor_required);
            }
            return new RefactoringStatus();
        }
    }
}

