import { DebugProtocol } from 'vscode-debugprotocol';
export declare type ExceptionType = 'uncaughtException' | 'unhandledRejection' | 'firstChance';
export interface IExecutionResultTelemetryProperties {
    successful?: 'true' | 'false';
    exceptionType?: ExceptionType;
    exceptionMessage?: string;
    exceptionName?: string;
    exceptionStack?: string;
    exceptionId?: string;
    startTime?: string;
    timeTakenInMilliseconds?: string;
}
export interface ITelemetryReporter {
    reportEvent(name: string, data?: any): void;
    setupEventHandler(_sendEvent: (event: DebugProtocol.Event) => void): void;
}
export declare class TelemetryReporter implements ITelemetryReporter {
    private _sendEvent;
    private _globalTelemetryProperties;
    reportEvent(name: string, data?: any): void;
    setupEventHandler(_sendEvent: (event: DebugProtocol.Event) => void): void;
    addCustomGlobalProperty(additionalGlobalTelemetryProperties: any): void;
}
export declare class AsyncGlobalPropertiesTelemetryReporter implements ITelemetryReporter {
    private _telemetryReporter;
    private _actionsQueue;
    constructor(_telemetryReporter: TelemetryReporter);
    reportEvent(name: string, data?: any): void;
    setupEventHandler(_sendEvent: (event: DebugProtocol.Event) => void): void;
    addCustomGlobalProperty(additionalGlobalPropertiesPromise: Promise<any> | any): void;
    private reportErrorWhileWaitingForProperty(rejection);
}
export declare class NullTelemetryReporter implements ITelemetryReporter {
    reportEvent(name: string, data?: any): void;
    setupEventHandler(_sendEvent: (event: DebugProtocol.Event) => void): void;
}
export declare const DefaultTelemetryIntervalInMilliseconds = 10000;
export declare class BatchTelemetryReporter {
    private _telemetryReporter;
    private _cadenceInMilliseconds;
    private _eventBuckets;
    private _timer;
    constructor(_telemetryReporter: ITelemetryReporter, _cadenceInMilliseconds?: number);
    reportEvent(name: string, data?: any): void;
    finalize(): void;
    private setup();
    private reset();
    private send();
    /**
     * Transfrom the bucket of events data from the form:
     * [{
     *  p1: v1,
     *  p2: v2
     * },
     * {
     *  p1: w1,
     *  p2: w2
     *  p3: w3
     * }]
     *
     * to
     * {
     *   p1: [v1,   w1],
     *   p2: [v2,   w2],
     *   p3: [null, w3]
     * }
     *
     *
     * The later form is easier for downstream telemetry analysis.
     */
    private static transfromBucketData(bucketForEventType);
    /**
     * Get the property keys from all the entries of a event bucket:
     *
     * So
     * [{
     *  p1: v1,
     *  p2: v2
     * },
     * {
     *  p1: w1,
     *  p2: w2
     *  p3: w3
     * }]
     *
     * will return ['p1', 'p2', 'p3']
     */
    private static collectPropertyNamesFromAllEvents(bucket);
}
export interface ITelemetryPropertyCollector {
    getProperties(): {
        [propertyName: string]: string;
    };
    addTelemetryProperty(propertyName: string, value: string): void;
}
export declare class TelemetryPropertyCollector implements ITelemetryPropertyCollector {
    private _properties;
    getProperties(): {
        [propertyName: string]: string;
    };
    addTelemetryProperty(propertyName: string, value: string): void;
}
export declare const telemetry: AsyncGlobalPropertiesTelemetryReporter;
