/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.matcher;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.core.internal.matcher.Matcher;
import org.eclipse.tm4e.core.internal.matcher.MatcherWithPriority;
import org.eclipse.tm4e.core.internal.matcher.NameMatcher;

final class MatcherBuilder<T> {
    private static final System.Logger LOGGER = System.getLogger(MatcherBuilder.class.getName());
    final List<MatcherWithPriority<T>> results = new ArrayList<MatcherWithPriority<T>>();
    private final Tokenizer tokenizer;
    private final NameMatcher<T> matchesName;
    private @Nullable String token;

    MatcherBuilder(String selector, NameMatcher<T> matchesName) {
        this.tokenizer = new Tokenizer(selector);
        this.matchesName = matchesName;
        String token = this.token = this.tokenizer.next();
        while (token != null) {
            int priority = 0;
            if (token.length() == 2 && token.charAt(1) == ':') {
                switch (token.charAt(0)) {
                    case 'R': {
                        priority = 1;
                        break;
                    }
                    case 'L': {
                        priority = -1;
                        break;
                    }
                    default: {
                        LOGGER.log(System.Logger.Level.WARNING, "Unknown priority %s in scope selector %s", token, selector);
                    }
                }
                this.token = this.tokenizer.next();
            }
            Matcher<T> matcher = this.parseConjunction();
            this.results.add(new MatcherWithPriority<T>(matcher, priority));
            if (!",".equals(this.token)) break;
            token = this.token = this.tokenizer.next();
        }
    }

    private @Nullable Matcher<T> parseOperand() {
        if ("-".equals(this.token)) {
            this.token = this.tokenizer.next();
            Matcher expressionToNegate = this.parseOperand();
            return matcherInput -> expressionToNegate != null && !expressionToNegate.matches(matcherInput);
        }
        if ("(".equals(this.token)) {
            this.token = this.tokenizer.next();
            Matcher<T> expressionInParents = this.parseInnerExpression();
            if (")".equals(this.token)) {
                this.token = this.tokenizer.next();
            }
            return expressionInParents;
        }
        String token = this.token;
        if (token != null && this.isIdentifier(token)) {
            ArrayList<String> identifiers = new ArrayList<String>();
            do {
                identifiers.add(token);
            } while ((token = (this.token = this.tokenizer.next())) != null && this.isIdentifier(token));
            return matcherInput -> this.matchesName.matches(identifiers, matcherInput);
        }
        return null;
    }

    private Matcher<T> parseConjunction() {
        ArrayList matchers = new ArrayList();
        Matcher<T> matcher = this.parseOperand();
        while (matcher != null) {
            matchers.add(matcher);
            matcher = this.parseOperand();
        }
        return matcherInput -> {
            for (Matcher matcher1 : matchers) {
                if (matcher1.matches(matcherInput)) continue;
                return false;
            }
            return true;
        };
    }

    private Matcher<T> parseInnerExpression() {
        ArrayList matchers = new ArrayList();
        Matcher<T> matcher = this.parseConjunction();
        while (true) {
            matchers.add(matcher);
            if (!"|".equals(this.token) && !",".equals(this.token)) break;
            do {
                this.token = this.tokenizer.next();
            } while ("|".equals(this.token) || ",".equals(this.token));
            matcher = this.parseConjunction();
        }
        return matcherInput -> {
            for (Matcher matcher1 : matchers) {
                if (!matcher1.matches(matcherInput)) continue;
                return true;
            }
            return false;
        };
    }

    private boolean isIdentifier(String token) {
        if (token.isEmpty()) {
            return false;
        }
        int i = 0;
        while (i < token.length()) {
            char ch = token.charAt(i);
            if (!(ch == '.' || ch == ':' || ch == '_' || ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9')) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static final class Tokenizer {
        static final Pattern TOKEN_PATTERN = Pattern.compile("([LR]:|[\\w\\.:][\\w\\.:\\-]*|[\\,\\|\\-\\(\\)])");
        final java.util.regex.Matcher regex;

        Tokenizer(String input) {
            this.regex = TOKEN_PATTERN.matcher(input);
        }

        @Nullable String next() {
            if (!this.regex.find()) {
                return null;
            }
            return this.regex.group();
        }
    }
}

