/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.grammar;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.core.TMException;
import org.eclipse.tm4e.core.internal.grammar.ScopeMetadata;
import org.eclipse.tm4e.core.internal.theme.IThemeProvider;
import org.eclipse.tm4e.core.internal.theme.ThemeTrieElementRule;
import org.eclipse.tm4e.core.internal.utils.RegexSource;

final class ScopeMetadataProvider {
    private static final ScopeMetadata NULL_SCOPE_METADATA = new ScopeMetadata("", 0, 0, null);
    private static final Pattern STANDARD_TOKEN_TYPE_REGEXP = Pattern.compile("\\b(comment|string|regex)\\b");
    private static final String COMMENT_TOKEN_TYPE = "comment";
    private static final String STRING_TOKEN_TYPE = "string";
    private static final String REGEX_TOKEN_TYPE = "regex";
    private static final String META_EMBEDDED_TOKEN_TYPE = "meta.embedded";
    private final int initialLanguage;
    private final IThemeProvider themeProvider;
    private final Map<String, @Nullable ScopeMetadata> cache = new HashMap<String, ScopeMetadata>();
    private ScopeMetadata defaultMetaData;
    private final Map<String, Integer> embeddedLanguages = new HashMap<String, Integer>();
    private @Nullable Pattern embeddedLanguagesRegex;

    ScopeMetadataProvider(int initialLanguage, IThemeProvider themeProvider, @Nullable Map<String, Integer> embeddedLanguages) {
        List escapedScopes;
        this.initialLanguage = initialLanguage;
        this.themeProvider = themeProvider;
        this.defaultMetaData = new ScopeMetadata("", this.initialLanguage, 8, List.of(this.themeProvider.getDefaults()));
        if (embeddedLanguages != null) {
            this.embeddedLanguages.putAll(embeddedLanguages);
        }
        this.embeddedLanguagesRegex = (escapedScopes = this.embeddedLanguages.keySet().stream().map(RegexSource::escapeRegExpCharacters).collect(Collectors.toList())).isEmpty() ? null : Pattern.compile("^((" + escapedScopes.stream().sorted(Collections.reverseOrder()).collect(Collectors.joining(")|(")) + "))($|\\.)");
    }

    void onDidChangeTheme() {
        this.cache.clear();
        this.defaultMetaData = new ScopeMetadata("", this.initialLanguage, 8, List.of(this.themeProvider.getDefaults()));
    }

    ScopeMetadata getDefaultMetadata() {
        return this.defaultMetaData;
    }

    ScopeMetadata getMetadataForScope(@Nullable String scopeName) {
        if (scopeName == null) {
            return NULL_SCOPE_METADATA;
        }
        ScopeMetadata value = this.cache.get(scopeName);
        if (value != null) {
            return value;
        }
        value = this.doGetMetadataForScope(scopeName);
        this.cache.put(scopeName, value);
        return value;
    }

    private ScopeMetadata doGetMetadataForScope(String scopeName) {
        int languageId = this.scopeToLanguage(scopeName);
        int standardTokenType = ScopeMetadataProvider.toStandardTokenType(scopeName);
        List<ThemeTrieElementRule> themeData = this.themeProvider.themeMatch(scopeName);
        return new ScopeMetadata(scopeName, languageId, standardTokenType, themeData);
    }

    private int scopeToLanguage(@Nullable String scope) {
        if (scope == null) {
            return 0;
        }
        Pattern embeddedLanguagesRegex = this.embeddedLanguagesRegex;
        if (embeddedLanguagesRegex == null) {
            return 0;
        }
        Matcher m = embeddedLanguagesRegex.matcher(scope);
        if (!m.find()) {
            return 0;
        }
        return this.embeddedLanguages.getOrDefault(m.group(1), 0);
    }

    private static int toStandardTokenType(String tokenType) {
        String group;
        Matcher m = STANDARD_TOKEN_TYPE_REGEXP.matcher(tokenType);
        if (!m.find()) {
            return 8;
        }
        switch (group = m.group(1)) {
            case "comment": {
                return 1;
            }
            case "string": {
                return 2;
            }
            case "regex": {
                return 3;
            }
            case "meta.embedded": {
                return 0;
            }
        }
        throw new TMException("Unexpected match for standard token type: " + group);
    }
}

