/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Synchronizer;
import org.eclipse.ui.internal.PendingSyncExec;
import org.eclipse.ui.internal.StartupThreading;
import org.eclipse.ui.internal.UILockListener;

public class UISynchronizer
extends Synchronizer {
    protected UILockListener lockListener;
    protected boolean isStarting = true;
    protected List<Runnable> pendingStartup = new ArrayList<Runnable>();
    public static final ThreadLocal<Boolean> startupThread = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }

        @Override
        public void set(Boolean value) {
            if (value != Boolean.TRUE && value != Boolean.FALSE) {
                throw new IllegalArgumentException();
            }
            super.set(value);
        }
    };
    public static final ThreadLocal<Boolean> overrideThread = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }

        @Override
        public void set(Boolean value) {
            if (value != Boolean.TRUE && value != Boolean.FALSE) {
                throw new IllegalArgumentException();
            }
            if (value == Boolean.TRUE && startupThread.get().booleanValue()) {
                throw new IllegalStateException();
            }
            super.set(value);
        }
    };

    public UISynchronizer(Display display, UILockListener lock) {
        super(display);
        this.lockListener = lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void started() {
        UISynchronizer uISynchronizer = this;
        synchronized (uISynchronizer) {
            if (!this.isStarting) {
                throw new IllegalStateException();
            }
            this.isStarting = false;
            for (Runnable runnable : this.pendingStartup) {
                try {
                    super.asyncExec(runnable);
                }
                catch (RuntimeException runtimeException) {}
            }
            this.pendingStartup = null;
            ((Object)((Object)this)).notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void asyncExec(Runnable runnable) {
        if (runnable != null) {
            UISynchronizer uISynchronizer = this;
            synchronized (uISynchronizer) {
                if (this.isStarting && !(runnable instanceof StartupThreading.StartupRunnable) && overrideThread.get() == Boolean.FALSE) {
                    this.pendingStartup.add(runnable);
                    return;
                }
            }
        }
        super.asyncExec(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncExec(Runnable runnable) {
        UISynchronizer uISynchronizer = this;
        synchronized (uISynchronizer) {
            if (this.isStarting && startupThread.get() == Boolean.FALSE && overrideThread.get() == Boolean.FALSE) {
                do {
                    try {
                        ((Object)((Object)this)).wait();
                    }
                    catch (InterruptedException interruptedException) {}
                } while (this.isStarting);
            }
        }
        if (runnable == null || this.lockListener.isUI() || !this.lockListener.isLockOwner()) {
            super.syncExec(runnable);
            return;
        }
        PendingSyncExec work = new PendingSyncExec(runnable);
        work.setOperationThread(Thread.currentThread());
        this.lockListener.addPendingWork(work);
        this.asyncExec(this.lockListener::doPendingWork);
        try {
            work.waitUntilExecuted(this.lockListener);
        }
        catch (InterruptedException interruptedException) {}
    }
}

