/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.languageconfiguration.internal.widgets;

import java.util.Collections;
import java.util.List;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.tm4e.languageconfiguration.internal.LanguageConfigurationMessages;
import org.eclipse.tm4e.languageconfiguration.internal.supports.CharacterPair;

public class CharacterPairsTableWidget
extends TableViewer {
    public CharacterPairsTableWidget(Table table) {
        super(table);
        this.setContentProvider((IContentProvider)new CharacterPairContentProvider());
        this.setLabelProvider((IBaseLabelProvider)new CharacterPairLabelProvider());
        GC gc = new GC((Drawable)table.getShell());
        gc.setFont(JFaceResources.getDialogFont());
        TableColumnLayout columnLayout = new TableColumnLayout();
        TableColumn column1 = new TableColumn(table, 0);
        column1.setText(LanguageConfigurationMessages.CharacterPairsTableWidget_start);
        int minWidth = this.computeMinimumColumnWidth(gc, LanguageConfigurationMessages.CharacterPairsTableWidget_start);
        columnLayout.setColumnData((Widget)column1, (ColumnLayoutData)new ColumnWeightData(2, minWidth, true));
        TableColumn column2 = new TableColumn(table, 0);
        column2.setText(LanguageConfigurationMessages.CharacterPairsTableWidget_end);
        minWidth = this.computeMinimumColumnWidth(gc, LanguageConfigurationMessages.CharacterPairsTableWidget_end);
        columnLayout.setColumnData((Widget)column2, (ColumnLayoutData)new ColumnWeightData(2, minWidth, true));
    }

    protected int computeMinimumColumnWidth(GC gc, String string) {
        return gc.stringExtent((String)string).x + 10;
    }

    protected class CharacterPairContentProvider
    implements IStructuredContentProvider {
        private List<CharacterPair> characterPairList;

        protected CharacterPairContentProvider() {
        }

        public Object[] getElements(Object input) {
            return this.characterPairList.toArray(new CharacterPair[this.characterPairList.size()]);
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.characterPairList = newInput == null ? Collections.EMPTY_LIST : (List)newInput;
        }

        public void dispose() {
            this.characterPairList = null;
        }
    }

    protected class CharacterPairLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        protected CharacterPairLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getText(Object element) {
            return this.getColumnText(element, 0);
        }

        public String getColumnText(Object element, int columnIndex) {
            CharacterPair pair = (CharacterPair)element;
            switch (columnIndex) {
                case 0: {
                    return (String)pair.getKey();
                }
                case 1: {
                    return (String)pair.getValue();
                }
            }
            return "";
        }
    }
}

