/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.egit.core.CommitUtil;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.internal.MergeStrategies;
import org.eclipse.egit.core.internal.job.RuleUtil;
import org.eclipse.egit.core.internal.util.ProjectUtil;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.RebaseCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.errors.IllegalTodoFileModification;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.RebaseTodoLine;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.team.core.TeamException;

public class SquashCommitsOperation
implements IEGitOperation {
    private Repository repository;
    private List<RevCommit> commits;
    private RebaseCommand.InteractiveHandler messageHandler;

    public SquashCommitsOperation(Repository repository, List<RevCommit> commits, RebaseCommand.InteractiveHandler messageHandler) {
        this.repository = repository;
        this.commits = CommitUtil.sortCommits(commits);
        this.messageHandler = messageHandler;
    }

    @Override
    public void execute(IProgressMonitor m) throws CoreException {
        IWorkspaceRunnable action = new IWorkspaceRunnable(){

            public void run(IProgressMonitor pm) throws CoreException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)pm, (int)2);
                progress.subTask(MessageFormat.format(CoreText.SquashCommitsOperation_squashing, SquashCommitsOperation.this.commits.size()));
                RebaseCommand.InteractiveHandler handler = new RebaseCommand.InteractiveHandler(){

                    public void prepareSteps(List<RebaseTodoLine> steps) {
                        RevCommit firstCommit = (this).SquashCommitsOperation.this.commits.get(0);
                        for (RebaseTodoLine step : steps) {
                            if (!this.isRelevant(step.getCommit())) continue;
                            try {
                                if (step.getCommit().prefixCompare((AnyObjectId)firstCommit) == 0) {
                                    step.setAction(RebaseTodoLine.Action.PICK);
                                    continue;
                                }
                                step.setAction(RebaseTodoLine.Action.SQUASH);
                            }
                            catch (IllegalTodoFileModification illegalTodoFileModification) {
                                // empty catch block
                            }
                        }
                    }

                    private boolean isRelevant(AbbreviatedObjectId id) {
                        for (RevCommit commit : (this).SquashCommitsOperation.this.commits) {
                            if (id.prefixCompare((AnyObjectId)commit) != 0) continue;
                            return true;
                        }
                        return false;
                    }

                    public String modifyCommitMessage(String oldMessage) {
                        return (this).SquashCommitsOperation.this.messageHandler.modifyCommitMessage(oldMessage);
                    }
                };
                try {
                    Throwable throwable = null;
                    Object var5_7 = null;
                    try (Git git = new Git(SquashCommitsOperation.this.repository);){
                        RebaseCommand command = git.rebase().setUpstream(SquashCommitsOperation.this.commits.get(0).getParent(0)).runInteractively(handler).setOperation(RebaseCommand.Operation.BEGIN);
                        MergeStrategy strategy = MergeStrategies.getPreferredMergeStrategy();
                        if (strategy != null) {
                            command.setStrategy(strategy);
                        }
                        command.call();
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (GitAPIException e) {
                    throw new TeamException(e.getLocalizedMessage(), e.getCause());
                }
                progress.worked(1);
                ProjectUtil.refreshValidProjects(ProjectUtil.getValidOpenProjects(SquashCommitsOperation.this.repository), (IProgressMonitor)progress.newChild(1));
            }
        };
        ResourcesPlugin.getWorkspace().run(action, this.getSchedulingRule(), 1, m);
    }

    @Override
    public ISchedulingRule getSchedulingRule() {
        return RuleUtil.getRule(this.repository);
    }
}

