"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const chai = __importStar(require("chai"));
const organize_imports_1 = require("./organize-imports");
const test_utils_1 = require("./test-utils");
describe('provideOrganizeImports', () => {
    it('converts tsserver response to lsp code actions', () => {
        const fileName = (0, test_utils_1.filePath)('file');
        const response = {
            body: [
                {
                    fileName,
                    textChanges: []
                }
            ]
        };
        const actual = (0, organize_imports_1.provideOrganizeImports)(response);
        const expected = [{
                title: 'Organize imports',
                kind: 'source.organizeImports',
                command: {
                    title: '',
                    command: '_typescript.organizeImports',
                    arguments: [fileName]
                }
            }];
        chai.assert.deepEqual(actual, expected);
    });
    it('handles a missing response', () => {
        chai.assert.equal((0, organize_imports_1.provideOrganizeImports)(undefined).length, 0);
    });
});
//# sourceMappingURL=organize-imports.spec.js.map