/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.viewers;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.wst.server.ui.ServerUIUtil;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;
import org.eclipse.wst.server.ui.internal.viewers.AbstractTreeContentProvider;
import org.eclipse.wst.server.ui.internal.viewers.ServerPatternFilter;

public abstract class AbstractTreeComposite
extends Composite {
    protected FilteredTree tree;
    protected TreeViewer treeViewer;
    protected Label description;
    protected Button showAdapters;
    protected Link prefLink;
    protected AbstractTreeContentProvider contentProvider;
    boolean showAdaptersLink = false;

    public AbstractTreeComposite(Composite parent) {
        super(parent, 0);
        this.createWidgets();
    }

    protected void createWidgets() {
        GridData data;
        String details;
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 3;
        layout.verticalSpacing = 3;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        this.setLayout((Layout)layout);
        String descriptionText = this.getDescriptionLabel();
        if (descriptionText != null) {
            Label label = new Label((Composite)this, 64);
            label.setText(descriptionText);
            GridData data2 = new GridData(772);
            data2.horizontalSpan = 2;
            label.setLayoutData((Object)data2);
        }
        if ((details = this.getDetailsLabel()) != null) {
            Composite comp = new Composite((Composite)this, 0);
            layout = new GridLayout();
            layout.numColumns = 3;
            comp.setLayout((Layout)layout);
            data = new GridData(128);
            data.horizontalSpan = 2;
            comp.setLayoutData((Object)data);
            Dialog.applyDialogFont((Control)comp);
            if (this.getDetailsLink()) {
                this.showAdapters = new Button(comp, 32);
                this.showAdapters.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        AbstractTreeComposite.this.handleShowAdapterSelection(AbstractTreeComposite.this.showAdapters.getSelection());
                    }
                });
                if (!this.showAdaptersLink && !ServerUIPlugin.getPreferences().getExtAdapter()) {
                    ServerUIPlugin.getPreferences().setExtAdapter(true);
                }
                this.showAdapters.setSelection(ServerUIPlugin.getPreferences().getExtAdapter());
                this.showAdapters.setVisible(this.showAdaptersLink);
            }
            this.prefLink = new Link(comp, 0);
            this.prefLink.setText("<a>" + details + "</a>");
            this.prefLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AbstractTreeComposite.this.detailsSelected();
                }
            });
            if (this.getDetailsLink()) {
                this.prefLink.setEnabled(!ServerUIPlugin.getPreferences().getExtAdapter());
            }
            this.prefLink.setVisible(this.showAdaptersLink);
        }
        Label label = new Label((Composite)this, 64);
        label.setText(this.getTitleLabel());
        data = new GridData(772);
        if (descriptionText != null && details == null) {
            data.verticalIndent = 7;
        }
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        this.createTree();
        data = new GridData(1808);
        data.horizontalSpan = 2;
        this.tree.setLayoutData((Object)data);
        this.treeViewer = this.tree.getViewer();
        this.treeViewer.setSorter(new ViewerSorter());
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection s = (IStructuredSelection)event.getSelection();
                Object element = s.getFirstElement();
                if (AbstractTreeComposite.this.treeViewer.isExpandable(element)) {
                    AbstractTreeComposite.this.treeViewer.setExpandedState(element, !AbstractTreeComposite.this.treeViewer.getExpandedState(element));
                }
            }
        });
        if (this.hasDescription()) {
            this.description = new Label((Composite)this, 64);
            this.description.setText("Multi\nLine\nMessage");
            Dialog.applyDialogFont((Control)this);
            Point p = this.description.computeSize(-1, -1);
            this.description.setText("");
            data = new GridData(772);
            data.horizontalSpan = 1;
            data.heightHint = p.y > 10 ? p.y : 42;
            this.description.setLayoutData((Object)data);
        }
        this.tree.forceFocus();
    }

    protected void createTree() {
        this.tree = new FilteredTree((Composite)this, 2820, (PatternFilter)new ServerPatternFilter(), true);
    }

    protected abstract String getDescriptionLabel();

    protected abstract String getTitleLabel();

    protected boolean hasDescription() {
        return true;
    }

    protected void setDescription(String text) {
        if (this.description != null && text != null) {
            this.description.setText(text);
        }
    }

    protected TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    protected Object getSelection(ISelection sel2) {
        IStructuredSelection sel = (IStructuredSelection)sel2;
        return sel.getFirstElement();
    }

    public void refresh() {
        this.treeViewer.refresh();
    }

    public void refresh(Object obj) {
        this.treeViewer.refresh(obj);
    }

    public void remove(Object obj) {
        this.treeViewer.remove(obj);
    }

    protected String getDetailsLabel() {
        return null;
    }

    protected boolean getDetailsLink() {
        return false;
    }

    protected void detailsSelected() {
    }

    protected void refreshServerNode() {
    }

    protected void downloadAdaptersSelectionChanged(boolean action) {
        ServerUIPlugin.getPreferences().setExtAdapter(action);
        Job job = new Job(Messages.jobInitializingServersView){

            public IStatus run(final IProgressMonitor monitor) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (ServerUIPlugin.getPreferences().getExtAdapter()) {
                                AbstractTreeComposite.this.handleShowAdapters(monitor);
                            } else {
                                (this).AbstractTreeComposite.this.contentProvider.fillTree();
                                AbstractTreeComposite.this.refresh("root");
                                if ((this).AbstractTreeComposite.this.contentProvider.getInitialSelection() != null) {
                                    (this).AbstractTreeComposite.this.treeViewer.setSelection((ISelection)new StructuredSelection((this).AbstractTreeComposite.this.contentProvider.getInitialSelection()), true);
                                }
                            }
                        }
                        catch (Exception exception) {}
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.setPriority(20);
        job.schedule();
    }

    protected void handleShowAdapterSelection(boolean selection) {
        this.showAdapters.setSelection(selection);
        this.prefLink.setEnabled(!selection);
        this.downloadAdaptersSelectionChanged(selection);
    }

    protected void deferInitialization() {
        ServerUIUtil.refreshServerNode(false);
        Job job = new Job(Messages.jobInitializingServersView){

            public IStatus run(final IProgressMonitor monitor) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (ServerUIPlugin.getPreferences().getExtAdapter()) {
                                AbstractTreeComposite.this.handleShowAdapters(monitor);
                            } else if ((this).AbstractTreeComposite.this.contentProvider.getInitialSelection() != null) {
                                (this).AbstractTreeComposite.this.treeViewer.setSelection((ISelection)new StructuredSelection((this).AbstractTreeComposite.this.contentProvider.getInitialSelection()), true);
                            }
                        }
                        catch (Exception exception) {}
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.setPriority(20);
        job.schedule();
    }

    protected void handleShowAdapters(IProgressMonitor monitor) {
        this.contentProvider.fillAdapterTree(this.treeViewer, monitor);
        if (this.contentProvider.getInitialSelection() != null && !this.treeViewer.getTree().isDisposed()) {
            this.treeViewer.setSelection((ISelection)new StructuredSelection(this.contentProvider.getInitialSelection()), true);
        }
    }
}

