/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.tools.component.api.violation;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.wtp.releng.tools.component.ILocation;
import org.eclipse.wtp.releng.tools.component.api.ComponentUse;
import org.eclipse.wtp.releng.tools.component.api.Source;
import org.eclipse.wtp.releng.tools.component.internal.ComponentEntry;
import org.eclipse.wtp.releng.tools.component.internal.ComponentSummary;

public class ComponentViolationSummary
extends ComponentSummary {
    private static final String ROOT_TAG_NAME = "component-violation-summary";

    public void add(ComponentUse compViolation) {
        ComponentViolationEntry entry = new ComponentViolationEntry();
        entry.setCompName(compViolation.getName());
        int numViolations = 0;
        List sources = compViolation.getSources();
        Iterator it = sources.iterator();
        while (it.hasNext()) {
            numViolations += ((Source)it.next()).getClassUses().size();
        }
        entry.setNumViolations(numViolations);
        entry.setRef(compViolation.getLocation().getAbsolutePath());
        this.add(entry);
    }

    public void saveAsHTML(ILocation html) throws TransformerConfigurationException, TransformerException, IOException {
        this.saveAsHTML(html, "org/eclipse/wtp/releng/tools/component/xsl/component-violation-summary.xsl", ROOT_TAG_NAME);
    }

    public void save(ILocation location) throws IOException {
        this.save(location, ROOT_TAG_NAME);
    }

    private class ComponentViolationEntry
    extends ComponentEntry {
        private int numViolations = -1;

        protected ComponentViolationEntry() {
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("<component-violation ");
            sb.append(this.toAttribute("name", this.getCompName()));
            sb.append(this.toAttribute("count", String.valueOf(this.numViolations)));
            sb.append(this.toAttribute("ref", this.getRef()));
            sb.append("/>");
            return sb.toString();
        }

        public int getNumViolations() {
            return this.numViolations;
        }

        public void setNumViolations(int numViolations) {
            this.numViolations = numViolations;
        }
    }
}

