/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.filters.util.ChainReaderHelper;
import org.apache.tools.ant.taskdefs.FixCRLF;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.taskdefs.StreamPumper;
import org.apache.tools.ant.types.FileList;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.FilterChain;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.types.resources.Resources;
import org.apache.tools.ant.types.resources.Restrict;
import org.apache.tools.ant.types.resources.StringResource;
import org.apache.tools.ant.types.resources.selectors.Exists;
import org.apache.tools.ant.types.resources.selectors.Not;
import org.apache.tools.ant.types.resources.selectors.ResourceSelector;
import org.apache.tools.ant.util.ConcatResourceInputStream;
import org.apache.tools.ant.util.FileUtils;

public class Concat
extends Task {
    private static final int BUFFER_SIZE = 8192;
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();
    private static final ResourceSelector EXISTS = new Exists();
    private static final ResourceSelector NOT_EXISTS = new Not(EXISTS);
    private File destinationFile;
    private boolean append;
    private String encoding;
    private String outputEncoding;
    private boolean binary;
    private StringBuffer textBuffer;
    private Resources rc;
    private Vector filterChains;
    private boolean forceOverwrite = true;
    private TextElement footer;
    private TextElement header;
    private boolean fixLastLine = false;
    private String eolString;
    private Writer outputWriter = null;

    public Concat() {
        this.reset();
    }

    public void reset() {
        this.append = false;
        this.forceOverwrite = true;
        this.destinationFile = null;
        this.encoding = null;
        this.outputEncoding = null;
        this.fixLastLine = false;
        this.filterChains = null;
        this.footer = null;
        this.header = null;
        this.binary = false;
        this.outputWriter = null;
        this.textBuffer = null;
        this.eolString = System.getProperty("line.separator");
        this.rc = null;
    }

    public void setDestfile(File destinationFile) {
        this.destinationFile = destinationFile;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
        if (this.outputEncoding == null) {
            this.outputEncoding = encoding;
        }
    }

    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    public void setForce(boolean force) {
        this.forceOverwrite = force;
    }

    public Path createPath() {
        Path path = new Path(this.getProject());
        this.add(path);
        return path;
    }

    public void addFileset(FileSet set) {
        this.add(set);
    }

    public void addFilelist(FileList list) {
        this.add(list);
    }

    public void add(ResourceCollection c) {
        this.rc = this.rc == null ? new Resources() : this.rc;
        this.rc.add(c);
    }

    public void addFilterChain(FilterChain filterChain) {
        if (this.filterChains == null) {
            this.filterChains = new Vector();
        }
        this.filterChains.addElement(filterChain);
    }

    public void addText(String text) {
        if (this.textBuffer == null) {
            this.textBuffer = new StringBuffer(text.length());
        }
        this.textBuffer.append(text);
    }

    public void addHeader(TextElement headerToAdd) {
        this.header = headerToAdd;
    }

    public void addFooter(TextElement footerToAdd) {
        this.footer = footerToAdd;
    }

    public void setFixLastLine(boolean fixLastLine) {
        this.fixLastLine = fixLastLine;
    }

    public void setEol(FixCRLF.CrLf crlf) {
        String s = crlf.getValue();
        if (s.equals("cr") || s.equals("mac")) {
            this.eolString = "\r";
        } else if (s.equals("lf") || s.equals("unix")) {
            this.eolString = "\n";
        } else if (s.equals("crlf") || s.equals("dos")) {
            this.eolString = "\r\n";
        }
    }

    public void setWriter(Writer outputWriter) {
        this.outputWriter = outputWriter;
    }

    public void setBinary(boolean binary) {
        this.binary = binary;
    }

    private ResourceCollection validate() {
        this.sanitizeText();
        if (this.binary) {
            if (this.destinationFile == null) {
                throw new BuildException("destfile attribute is required for binary concatenation");
            }
            if (this.textBuffer != null) {
                throw new BuildException("Nested text is incompatible with binary concatenation");
            }
            if (this.encoding != null || this.outputEncoding != null) {
                throw new BuildException("Seting input or output encoding is incompatible with binary concatenation");
            }
            if (this.filterChains != null) {
                throw new BuildException("Setting filters is incompatible with binary concatenation");
            }
            if (this.fixLastLine) {
                throw new BuildException("Setting fixlastline is incompatible with binary concatenation");
            }
            if (this.header != null || this.footer != null) {
                throw new BuildException("Nested header or footer is incompatible with binary concatenation");
            }
        }
        if (this.destinationFile != null && this.outputWriter != null) {
            throw new BuildException("Cannot specify both a destination file and an output writer");
        }
        if (this.rc == null && this.textBuffer == null) {
            throw new BuildException("At least one resource must be provided, or some text.");
        }
        if (this.rc != null) {
            boolean outofdate;
            if (this.textBuffer != null) {
                throw new BuildException("Cannot include inline text when using resources.");
            }
            Restrict noexistRc = new Restrict();
            noexistRc.add(NOT_EXISTS);
            noexistRc.add(this.rc);
            Iterator i = noexistRc.iterator();
            while (i.hasNext()) {
                this.log(i.next() + " does not exist.", 0);
            }
            if (this.destinationFile != null) {
                i = this.rc.iterator();
                while (i.hasNext()) {
                    File f;
                    Object o = i.next();
                    if (!(o instanceof FileResource) || !FILE_UTILS.fileNameEquals(f = ((FileResource)o).getFile(), this.destinationFile)) continue;
                    throw new BuildException("Input file \"" + f + "\" is the same as the output file.");
                }
            }
            Restrict existRc = new Restrict();
            existRc.add(EXISTS);
            existRc.add(this.rc);
            boolean bl = outofdate = this.destinationFile == null || this.forceOverwrite;
            if (!outofdate) {
                Iterator i2 = existRc.iterator();
                while (!outofdate && i2.hasNext()) {
                    Resource r = (Resource)i2.next();
                    outofdate = r.getLastModified() == 0L || r.getLastModified() > this.destinationFile.lastModified();
                }
            }
            if (!outofdate) {
                this.log(this.destinationFile + " is up-to-date.", 3);
                return null;
            }
            return existRc;
        }
        StringResource s = new StringResource();
        s.setProject(this.getProject());
        s.setValue(this.textBuffer.toString());
        return s;
    }

    public void execute() {
        ResourceCollection c = this.validate();
        if (c == null) {
            return;
        }
        if (c.size() < 1 && this.header == null && this.footer == null) {
            this.log("No existing resources and no nested text, doing nothing", 2);
            return;
        }
        if (this.binary) {
            this.binaryCat(c);
        } else {
            this.cat(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void binaryCat(ResourceCollection c) {
        this.log("Binary concatenation of " + c.size() + " resources to " + this.destinationFile);
        FileOutputStream out = null;
        ConcatResourceInputStream in = null;
        try {
            try {
                out = new FileOutputStream(this.destinationFile);
            }
            catch (Exception t) {
                throw new BuildException("Unable to open " + this.destinationFile + " for writing", t);
            }
            in = new ConcatResourceInputStream(c);
            in.setManagingComponent(this);
            Thread t = new Thread(new StreamPumper(in, out));
            t.start();
            try {
                t.join();
            }
            catch (InterruptedException e) {
                try {
                    t.join();
                }
                catch (InterruptedException ee) {
                    // empty catch block
                }
            }
        }
        catch (Throwable throwable) {
            FileUtils.close(in);
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception ex) {
                    throw new BuildException("Unable to close " + this.destinationFile, ex);
                }
            }
            throw throwable;
        }
        FileUtils.close(in);
        if (out != null) {
            try {
                out.close();
            }
            catch (Exception ex) {
                throw new BuildException("Unable to close " + this.destinationFile, ex);
            }
        }
    }

    private void cat(ResourceCollection c) {
        OutputStream os = null;
        char[] buffer = new char[8192];
        try {
            PrintWriter writer = null;
            if (this.outputWriter != null) {
                writer = new PrintWriter(this.outputWriter);
            } else {
                if (this.destinationFile == null) {
                    os = new LogOutputStream(this, 1);
                } else {
                    File parent = this.destinationFile.getParentFile();
                    if (!parent.exists()) {
                        parent.mkdirs();
                    }
                    os = new FileOutputStream(this.destinationFile.getAbsolutePath(), this.append);
                }
                writer = this.outputEncoding == null ? new PrintWriter(new BufferedWriter(new OutputStreamWriter(os))) : new PrintWriter(new BufferedWriter(new OutputStreamWriter(os, this.outputEncoding)));
            }
            if (this.header != null) {
                if (this.header.getFiltering()) {
                    this.concatenate(buffer, writer, new StringReader(this.header.getValue()));
                } else {
                    writer.print(this.header.getValue());
                }
            }
            if (c.size() > 0) {
                this.concatenate(buffer, writer, new MultiReader(c));
            }
            if (this.footer != null) {
                if (this.footer.getFiltering()) {
                    this.concatenate(buffer, writer, new StringReader(this.footer.getValue()));
                } else {
                    writer.print(this.footer.getValue());
                }
            }
            writer.flush();
            if (os != null) {
                os.flush();
            }
        }
        catch (IOException ioex) {
            try {
                throw new BuildException("Error while concatenating: " + ioex.getMessage(), ioex);
            }
            catch (Throwable throwable) {
                FileUtils.close(os);
                throw throwable;
            }
        }
        FileUtils.close(os);
    }

    private void concatenate(char[] buffer, Writer writer, Reader in) throws IOException {
        int nRead;
        if (this.filterChains != null) {
            ChainReaderHelper helper = new ChainReaderHelper();
            helper.setBufferSize(8192);
            helper.setPrimaryReader(in);
            helper.setFilterChains(this.filterChains);
            helper.setProject(this.getProject());
            in = new BufferedReader(helper.getAssembledReader());
        }
        while ((nRead = in.read(buffer, 0, buffer.length)) != -1) {
            writer.write(buffer, 0, nRead);
        }
        writer.flush();
    }

    private void sanitizeText() {
        if (this.textBuffer != null && this.textBuffer.substring(0).trim().length() == 0) {
            this.textBuffer = null;
        }
    }

    private class MultiReader
    extends Reader {
        private Reader reader = null;
        private int lastPos = 0;
        private char[] lastChars = new char[Concat.access$200(Concat.this).length()];
        private boolean needAddSeparator = false;
        private Iterator i;

        private MultiReader(ResourceCollection c) {
            this.i = c.iterator();
        }

        private Reader getReader() throws IOException {
            if (this.reader == null && this.i.hasNext()) {
                Resource r = (Resource)this.i.next();
                Concat.this.log("Concating " + r.toLongString(), 3);
                InputStream is = r.getInputStream();
                this.reader = new BufferedReader(Concat.this.encoding == null ? new InputStreamReader(is) : new InputStreamReader(is, Concat.this.encoding));
                Arrays.fill(this.lastChars, '\u0000');
            }
            return this.reader;
        }

        private void nextReader() throws IOException {
            this.close();
            this.reader = null;
        }

        public int read() throws IOException {
            if (this.needAddSeparator) {
                char ret = Concat.this.eolString.charAt(this.lastPos++);
                if (this.lastPos >= Concat.this.eolString.length()) {
                    this.lastPos = 0;
                    this.needAddSeparator = false;
                }
                return ret;
            }
            while (this.getReader() != null) {
                int ch = this.getReader().read();
                if (ch == -1) {
                    this.nextReader();
                    if (!Concat.this.fixLastLine || !this.isMissingEndOfLine()) continue;
                    this.needAddSeparator = true;
                    this.lastPos = 0;
                    continue;
                }
                this.addLastChar((char)ch);
                return ch;
            }
            return -1;
        }

        public int read(char[] cbuf, int off, int len) throws IOException {
            int amountRead = 0;
            while (this.getReader() != null || this.needAddSeparator) {
                if (this.needAddSeparator) {
                    cbuf[off] = Concat.this.eolString.charAt(this.lastPos++);
                    if (this.lastPos >= Concat.this.eolString.length()) {
                        this.lastPos = 0;
                        this.needAddSeparator = false;
                    }
                    ++off;
                    ++amountRead;
                    if (--len != 0) continue;
                    return amountRead;
                }
                int nRead = this.getReader().read(cbuf, off, len);
                if (nRead == -1 || nRead == 0) {
                    this.nextReader();
                    if (!Concat.this.fixLastLine || !this.isMissingEndOfLine()) continue;
                    this.needAddSeparator = true;
                    this.lastPos = 0;
                    continue;
                }
                if (Concat.this.fixLastLine) {
                    for (int i = nRead; i > nRead - this.lastChars.length && i > 0; --i) {
                        this.addLastChar(cbuf[off + i - 1]);
                    }
                }
                off += nRead;
                amountRead += nRead;
                if ((len -= nRead) != 0) continue;
                return amountRead;
            }
            if (amountRead == 0) {
                return -1;
            }
            return amountRead;
        }

        public void close() throws IOException {
            if (this.reader != null) {
                this.reader.close();
            }
        }

        private void addLastChar(char ch) {
            for (int i = this.lastChars.length - 2; i >= 0; --i) {
                this.lastChars[i] = this.lastChars[i + 1];
            }
            this.lastChars[this.lastChars.length - 1] = ch;
        }

        private boolean isMissingEndOfLine() {
            for (int i = 0; i < this.lastChars.length; ++i) {
                if (this.lastChars[i] == Concat.this.eolString.charAt(i)) continue;
                return true;
            }
            return false;
        }
    }

    public static class TextElement
    extends ProjectComponent {
        private String value = "";
        private boolean trimLeading = false;
        private boolean trim = false;
        private boolean filtering = true;
        private String encoding = null;

        public void setFiltering(boolean filtering) {
            this.filtering = filtering;
        }

        private boolean getFiltering() {
            return this.filtering;
        }

        public void setEncoding(String encoding) {
            this.encoding = encoding;
        }

        public void setFile(File file) throws BuildException {
            if (!file.exists()) {
                throw new BuildException("File " + file + " does not exist.");
            }
            BufferedReader reader = null;
            try {
                reader = this.encoding == null ? new BufferedReader(new FileReader(file)) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), this.encoding));
                this.value = FileUtils.readFully(reader);
            }
            catch (IOException ex) {
                try {
                    throw new BuildException(ex);
                }
                catch (Throwable throwable) {
                    FileUtils.close(reader);
                    throw throwable;
                }
            }
            FileUtils.close(reader);
        }

        public void addText(String value) {
            this.value = this.value + this.getProject().replaceProperties(value);
        }

        public void setTrimLeading(boolean strip) {
            this.trimLeading = strip;
        }

        public void setTrim(boolean trim) {
            this.trim = trim;
        }

        public String getValue() {
            if (this.value == null) {
                this.value = "";
            }
            if (this.value.trim().length() == 0) {
                this.value = "";
            }
            if (this.trimLeading) {
                char[] current = this.value.toCharArray();
                StringBuffer b = new StringBuffer(current.length);
                boolean startOfLine = true;
                int pos = 0;
                while (pos < current.length) {
                    char ch = current[pos++];
                    if (startOfLine) {
                        if (ch == ' ' || ch == '\t') continue;
                        startOfLine = false;
                    }
                    b.append(ch);
                    if (ch != '\n' && ch != '\r') continue;
                    startOfLine = true;
                }
                this.value = b.toString();
            }
            if (this.trim) {
                this.value = this.value.trim();
            }
            return this.value;
        }
    }
}

