/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.tools.component.api.progress;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.wtp.releng.tools.component.CommandOptionParser;
import org.eclipse.wtp.releng.tools.component.ILocation;
import org.eclipse.wtp.releng.tools.component.api.progress.APIProgressEntry;
import org.eclipse.wtp.releng.tools.component.api.progress.APIProgressSummary;
import org.eclipse.wtp.releng.tools.component.internal.AbstractEmitter;
import org.eclipse.wtp.releng.tools.component.internal.ComponentXML;
import org.eclipse.wtp.releng.tools.component.internal.Description;
import org.eclipse.wtp.releng.tools.component.internal.FileLocation;
import org.eclipse.wtp.releng.tools.component.internal.Plugin;
import org.xml.sax.SAXException;

public class APIProgressEmitter
extends AbstractEmitter {
    public static final String OPTION_COMPONENT_INDEX = "compIndex";
    public static final String OPTION_REF_COMP_INDEX_DIR = "refCompIndexDir";
    public static final String OPTION_ECLIPSE_DIR = "eclipseDir";
    public static final String OPTION_COMPONENT_XML = "compXMLDir";
    public static final String OPTION_OUTPUT_DIR = "outputDir";
    private static final String NAME_INDEX_COMP_SUMMARY = "index-comp-summary.xml";
    private String compIndex;
    private List refCompIndexDirs;
    private List eclipseDirs;
    private List compXMLDirs;
    private String outputDir;

    public APIProgressEmitter(String compIndex, List refCompIndexDirs, List eclipseDirs, List compXMLDirs, String outputDir) {
        this.compIndex = compIndex;
        this.refCompIndexDirs = refCompIndexDirs;
        this.eclipseDirs = eclipseDirs;
        this.compXMLDirs = compXMLDirs;
        this.outputDir = this.addTrailingSeperator(outputDir);
    }

    public void genAPIProgress() throws ParserConfigurationException, SAXException, IOException, TransformerConfigurationException, TransformerException {
        HashMap loc2RefCompIndex = new HashMap();
        if (this.refCompIndexDirs != null) {
            Iterator it = this.refCompIndexDirs.iterator();
            while (it.hasNext()) {
                File refCompIndexFile = new File(this.addTrailingSeperator((String)it.next()));
                if (!refCompIndexFile.exists()) continue;
                this.harvestCompIndexes(refCompIndexFile, loc2RefCompIndex);
            }
        }
        HashMap pluginId2Plugin = new HashMap();
        HashMap fragmentId2Fragment = new HashMap();
        Iterator it = this.eclipseDirs.iterator();
        while (it.hasNext()) {
            File eclipseFile = new File(this.addTrailingSeperator((String)it.next()));
            if (!eclipseFile.exists()) continue;
            this.harvestPlugins(eclipseFile, pluginId2Plugin, fragmentId2Fragment);
        }
        HashMap compLoc2CompXML = new HashMap();
        Iterator it2 = this.compXMLDirs.iterator();
        while (it2.hasNext()) {
            File compXMLFile = new File(this.addTrailingSeperator((String)it2.next()));
            if (!compXMLFile.exists()) continue;
            this.harvestComponents(compXMLFile, compLoc2CompXML);
        }
        APIProgressSummary summary = new APIProgressSummary();
        summary.load(new FileLocation(new File(this.compIndex)));
        ArrayList<String> pluginsDeclared = new ArrayList<String>();
        ArrayList<String> missingPlugins = new ArrayList<String>();
        ArrayList<String> dupPlugins = new ArrayList<String>();
        Iterator it3 = compLoc2CompXML.values().iterator();
        while (it3.hasNext()) {
            Description desc;
            ComponentXML compXML = (ComponentXML)it3.next();
            compXML.load();
            APIProgressEntry entry = (APIProgressEntry)summary.getEntry(compXML.getName());
            if (entry != null && (desc = compXML.getDescription()) != null) {
                entry.setOverviewDoc(desc.getUrl());
            }
            Collection plugins = compXML.getPlugins();
            Iterator pluginIt = plugins.iterator();
            while (pluginIt.hasNext()) {
                Plugin plugin = (Plugin)pluginIt.next();
                String pluginId = plugin.getId();
                if (pluginsDeclared.contains(pluginId)) {
                    dupPlugins.add(pluginId);
                } else if (plugin.isFragment()) {
                    if (!fragmentId2Fragment.containsKey(pluginId)) {
                        missingPlugins.add(pluginId);
                    }
                } else if (!pluginId2Plugin.containsKey(pluginId)) {
                    missingPlugins.add(pluginId);
                }
                pluginsDeclared.add(pluginId);
            }
        }
        summary.addMissingPlugins(missingPlugins);
        summary.addDupPlugins(dupPlugins);
        ArrayList<String> pluginsWithoutComp = new ArrayList<String>();
        Iterator it4 = pluginId2Plugin.keySet().iterator();
        while (it4.hasNext()) {
            String pluginId = (String)it4.next();
            if (this.hasPlugin(pluginId, false, compLoc2CompXML)) continue;
            pluginsWithoutComp.add(pluginId);
        }
        it4 = fragmentId2Fragment.keySet().iterator();
        while (it4.hasNext()) {
            String fragmentId = (String)it4.next();
            if (this.hasPlugin(fragmentId, true, compLoc2CompXML)) continue;
            pluginsWithoutComp.add(fragmentId);
        }
        summary.addPluginsWithoutComp(pluginsWithoutComp);
        ArrayList<OverviewDocLoader> loaders = new ArrayList<OverviewDocLoader>();
        Iterator it5 = summary.getEntries().iterator();
        while (it5.hasNext()) {
            APIProgressEntry entry = (APIProgressEntry)it5.next();
            if (entry.getOverviewDoc() != null) continue;
            OverviewDocLoader loader = new OverviewDocLoader(entry);
            loader.start();
            loaders.add(loader);
        }
        it5 = loaders.iterator();
        while (it5.hasNext()) {
            ((OverviewDocLoader)it5.next()).waitFor();
        }
        this.copyImages();
        it5 = summary.getEntries().iterator();
        while (it5.hasNext()) {
            this.genAPIProgress(this.compIndex, (APIProgressEntry)it5.next(), summary.getTimestamp(), loc2RefCompIndex, this.outputDir);
        }
        this.genAPIProgress(this.compIndex, summary.getTimestamp(), loc2RefCompIndex, this.outputDir);
        this.xslt(summary.toString(), "org/eclipse/wtp/releng/tools/component/xsl/api-progress.xsl", String.valueOf(this.outputDir) + "api-progress.html");
    }

    private void genAPIProgress(String baseLocation, APIProgressEntry entry, String timestamp, Map loc2RefCompIndex, String outputDir) {
        StringBuffer sb = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        String compName = entry.getCompName();
        sb.append("<component name=\"");
        sb.append(compName);
        sb.append("\">");
        ArrayList<Integer> sortedTimestamps = new ArrayList<Integer>();
        ArrayList<String> sortedSummaries = new ArrayList<String>();
        Iterator<Object> it = loc2RefCompIndex.keySet().iterator();
        while (it.hasNext()) {
            ILocation location = (ILocation)it.next();
            String absPath = location.getAbsolutePath();
            APIProgressSummary summary = (APIProgressSummary)loc2RefCompIndex.get(location);
            String summaryTimestamp = summary.getTimestamp();
            int insertIndex = sortedTimestamps.size();
            try {
                Integer thisTimestamp = Integer.valueOf(summaryTimestamp);
                while (insertIndex > 0) {
                    Integer i = (Integer)sortedTimestamps.get(insertIndex - 1);
                    if (thisTimestamp > i) break;
                    --insertIndex;
                }
                sortedTimestamps.add(insertIndex, thisTimestamp);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
            sortedSummaries.add(insertIndex, this.toString(absPath, summaryTimestamp));
        }
        it = sortedSummaries.iterator();
        while (it.hasNext()) {
            sb.append((String)it.next());
        }
        sb.append(this.toString(baseLocation, timestamp));
        sb.append("</component>");
        try {
            StringBuffer output = new StringBuffer(outputDir);
            output.append("svg/");
            output.append(compName);
            output.append(".svg");
            this.xslt(sb.toString(), "org/eclipse/wtp/releng/tools/component/xsl/api-progress-svg.xsl", output.toString());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void genAPIProgress(String baseLocation, String timestamp, Map loc2RefCompIndex, String outputDir) {
        StringBuffer sb = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("<total>");
        ArrayList<Integer> sortedTimestamps = new ArrayList<Integer>();
        ArrayList<String> sortedTotals = new ArrayList<String>();
        Iterator<Object> it = loc2RefCompIndex.keySet().iterator();
        while (it.hasNext()) {
            ILocation location = (ILocation)it.next();
            String absPath = location.getAbsolutePath();
            APIProgressSummary summary = (APIProgressSummary)loc2RefCompIndex.get(location);
            String summaryTimestamp = summary.getTimestamp();
            int insertIndex = sortedTimestamps.size();
            try {
                Integer thisTimestamp = Integer.valueOf(summaryTimestamp);
                while (insertIndex > 0) {
                    Integer i = (Integer)sortedTimestamps.get(insertIndex - 1);
                    if (thisTimestamp > i) break;
                    --insertIndex;
                }
                sortedTimestamps.add(insertIndex, thisTimestamp);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
            sortedTotals.add(insertIndex, this.toStringTotal(absPath, summaryTimestamp));
        }
        it = sortedTotals.iterator();
        while (it.hasNext()) {
            sb.append((String)it.next());
        }
        sb.append(this.toStringTotal(baseLocation, timestamp));
        sb.append("</total>");
        try {
            StringBuffer output = new StringBuffer(outputDir);
            output.append("svg/total.svg");
            this.xslt(sb.toString(), "org/eclipse/wtp/releng/tools/component/xsl/api-progress-svg-total.xsl", output.toString());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void xslt(String content, String xsl, String output) throws SAXException, ParserConfigurationException, TransformerConfigurationException, TransformerException, FileNotFoundException {
        File outputFile = new File(output);
        outputFile.getParentFile().mkdirs();
        this.xslt(new ByteArrayInputStream(content.getBytes()), xsl, new FileOutputStream(outputFile));
    }

    private void xslt(InputStream is, String xsl, OutputStream os) throws SAXException, ParserConfigurationException, TransformerConfigurationException, TransformerException, FileNotFoundException {
        String user_dir = "user.dir";
        String currUserDir = System.getProperty(user_dir);
        System.setProperty(user_dir, new File(this.compIndex).getParentFile().getAbsolutePath());
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer(new StreamSource(ClassLoader.getSystemResourceAsStream(xsl)));
        transformer.transform(new StreamSource(is), new StreamResult(os));
        System.setProperty(user_dir, currUserDir);
    }

    private String toString(String baseLocation, String timestamp) {
        baseLocation = this.toAbsolutePath(baseLocation);
        StringBuffer sb = new StringBuffer("<timestamp id=\"");
        sb.append(timestamp);
        sb.append("\">");
        sb.append("<testcoverage ref=\"");
        sb.append(String.valueOf(baseLocation) + "index-api-tc.xml");
        sb.append("\"/>");
        sb.append("<javadoccoverage ref=\"");
        sb.append(String.valueOf(baseLocation) + "index-api-javadoc.xml");
        sb.append("\"/>");
        sb.append("</timestamp>");
        return sb.toString();
    }

    private String toStringTotal(String baseLocation, String timestamp) {
        baseLocation = this.toAbsolutePath(baseLocation);
        StringBuffer sb = new StringBuffer();
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.xslt(new FileInputStream(String.valueOf(baseLocation) + "index-api-tc.xml"), "org/eclipse/wtp/releng/tools/component/xsl/component-api-util.xsl", baos);
            Properties p = new Properties();
            p.load(new ByteArrayInputStream(baos.toByteArray()));
            String apiCount = p.getProperty("api-count");
            String testCoverageCount = p.getProperty("test-coverage-count");
            baos = new ByteArrayOutputStream();
            this.xslt(new FileInputStream(String.valueOf(baseLocation) + "index-api-javadoc.xml"), "org/eclipse/wtp/releng/tools/component/xsl/component-api-util.xsl", baos);
            p = new Properties();
            p.load(new ByteArrayInputStream(baos.toByteArray()));
            String methodApiCount = p.getProperty("method-api-count");
            String classJavadocCount = p.getProperty("class-javadoc-count");
            String methodJavadocCount = p.getProperty("method-javadoc-count");
            sb.append("<timestamp id=\"");
            sb.append(timestamp);
            sb.append("\"");
            sb.append(" api-count=\"");
            sb.append(apiCount);
            sb.append("\"");
            sb.append(" test-coverage-count=\"");
            sb.append(testCoverageCount);
            sb.append("\"");
            sb.append(" method-api-count=\"");
            sb.append(methodApiCount);
            sb.append("\"");
            sb.append(" class-javadoc-count=\"");
            sb.append(classJavadocCount);
            sb.append("\"");
            sb.append(" method-javadoc-count=\"");
            sb.append(methodJavadocCount);
            sb.append("\"");
            sb.append("/>");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return sb.toString();
    }

    private String toAbsolutePath(String s) {
        int i = (s = s.replace('\\', '/')).lastIndexOf(47);
        if (i != -1) {
            s = s.substring(0, i);
        }
        s = this.addTrailingSeperator(s);
        return s;
    }

    private void harvestCompIndexes(File file, Map loc2RefCompIndex) {
        block6: {
            block5: {
                if (!file.isDirectory()) break block5;
                File[] files = file.listFiles();
                int i = 0;
                while (i < files.length) {
                    this.harvestCompIndexes(files[i], loc2RefCompIndex);
                    ++i;
                }
                break block6;
            }
            if (!NAME_INDEX_COMP_SUMMARY.equalsIgnoreCase(file.getName())) break block6;
            APIProgressSummary summary = new APIProgressSummary();
            try {
                FileLocation location = new FileLocation(file);
                summary.load(location);
                loc2RefCompIndex.put(location, summary);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean hasPlugin(String pluginId, boolean isFragment, Map compLoc2CompXML) {
        Iterator compXMLIt = compLoc2CompXML.values().iterator();
        while (compXMLIt.hasNext()) {
            ComponentXML compXML = (ComponentXML)compXMLIt.next();
            Collection plugins = compXML.getPlugins();
            Iterator pluginIt = plugins.iterator();
            while (pluginIt.hasNext()) {
                Plugin plugin = (Plugin)pluginIt.next();
                if (!pluginId.equals(plugin.getId()) || isFragment != plugin.isFragment()) continue;
                return true;
            }
        }
        return false;
    }

    private void copyImages() {
        try {
            this.copyImage("org/eclipse/wtp/releng/tools/component/images/green.gif", new File(String.valueOf(this.outputDir) + "green.gif"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            this.copyImage("org/eclipse/wtp/releng/tools/component/images/grey.gif", new File(String.valueOf(this.outputDir) + "grey.gif"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            this.copyImage("org/eclipse/wtp/releng/tools/component/images/Idea.jpg", new File(String.valueOf(this.outputDir) + "Idea.jpg"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            this.copyImage("org/eclipse/wtp/releng/tools/component/images/orange.gif", new File(String.valueOf(this.outputDir) + "orange.gif"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            this.copyImage("org/eclipse/wtp/releng/tools/component/images/red.gif", new File(String.valueOf(this.outputDir) + "red.gif"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            this.copyImage("org/eclipse/wtp/releng/tools/component/images/space.gif", new File(String.valueOf(this.outputDir) + "space.gif"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            this.copyImage("org/eclipse/wtp/releng/tools/component/images/yellow.gif", new File(String.valueOf(this.outputDir) + "yellow.gif"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            this.copyImage("org/eclipse/wtp/releng/tools/component/images/twistopened.gif", new File(String.valueOf(this.outputDir) + "twistopened.gif"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            this.copyImage("org/eclipse/wtp/releng/tools/component/images/twistclosed.gif", new File(String.valueOf(this.outputDir) + "twistclosed.gif"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            this.copyImage("org/eclipse/wtp/releng/tools/component/images/viewsvg.gif", new File(String.valueOf(this.outputDir) + "viewsvg.gif"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        CommandOptionParser optionParser = new CommandOptionParser(args);
        Map options = optionParser.getOptions();
        List compIndex = (List)options.get(OPTION_COMPONENT_INDEX);
        List eclipseDirs = (List)options.get(OPTION_ECLIPSE_DIR);
        List compXMLDirs = (List)options.get(OPTION_COMPONENT_XML);
        List outputDir = (List)options.get(OPTION_OUTPUT_DIR);
        List refCompIndexDirs = (List)options.get(OPTION_REF_COMP_INDEX_DIR);
        if (compIndex == null || eclipseDirs == null || compXMLDirs == null || outputDir == null || compIndex.size() < 1 || eclipseDirs.size() < 1 || compXMLDirs.size() < 1 || outputDir.size() < 1) {
            APIProgressEmitter.printUsage();
            System.exit(-1);
        }
        APIProgressEmitter emitter = new APIProgressEmitter((String)compIndex.get(0), refCompIndexDirs, eclipseDirs, compXMLDirs, (String)outputDir.get(0));
        try {
            emitter.genAPIProgress();
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (SAXException saxe) {
            saxe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (TransformerConfigurationException tce) {
            tce.printStackTrace();
        }
        catch (TransformerException te) {
            te.printStackTrace();
        }
    }

    private static void printUsage() {
        System.out.println("Usage: java org.eclipse.wtp.releng.tools.component.api.progress.APIProgressEmitter -compIndex <compIndex> -eclipseDir <eclipseDir> -compXMLDir <compXMLDir> -outputDir <outputDir>");
        System.out.println("");
        System.out.println("\t-compIndex\t<compIndex>\tlocation of index-comp-summary.xml");
        System.out.println("\t-eclipseDir\t<eclipseDir>\tspace seperated list of directories containing Eclipse plugins");
        System.out.println("\t-compXMLDir\t<compXMLDir>\tspace seperated lits of directories containing component.xml files");
        System.out.println("\t-outputDir\t<compXMLDir>\toutput directory of the API progress report");
    }

    private class OverviewDocLoader
    extends Thread {
        private APIProgressEntry entry;
        private boolean done;

        public OverviewDocLoader(APIProgressEntry entry) {
            this.entry = entry;
            this.done = false;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                try {
                    int index;
                    String compName = this.entry.getCompName();
                    String subproject = null;
                    String component = null;
                    if (compName.startsWith("org.eclipse.") && (index = (compName = compName.substring(12)).indexOf(46)) != -1) {
                        subproject = compName.substring(0, index);
                        component = compName.substring(index + 1);
                    }
                    if (subproject != null && component != null) {
                        StringBuffer url = new StringBuffer("http://eclipse.org/webtools/");
                        url.append(subproject);
                        url.append("/components/");
                        url.append(component);
                        url.append("/overview.html");
                        URL overviewDoc = new URL(url.toString());
                        InputStream is = overviewDoc.openStream();
                        is.close();
                        this.entry.setOverviewDoc(url.toString());
                    }
                }
                catch (Throwable throwable) {}
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                this.done = true;
                throw throwable;
            }
            {
                Object var7_10 = null;
                this.done = true;
                return;
            }
        }

        public void waitFor() {
            long start = Calendar.getInstance().getTimeInMillis();
            while (!this.done && Calendar.getInstance().getTimeInMillis() - start < 60000L) {
                Thread.yield();
            }
        }
    }
}

