/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.internal.impl;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.EList;
import org.eclipse.wst.common.componentcore.internal.ComponentResource;
import org.eclipse.wst.common.componentcore.internal.ComponentcorePackage;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.WorkbenchComponent;
import org.eclipse.wst.common.componentcore.internal.util.IPathProvider;

public class ResourceTreeNode {
    public static final int CREATE_NONE = 0;
    public static final int CREATE_TREENODE_IFNEC = 1;
    public static final int CREATE_RESOURCE_ALWAYS = 2;
    private final Set moduleResources = Collections.synchronizedSet(new LinkedHashSet());
    private final Map children = Collections.synchronizedMap(new LinkedHashMap());
    private final Map transientChildResources = Collections.synchronizedMap(new LinkedHashMap());
    private static final ComponentResource[] NO_MODULE_RESOURCES = new ComponentResource[0];
    private IPathProvider pathProvider;
    private String pathSegment;

    public ResourceTreeNode(String aPathSegment, ResourceTreeNode parent, IPathProvider aPathProvider) {
        this.pathSegment = aPathSegment;
        this.pathProvider = aPathProvider;
    }

    public ResourceTreeNode addChild(ResourceTreeNode aChild) {
        this.children.put(aChild.getPathSegment(), aChild);
        return aChild;
    }

    public ResourceTreeNode addChild(ComponentResource aModuleResource) {
        ResourceTreeNode newChild = this.findChild(this.getPathProvider().getPath(aModuleResource), 1);
        if (newChild != null) {
            newChild.addModuleResource(aModuleResource);
            return newChild;
        }
        return null;
    }

    public ResourceTreeNode removeChild(ResourceTreeNode aChild) {
        return (ResourceTreeNode)this.children.remove(aChild.getPathSegment());
    }

    public ResourceTreeNode removeChild(ComponentResource aModuleResource) {
        ResourceTreeNode containingChild = this.findChild(this.getPathProvider().getPath(aModuleResource), 0);
        if (containingChild != null) {
            containingChild.removeResource(aModuleResource);
            if (containingChild.hasModuleResources()) {
                return containingChild;
            }
            return this.removeChild(containingChild);
        }
        return null;
    }

    public ResourceTreeNode removeChild(IPath targetPath, ComponentResource aModuleResource) {
        ResourceTreeNode containingChild = this.findChild(targetPath, 0);
        if (containingChild != null) {
            containingChild.removeResource(aModuleResource);
            if (containingChild.hasModuleResources()) {
                return containingChild;
            }
            return this.removeChild(containingChild);
        }
        return null;
    }

    public void removeResource(ComponentResource aResource) {
        this.moduleResources.remove(aResource);
    }

    public ResourceTreeNode findChild(IPath aPath) {
        return this.findChild(aPath, 1);
    }

    public ResourceTreeNode findChild(IPath aPath, int creationFlags) {
        if (aPath == null) {
            return null;
        }
        ResourceTreeNode child = this;
        if (aPath.segmentCount() > 0) {
            child = this.findChild(aPath.segment(0), creationFlags);
            if (child == null) {
                return null;
            }
            if (aPath.segmentCount() == 1) {
                return child;
            }
            child = child.findChild(aPath.removeFirstSegments(1), creationFlags);
        }
        return child;
    }

    public ResourceTreeNode findChild(String aPathSegment) {
        if (aPathSegment == null || aPathSegment.length() == 0) {
            return this;
        }
        return this.findChild(aPathSegment, 0);
    }

    public ResourceTreeNode findChild(String aPathSegment, int creationFlags) {
        boolean toCreateChildIfNecessary = (creationFlags & 1) == 1;
        ResourceTreeNode childNode = (ResourceTreeNode)this.children.get(aPathSegment);
        if (childNode == null && toCreateChildIfNecessary) {
            childNode = this.addChild(aPathSegment);
        }
        return childNode;
    }

    public ComponentResource[] findModuleResources(IPath aPath, int creationFlags) {
        Set foundModuleResources = this.findModuleResourcesSet(aPath, aPath, creationFlags);
        if (foundModuleResources.size() == 0) {
            return NO_MODULE_RESOURCES;
        }
        return foundModuleResources.toArray(new ComponentResource[foundModuleResources.size()]);
    }

    public boolean exists(IPath aPath, int creationFlags) {
        Set foundModuleResources = this.findModuleResourcesSet(aPath, aPath, creationFlags);
        if (foundModuleResources.size() == 0) {
            ResourceTreeNode child = this.findChild(aPath.segment(0), creationFlags);
            return child != null;
        }
        return true;
    }

    public boolean hasModuleResources() {
        return this.moduleResources.size() > 0;
    }

    public ComponentResource[] getModuleResources() {
        return this.moduleResources.toArray(new ComponentResource[this.moduleResources.size()]);
    }

    private Set findModuleResourcesSet(IPath aFullPath, IPath aPath, int creationFlags) {
        if (aPath.segmentCount() == 0) {
            Set resources = this.aggregateResources(new LinkedHashSet());
            return resources;
        }
        ResourceTreeNode child = this.findChild(aPath.segment(0), creationFlags);
        if (child == null) {
            return this.findMatchingVirtualPathsSet(aFullPath, aPath, creationFlags);
        }
        LinkedHashSet foundResources = new LinkedHashSet();
        foundResources.addAll(child.findModuleResourcesSet(aFullPath, aPath.removeFirstSegments(1), creationFlags));
        foundResources.addAll(this.findMatchingVirtualPathsSet(aFullPath, aPath, creationFlags));
        return foundResources;
    }

    private Set findMatchingVirtualPathsSet(IPath aFullPath, IPath aPath, int creationFlags) {
        boolean toCreateResourceAlways;
        boolean bl = toCreateResourceAlways = (creationFlags & 2) == 2;
        if (this.hasModuleResources()) {
            ComponentResource moduleResource2 = null;
            IResource eclipseResource = null;
            IContainer eclipseContainer = null;
            LinkedHashSet<ComponentResource> resultSet = new LinkedHashSet<ComponentResource>();
            for (ComponentResource moduleResource2 : this.moduleResources) {
                if (moduleResource2.getRuntimePath() == null || moduleResource2.eResource() == null || (eclipseResource = StructureEdit.getEclipseResource(moduleResource2)) == null || eclipseResource.getType() != 2 && eclipseResource.getType() != 4) continue;
                eclipseContainer = (IContainer)eclipseResource;
                IPath runtimeURI = moduleResource2.getRuntimePath().append(aPath);
                IPath srcPath = eclipseContainer.getProjectRelativePath().append(aPath);
                ComponentResource newResource = this.findExistingComponentResource(moduleResource2.getComponent(), runtimeURI, srcPath);
                if (newResource != null) continue;
                IResource eclipseRes = eclipseContainer.findMember(aPath);
                if (!toCreateResourceAlways && eclipseRes == null) continue;
                newResource = (ComponentResource)this.transientChildResources.get(srcPath);
                if (newResource == null) {
                    newResource = ComponentcorePackage.eINSTANCE.getComponentcoreFactory().createComponentResource();
                    newResource.setRuntimePath(runtimeURI);
                    newResource.setSourcePath(srcPath);
                    if (eclipseRes != null) {
                        newResource.setOwningProject(eclipseRes.getProject());
                    }
                    this.transientChildResources.put(srcPath, newResource);
                }
                resultSet.add(newResource);
            }
            return resultSet.size() > 0 ? resultSet : Collections.EMPTY_SET;
        }
        return Collections.EMPTY_SET;
    }

    private ComponentResource findExistingComponentResource(WorkbenchComponent component, IPath runtimeURI, IPath srcPath) {
        EList resources = component.getResources();
        for (ComponentResource element : resources) {
            if (!runtimeURI.equals((Object)element.getRuntimePath()) || !srcPath.equals((Object)element.getSourcePath())) continue;
            return element;
        }
        return null;
    }

    private Set aggregateResources(Set anAggregationSet) {
        if (this.hasModuleResources()) {
            anAggregationSet.addAll(this.moduleResources);
        }
        ResourceTreeNode childNode2 = null;
        for (ResourceTreeNode childNode2 : this.children.values()) {
            childNode2.aggregateResources(anAggregationSet);
        }
        return anAggregationSet;
    }

    public int childrenCount() {
        return this.children.size();
    }

    public String getPathSegment() {
        return this.pathSegment;
    }

    protected ResourceTreeNode addChild(String aPathSegment) {
        ResourceTreeNode newChild = null;
        newChild = (ResourceTreeNode)this.children.get(aPathSegment);
        if (newChild == null) {
            newChild = new ResourceTreeNode(aPathSegment, this, this.pathProvider);
            this.children.put(newChild.getPathSegment(), newChild);
        }
        return newChild;
    }

    protected ResourceTreeNode removeChild(String aPathSegment) {
        return (ResourceTreeNode)this.children.remove(aPathSegment);
    }

    void addModuleResource(ComponentResource aModuleResource) {
        this.moduleResources.add(aModuleResource);
    }

    IPathProvider getPathProvider() {
        return this.pathProvider;
    }

    public Map getChildren() {
        return this.children;
    }
}

