/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.viewers;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.server.core.IModuleArtifact;
import org.eclipse.wst.server.core.model.ModuleArtifactDelegate;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.viewers.BaseContentProvider;
import org.eclipse.wst.server.ui.internal.viewers.BaseLabelProvider;

public class ModuleArtifactComposite
extends Dialog {
    protected IModuleArtifact[] moduleArtifacts;
    private ListViewer listViewer;
    private String launchMode;
    private IModuleArtifact selection;

    public ModuleArtifactComposite(Shell parent, IModuleArtifact[] moduleArtifacts, String launchMode) {
        super(parent);
        this.setShellStyle(0x10 | this.getShellStyle());
        this.moduleArtifacts = moduleArtifacts;
        this.launchMode = launchMode;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.getWindowTitle());
    }

    private String getWindowTitle() {
        String title = Messages.wizRunOnServerTitle;
        if ("debug".equals(this.launchMode)) {
            title = Messages.wizDebugOnServerTitle;
        } else if ("profile".equals(this.launchMode)) {
            title = Messages.wizProfileOnServerTitle;
        }
        return title;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.verticalSpacing = 10;
        layout.numColumns = 1;
        GridData data = new GridData(1808);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)data);
        composite.setFont(parent.getFont());
        Text description = new Text(composite, 0);
        description.setText(Messages.wizModuleArtifactsDescription);
        description.setEditable(false);
        description.setCursor(composite.getDisplay().getSystemCursor(0));
        this.createContent(composite);
        return composite;
    }

    private void createContent(Composite parent) {
        Composite contentComposite = new Composite(parent, 16);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.verticalSpacing = 5;
        layout.numColumns = 1;
        GridData data = new GridData(1808);
        contentComposite.setLayout((Layout)layout);
        contentComposite.setLayoutData((Object)data);
        contentComposite.setFont(parent.getFont());
        Label tableTitle = new Label(contentComposite, 0);
        tableTitle.setText(Messages.wizModuleArtifactsAvailableList);
        this.listViewer = new ListViewer(contentComposite, 2820);
        data = new GridData(1808);
        this.listViewer.getList().setLayoutData((Object)data);
        this.listViewer.getList().setFocus();
        this.listViewer.setContentProvider((IContentProvider)new BaseContentProvider(){

            public Object[] getElements(Object inputElement) {
                return ModuleArtifactComposite.this.moduleArtifacts;
            }
        });
        this.listViewer.setLabelProvider((IBaseLabelProvider)new BaseLabelProvider(){

            public String getText(Object element) {
                if (element instanceof ModuleArtifactDelegate) {
                    ModuleArtifactDelegate moduleArtifact = (ModuleArtifactDelegate)element;
                    String artifactName = moduleArtifact.getName();
                    if (artifactName != null && artifactName.length() >= 0) {
                        int classNameIndex = artifactName.lastIndexOf(".");
                        String packageName = artifactName.substring(0, classNameIndex);
                        String className = artifactName.substring(classNameIndex + 1);
                        if (packageName != null && packageName.length() > 0) {
                            return String.valueOf(className) + " (" + moduleArtifact.getName() + ")";
                        }
                        return moduleArtifact.getName();
                    }
                    return moduleArtifact.getClass().getName();
                }
                return Messages.elementUnknownName;
            }
        });
        this.listViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ModuleArtifactComposite.this.buttonPressed(0);
            }
        });
        this.listViewer.setInput((Object)"root");
    }

    public IModuleArtifact getSelection() {
        IStructuredSelection selection2 = (IStructuredSelection)this.listViewer.getSelection();
        if (selection2 == null || selection2.getFirstElement() == null) {
            return this.selection;
        }
        this.selection = (IModuleArtifact)selection2.getFirstElement();
        return this.selection;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0 && this.getSelection() == null) {
            MessageBox messageBox = new MessageBox(this.getShell(), 33);
            messageBox.setMessage(Messages.wizModuleArtifactsNoSelectionError);
            messageBox.setText(this.getWindowTitle());
            messageBox.open();
            return;
        }
        super.buttonPressed(buttonId);
    }
}

