/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Manifest;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jst.j2ee.application.internal.operations.AddComponentToEnterpriseApplicationDataModelProvider;
import org.eclipse.jst.j2ee.application.internal.operations.ClassPathSelection;
import org.eclipse.jst.j2ee.application.internal.operations.ClasspathElement;
import org.eclipse.jst.j2ee.application.internal.operations.RemoveComponentFromEnterpriseApplicationDataModelProvider;
import org.eclipse.jst.j2ee.application.internal.operations.UpdateManifestDataModelProvider;
import org.eclipse.jst.j2ee.classpathdep.ClasspathDependencyUtil;
import org.eclipse.jst.j2ee.classpathdep.IClasspathDependencyConstants;
import org.eclipse.jst.j2ee.classpathdep.UpdateClasspathAttributeUtil;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifest;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifestImpl;
import org.eclipse.jst.j2ee.componentcore.J2EEModuleVirtualArchiveComponent;
import org.eclipse.jst.j2ee.internal.ClasspathTableManager;
import org.eclipse.jst.j2ee.internal.IClasspathTableOwner;
import org.eclipse.jst.j2ee.internal.IJ2EEDependenciesControl;
import org.eclipse.jst.j2ee.internal.J2EEDependenciesPage;
import org.eclipse.jst.j2ee.internal.ManifestErrorPrompter;
import org.eclipse.jst.j2ee.internal.ManifestUIResourceHandler;
import org.eclipse.jst.j2ee.internal.UpdateManifestOperation;
import org.eclipse.jst.j2ee.internal.classpathdep.ClasspathDependencyEnablement;
import org.eclipse.jst.j2ee.internal.common.ClasspathModel;
import org.eclipse.jst.j2ee.internal.common.ClasspathModelEvent;
import org.eclipse.jst.j2ee.internal.common.ClasspathModelListener;
import org.eclipse.jst.j2ee.internal.common.classpath.J2EEComponentClasspathUpdater;
import org.eclipse.jst.j2ee.internal.listeners.IValidateEditListener;
import org.eclipse.jst.j2ee.internal.listeners.ValidateEditListener;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIPlugin;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.project.EarUtilities;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.javaee.application.Application;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.UnresolveableURIException;
import org.eclipse.wst.common.componentcore.internal.builder.IDependencyGraph;
import org.eclipse.wst.common.componentcore.internal.impl.ModuleURIUtil;
import org.eclipse.wst.common.componentcore.internal.operation.RemoveReferenceComponentsDataModelProvider;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.common.componentcore.internal.util.IModuleConstants;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.frameworks.internal.ui.WTPUIPlugin;
import org.eclipse.wst.common.frameworks.internal.ui.WorkspaceModifyComposedOperation;
import org.eclipse.wst.common.internal.emfworkbench.validateedit.ResourceStateValidator;

public class JARDependencyPropertiesPage
implements IJ2EEDependenciesControl,
IClasspathTableOwner,
Listener,
ClasspathModelListener,
IElementChangedListener {
    protected final IProject project;
    protected final J2EEDependenciesPage propPage;
    protected IOException caughtManifestException;
    protected boolean isDirty;
    protected Text classPathText;
    protected Text componentNameText;
    protected ClasspathModel model;
    protected CCombo availableAppsCombo;
    protected ClasspathTableManager tableManager;
    protected IValidateEditListener validateEditListener;
    protected Label manifestLabel;
    protected Label enterpriseApplicationLabel;
    protected Label availableDependentJars;
    private final Display display;
    private boolean isDisposed = false;

    public JARDependencyPropertiesPage(IProject project, J2EEDependenciesPage page) {
        J2EEComponentClasspathUpdater.getInstance().pauseUpdates();
        this.project = project;
        this.propPage = page;
        this.display = this.propPage.getShell().getDisplay();
    }

    protected void initialize() {
        this.model = this.createClasspathModel();
        this.model.setProject(this.project);
        if (this.model.getComponent() != null) {
            this.model.addListener((ClasspathModelListener)this);
            this.updateModelManifest();
            this.initializeValidateEditListener();
        }
    }

    protected ClasspathModel createClasspathModel() {
        return new ClasspathModel(J2EEProjectUtilities.readManifest((IProject)this.project), false);
    }

    public void dispose() {
        this.isDisposed = true;
        JavaCore.removeElementChangedListener((IElementChangedListener)this);
        J2EEComponentClasspathUpdater.getInstance().resumeUpdates();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateModelManifest() {
        IFile iManifest;
        IVirtualFile vManifest;
        if (JemProjectUtilities.isBinaryProject((IProject)this.project) || this.model.getAvailableEARComponents().length == 0) {
            return;
        }
        IVirtualComponent component = ComponentCore.createComponent((IProject)this.project);
        if (component == null || !(vManifest = component.getRootFolder().getFile((IPath)new Path("META-INF/MANIFEST.MF"))).exists() || (iManifest = vManifest.getUnderlyingFile()) == null || !iManifest.exists()) return;
        InputStream in = null;
        try {
            in = iManifest.getContents();
            ArchiveManifestImpl mf = new ArchiveManifestImpl(new Manifest(in));
            this.model.primSetManifest((ArchiveManifest)mf);
        }
        catch (CoreException e) {
            Logger.getLogger().logError((Throwable)e);
            this.model.primSetManifest((ArchiveManifest)new ArchiveManifestImpl());
            if (in == null) return;
            try {
                in.close();
                return;
            }
            catch (IOException iOException) {}
            return;
        }
        catch (IOException iox) {
            try {
                Logger.getLogger().logError((Throwable)iox);
                this.model.primSetManifest((ArchiveManifest)new ArchiveManifestImpl());
                this.caughtManifestException = iox;
                if (in == null) return;
            }
            catch (Throwable throwable) {
                if (in == null) throw throwable;
                try {
                    in.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                in.close();
                return;
            }
            catch (IOException iOException) {}
            return;
        }
        if (in == null) return;
        try {
            in.close();
            return;
        }
        catch (IOException iOException) {}
    }

    protected void initializeValidateEditListener() {
        this.validateEditListener = new ValidateEditListener(null, (ResourceStateValidator)this.model);
        this.validateEditListener.setShell(this.propPage.getShell());
    }

    public void setVisible(boolean visible) {
        if (visible && this.caughtManifestException != null && !this.model.isDirty()) {
            ManifestErrorPrompter.showManifestException(this.propPage.getShell(), ERROR_READING_MANIFEST_DIALOG_MESSAGE_PROP_PAGE, false, this.caughtManifestException);
        }
    }

    public void elementChanged(ElementChangedEvent event) {
        if (event.getType() == 1 && this.classpathChanged(event.getDelta()) && !this.isDisposed) {
            this.display.asyncExec(new Runnable(){

                public void run() {
                    if (!JARDependencyPropertiesPage.this.isDisposed) {
                        JARDependencyPropertiesPage.this.handleClasspathChange();
                    }
                }
            });
        }
    }

    protected void handleClasspathChange() {
        this.model.resetClassPathSelection();
        this.refresh();
    }

    private boolean classpathChanged(IJavaElementDelta delta) {
        block7: {
            IJavaProject jproject;
            IProject eventProject;
            IJavaElement element;
            int flags;
            block8: {
                int kind = delta.getKind();
                if (kind != 4) break block7;
                flags = delta.getFlags();
                element = delta.getElement();
                if (!(element instanceof IJavaModel)) break block8;
                if ((flags & 8) != 8) break block7;
                IJavaElementDelta[] children = delta.getChangedChildren();
                int i = 0;
                while (i < children.length) {
                    if (this.classpathChanged(children[i])) {
                        return true;
                    }
                    ++i;
                }
                break block7;
            }
            if (element instanceof IJavaProject && (eventProject = (jproject = (IJavaProject)element).getProject()).equals((Object)this.project)) {
                if ((flags & 0x20000) != 0) {
                    return true;
                }
                IResourceDelta[] deltas = delta.getResourceDeltas();
                if (deltas != null) {
                    int i = 0;
                    while (i < deltas.length) {
                        if (deltas[i].getProjectRelativePath().toString().equals(".classpath")) {
                            return true;
                        }
                        ++i;
                    }
                }
            }
        }
        return false;
    }

    public Composite createContents(Composite parent) {
        this.initialize();
        Composite composite = this.createBasicComposite(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        if (this.model.getComponent() != null) {
            if (!this.isValidComponent()) {
                return composite;
            }
            J2EEDependenciesPage.createDescriptionComposite(composite, ManifestUIResourceHandler.J2EE_Modules_Desc);
            this.createProjectLabelsGroup(composite);
            this.createListGroup(composite);
            this.createTextGroup(composite);
            this.refresh();
        }
        Dialog.applyDialogFont((Control)parent);
        this.postCreateContents();
        return composite;
    }

    protected void postCreateContents() {
        JavaCore.addElementChangedListener((IElementChangedListener)this);
    }

    protected Composite createBasicComposite(Composite comp) {
        Composite composite = new Composite(comp, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        return composite;
    }

    protected boolean isValidComponent() {
        if (JavaEEProjectUtilities.isEARProject((IProject)this.project)) {
            this.propPage.setErrorMessage(ManifestUIResourceHandler.EAR_Module_Dep_Error);
            return false;
        }
        if (EarUtilities.isStandaloneProject((IProject)this.model.getComponent().getProject())) {
            this.propPage.setErrorMessage(ClasspathModel.NO_EAR_MESSAGE);
            return false;
        }
        return true;
    }

    protected void createProjectLabelsGroup(Composite parent) {
        Composite labelsGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        labelsGroup.setLayout((Layout)layout);
        labelsGroup.setLayoutData((Object)new GridData(768));
        this.createEnterpriseAppsControls(labelsGroup);
    }

    private void createEnterpriseAppsControls(Composite labelsGroup) {
        this.enterpriseApplicationLabel = new Label(labelsGroup, 0);
        this.enterpriseApplicationLabel.setText(ManifestUIResourceHandler.EAR_Project_Name__UI__UI_);
        this.availableAppsCombo = new CCombo(labelsGroup, 2056);
        GridData gd = new GridData(768);
        this.availableAppsCombo.setLayoutData((Object)gd);
        this.availableAppsCombo.addListener(13, (Listener)this);
    }

    protected void createListGroup(Composite parent) {
        Composite listGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        listGroup.setLayout((Layout)layout);
        GridData gData = new GridData(1808);
        gData.horizontalIndent = 5;
        listGroup.setLayoutData((Object)gData);
        this.availableDependentJars = new Label(listGroup, 0);
        gData = new GridData(272);
        this.availableDependentJars.setText(ManifestUIResourceHandler.Available_dependent_JARs__UI_);
        this.availableDependentJars.setLayoutData((Object)gData);
        this.createTableComposite(listGroup);
    }

    public Group createGroup(Composite parent) {
        return new Group(parent, 0);
    }

    protected void createTextGroup(Composite parent) {
        Composite textGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        textGroup.setLayout((Layout)layout);
        textGroup.setLayoutData((Object)new GridData(1808));
        this.createClassPathText(textGroup);
    }

    protected void createClassPathText(Composite textGroup) {
        this.manifestLabel = new Label(textGroup, 0);
        this.manifestLabel.setText(ManifestUIResourceHandler.Manifest_Class_Path__UI_);
        this.classPathText = new Text(textGroup, 2626);
        GridData gData = new GridData(1808);
        gData.widthHint = 400;
        gData.heightHint = 100;
        this.classPathText.setLayoutData((Object)gData);
        this.classPathText.setEditable(false);
    }

    protected void createTableComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gData = new GridData(1808);
        composite.setLayoutData((Object)gData);
        this.tableManager = new ClasspathTableManager(this, this.model, this.validateEditListener);
        this.tableManager.fillComposite(composite);
    }

    public CheckboxTableViewer createAvailableJARsViewer(Composite parent) {
        int flags = 67618;
        Table table = new Table(parent, flags);
        CheckboxTableViewer availableJARsViewer = new CheckboxTableViewer(table);
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(200, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(200, true));
        table.setLayout((Layout)tableLayout);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn fileNameColumn = new TableColumn(table, 0, 0);
        fileNameColumn.setText(ManifestUIResourceHandler.JAR_Module_UI_);
        fileNameColumn.setResizable(true);
        TableColumn projectColumn = new TableColumn(table, 0, 1);
        projectColumn.setText(ManifestUIResourceHandler.Project_UI_);
        projectColumn.setResizable(true);
        tableLayout.layout((Composite)table, true);
        return availableJARsViewer;
    }

    public Composite createButtonColumnComposite(Composite parent) {
        Composite buttonColumn = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonColumn.setLayout((Layout)layout);
        GridData data = new GridData(258);
        buttonColumn.setLayoutData((Object)data);
        return buttonColumn;
    }

    public Button primCreatePushButton(String label, Composite buttonColumn) {
        Button aButton = new Button(buttonColumn, 8);
        aButton.setText(label);
        return aButton;
    }

    public Button primCreateRadioButton(String label, Composite parent) {
        Button aButton = new Button(parent, 16);
        aButton.setText(label);
        return aButton;
    }

    public void handleEvent(Event event) {
        if (event.widget == this.availableAppsCombo) {
            this.availableAppsSelected(event);
        }
    }

    protected void availableAppsSelected(Event event) {
        int index = this.availableAppsCombo.getSelectionIndex();
        this.model.selectEAR(index);
    }

    protected void populateApps() {
        IVirtualComponent[] components = this.model.getAvailableEARComponents();
        String[] values = new String[components.length];
        int i = 0;
        while (i < components.length) {
            values[i] = components[i].getProject().getName();
            ++i;
        }
        if (this.availableAppsCombo != null) {
            this.availableAppsCombo.setItems(values);
            IVirtualComponent selected = this.model.getSelectedEARComponent();
            if (selected != null) {
                int index = Arrays.asList(components).indexOf(selected);
                this.availableAppsCombo.select(index);
            } else {
                this.availableAppsCombo.clearSelection();
            }
        }
    }

    protected void refresh() {
        this.populateApps();
        if (this.tableManager != null) {
            this.tableManager.refresh();
        }
        this.refreshText();
    }

    public void refreshText() {
        ClassPathSelection sel = this.model.getClassPathSelection();
        if (sel != null && this.classPathText != null) {
            this.classPathText.setText(sel.toString());
        }
    }

    public void modelChanged(ClasspathModelEvent evt) {
        if (evt.getEventType() == 1) {
            this.isDirty = true;
            this.refreshText();
        } else if (evt.getEventType() == 2) {
            this.tableManager.refresh();
        }
    }

    public void performDefaults() {
        this.model.resetClassPathSelection();
        this.refresh();
        this.isDirty = false;
        this.model.dispose();
    }

    public boolean performCancel() {
        this.model.dispose();
        return true;
    }

    /*
     * Exception decompiling
     */
    public boolean performOk() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IndexOutOfBoundsException: Index: 0, Size: 0
         *     at java.base/java.util.LinkedList.checkElementIndex(LinkedList.java:566)
         *     at java.base/java.util.LinkedList.get(LinkedList.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.combineInlineable(Block.java:226)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:560)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredCatch.transformStructuredChildren(StructuredCatch.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredTry.transformStructuredChildren(StructuredTry.java:129)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.transformStructuredChildren(Block.java:421)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredTry.transformStructuredChildren(StructuredTry.java:127)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.transformStructuredChildren(Block.java:421)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.inlinePossibles(Op04StructuredStatement.java:709)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:855)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    List getUnSelectedClassPathElementsForJ2EEDependency() {
        List unselectedForJ2EE = this.getUnSelectedClassPathSelection().getClasspathElements();
        ArrayList<ClasspathElement> unselected = new ArrayList<ClasspathElement>();
        if (this.model != null && this.model.getClassPathSelectionForWLPs() != null) {
            List wlpSelected = this.model.getClassPathSelectionForWLPs().getSelectedClasspathElements();
            for (ClasspathElement element : unselectedForJ2EE) {
                Iterator wlpIterator = wlpSelected.iterator();
                boolean found = false;
                while (wlpIterator.hasNext()) {
                    ClasspathElement wlpElement = (ClasspathElement)wlpIterator.next();
                    String text = element.getText();
                    int index = text.indexOf(".jar");
                    if (index == -1 || !(text = text.substring(0, index)).equals(wlpElement.getText())) continue;
                    found = true;
                    break;
                }
                if (found || unselected.contains(element)) continue;
                unselected.add(element);
            }
        }
        return unselected;
    }

    List getUnSelectedClassPathElementsForWebDependency() {
        List unselectedForWLP = this.getUnSelectedClassPathSelectionForWLPs().getClasspathElements();
        List<ClasspathElement> unselected = new ArrayList();
        if (this.model != null && this.model.getClassPathSelection() != null) {
            List j2eeSelected = this.model.getClassPathSelection().getSelectedClasspathElements();
            for (ClasspathElement element : unselectedForWLP) {
                Iterator j2eeIterator = j2eeSelected.iterator();
                boolean found = false;
                while (j2eeIterator.hasNext()) {
                    ClasspathElement j2eeElement = (ClasspathElement)j2eeIterator.next();
                    String text = j2eeElement.getText();
                    int index = text.indexOf(".jar");
                    if (index == -1) continue;
                    text = text.substring(0, index);
                    if (!element.getText().equals(text)) continue;
                    found = true;
                    break;
                }
                if (found || unselected.contains(element)) continue;
                unselected.add(element);
            }
        } else {
            unselected = unselectedForWLP;
        }
        return unselected;
    }

    protected WorkspaceModifyComposedOperation createJ2EEComponentDependencyOperations() {
        ClasspathElement element;
        WorkspaceModifyComposedOperation composedOp = null;
        List selected = this.getSelectedClassPathSelection().getClasspathElements();
        List unselected = this.getUnSelectedClassPathElementsForJ2EEDependency();
        ArrayList<IVirtualComponent> targetComponentsHandles = new ArrayList<IVirtualComponent>();
        int i = 0;
        while (i < selected.size()) {
            element = (ClasspathElement)selected.get(i);
            IVirtualComponent component = element.getComponent();
            if (component != null) {
                targetComponentsHandles.add(component);
            }
            ++i;
        }
        if (!targetComponentsHandles.isEmpty()) {
            composedOp = new WorkspaceModifyComposedOperation();
            composedOp.addRunnable((IRunnableWithProgress)WTPUIPlugin.getRunnableWithProgress((IUndoableOperation)ComponentUtilities.createReferenceComponentOperation((IVirtualComponent)this.model.getComponent(), targetComponentsHandles)));
        }
        targetComponentsHandles = new ArrayList();
        i = 0;
        while (i < unselected.size()) {
            element = (ClasspathElement)unselected.get(i);
            IProject elementProject = element.getProject();
            if (elementProject != null) {
                if (ModuleCoreNature.isFlexibleProject((IProject)elementProject)) {
                    IVirtualComponent targetComp = ComponentCore.createComponent((IProject)elementProject);
                    targetComponentsHandles.add(targetComp);
                }
            } else {
                URI archiveURI = element.getArchiveURI();
                if (archiveURI != null && !archiveURI.equals((Object)"")) {
                    IVirtualReference ref;
                    String name = "";
                    try {
                        String type = ModuleURIUtil.getArchiveType((URI)archiveURI);
                        String tmpname = ModuleURIUtil.getArchiveName((URI)archiveURI);
                        name = String.valueOf(type) + '/' + tmpname;
                    }
                    catch (UnresolveableURIException e) {
                        Logger.getLogger().logError(e.getMessage());
                    }
                    if (!name.equals("") && (ref = this.model.getComponent().getReference(name)) != null) {
                        IVirtualComponent referenced = ref.getReferencedComponent();
                        targetComponentsHandles.add(referenced);
                    }
                }
            }
            ++i;
        }
        if (!targetComponentsHandles.isEmpty()) {
            if (composedOp == null) {
                composedOp = new WorkspaceModifyComposedOperation();
            }
            composedOp.addRunnable((IRunnableWithProgress)WTPUIPlugin.getRunnableWithProgress((IUndoableOperation)ComponentUtilities.removeReferenceComponentOperation((IVirtualComponent)this.model.getComponent(), targetComponentsHandles)));
        }
        return composedOp;
    }

    protected WorkspaceModifyComposedOperation createComponentDependencyOperations() {
        IVirtualComponent targetComp;
        IProject elementProject;
        ClasspathElement element;
        WorkspaceModifyComposedOperation composedOp = null;
        ClassPathSelection selectedWLPs = this.getSelectedClassPathSelectionForWLPs();
        List selected = selectedWLPs.getClasspathElements();
        List unselected = this.getUnSelectedClassPathSelectionForWLPs().getClasspathElements();
        ArrayList<IVirtualComponent> targetComponentsHandles = new ArrayList<IVirtualComponent>();
        int i = 0;
        while (i < selected.size()) {
            element = (ClasspathElement)selected.get(i);
            if (!element.isClasspathDependency() && !element.isClasspathEntry() && (elementProject = element.getProject()) != null) {
                targetComp = ComponentCore.createComponent((IProject)elementProject);
                targetComponentsHandles.add(targetComp);
            }
            ++i;
        }
        if (!targetComponentsHandles.isEmpty()) {
            composedOp = new WorkspaceModifyComposedOperation();
            composedOp.addRunnable((IRunnableWithProgress)WTPUIPlugin.getRunnableWithProgress((IUndoableOperation)ComponentUtilities.createWLPReferenceComponentOperation((IVirtualComponent)this.model.getComponent(), targetComponentsHandles)));
        }
        targetComponentsHandles = new ArrayList();
        i = 0;
        while (i < unselected.size()) {
            element = (ClasspathElement)unselected.get(i);
            if (!element.isClasspathDependency() && !element.isClasspathEntry()) {
                elementProject = element.getProject();
                if (elementProject != null) {
                    if (ModuleCoreNature.isFlexibleProject((IProject)elementProject)) {
                        targetComp = ComponentCore.createComponent((IProject)elementProject);
                        targetComponentsHandles.add(targetComp);
                    }
                } else {
                    URI archiveURI = element.getArchiveURI();
                    if (archiveURI != null && !archiveURI.equals((Object)"")) {
                        String name = "";
                        try {
                            String type = ModuleURIUtil.getArchiveType((URI)archiveURI);
                            String tmpname = ModuleURIUtil.getArchiveName((URI)archiveURI);
                            name = String.valueOf(type) + '/' + tmpname;
                        }
                        catch (UnresolveableURIException e) {
                            Logger.getLogger().logError(e.getMessage());
                        }
                        if (!name.equals("")) {
                            IVirtualReference ref = this.model.getComponent().getReference(name);
                            IVirtualComponent referenced = ref.getReferencedComponent();
                            targetComponentsHandles.add(referenced);
                        }
                    }
                }
            }
            ++i;
        }
        if (!targetComponentsHandles.isEmpty()) {
            if (composedOp == null) {
                composedOp = new WorkspaceModifyComposedOperation();
            }
            composedOp.addRunnable((IRunnableWithProgress)WTPUIPlugin.getRunnableWithProgress((IUndoableOperation)ComponentUtilities.removeWLPReferenceComponentOperation((IVirtualComponent)this.model.getComponent(), targetComponentsHandles)));
        }
        if (composedOp == null) {
            composedOp = new WorkspaceModifyComposedOperation();
        }
        this.createClasspathAttributeUpdateOperation(composedOp, this.model.getClassPathSelectionForWLPs(), true);
        return composedOp;
    }

    protected WorkspaceModifyComposedOperation createFlexProjectOperations() {
        WorkspaceModifyComposedOperation composedOp = null;
        Object[] elements = this.tableManager.availableJARsViewer.getCheckedElements();
        int i = 0;
        while (i < elements.length) {
            ClasspathElement element = (ClasspathElement)elements[i];
            IProject elementProject = element.getProject();
            try {
                if (elementProject != null && !elementProject.hasNature("org.eclipse.wst.common.modulecore.ModuleCoreNature")) {
                    if (composedOp == null) {
                        composedOp = new WorkspaceModifyComposedOperation();
                    }
                    composedOp.addRunnable((IRunnableWithProgress)WTPUIPlugin.getRunnableWithProgress((IUndoableOperation)J2EEProjectUtilities.createFlexJavaProjectForProjectOperation((IProject)elementProject, (boolean)false)));
                }
            }
            catch (CoreException e) {
                Logger.getLogger().logError((Throwable)e);
            }
            ++i;
        }
        return composedOp;
    }

    protected ClassPathSelection getUnSelectedClassPathSelectionForWLPs() {
        ClassPathSelection selection = new ClassPathSelection();
        Object[] checkedElements = this.tableManager.availableJARsViewer.getCheckedElements();
        List modelElements = this.model.getClassPathSelectionForWLPs().getClasspathElements();
        int i = 0;
        while (i < modelElements.size()) {
            List<Object> checkedElementsList = Arrays.asList(checkedElements);
            if (!checkedElementsList.contains(modelElements.get(i))) {
                selection.getClasspathElements().add(modelElements.get(i));
            }
            ++i;
        }
        return selection;
    }

    private ClassPathSelection getSelectedClassPathSelection() {
        ClassPathSelection selection = new ClassPathSelection();
        Object[] checkedElements = this.tableManager.availableJARsViewer.getCheckedElements();
        int i = 0;
        while (i < checkedElements.length) {
            selection.getClasspathElements().add(checkedElements[i]);
            ++i;
        }
        return selection;
    }

    protected ClassPathSelection getUnSelectedClassPathSelection() {
        ClassPathSelection selection = new ClassPathSelection();
        Object[] checkedElements = this.tableManager.availableJARsViewer.getCheckedElements();
        List modelElements = this.model.getClassPathSelection().getClasspathElements();
        int i = 0;
        while (i < modelElements.size()) {
            List<Object> checkedElementsList = Arrays.asList(checkedElements);
            if (!checkedElementsList.contains(modelElements.get(i))) {
                selection.getClasspathElements().add(modelElements.get(i));
            }
            ++i;
        }
        return selection;
    }

    private ClassPathSelection getSelectedClassPathSelectionForWLPs() {
        ClassPathSelection selection = new ClassPathSelection();
        Object[] checkedElements = this.tableManager.availableJARsViewer.getCheckedElements();
        int i = 0;
        while (i < checkedElements.length) {
            selection.getClasspathElements().add(checkedElements[i]);
            ++i;
        }
        return selection;
    }

    protected UpdateManifestOperation createManifestOperation() {
        return new UpdateManifestOperation(this.project.getName(), this.model.getClassPathSelection().toString(), true);
    }

    protected void createClasspathAttributeUpdateOperation(WorkspaceModifyComposedOperation composedOp, ClassPathSelection selection, boolean isWebApp) {
        boolean webLibsOnly = isWebApp && !ClasspathDependencyEnablement.isAllowClasspathComponentDependency();
        HashMap<IClasspathEntry, IPath> selectedEntriesToRuntimePath = new HashMap<IClasspathEntry, IPath>();
        HashMap<IClasspathEntry, IPath> unselectedEntriesToRuntimePath = new HashMap<IClasspathEntry, IPath>();
        List elements = selection.getClasspathElements();
        int i = 0;
        while (i < elements.size()) {
            ClasspathElement element = (ClasspathElement)elements.get(i);
            if (element.isClasspathEntry()) {
                IClasspathEntry entry = element.getClasspathEntry();
                IClasspathAttribute attrib = ClasspathDependencyUtil.checkForComponentDependencyAttribute((IClasspathEntry)entry, (IClasspathDependencyConstants.DependencyAttributeType)IClasspathDependencyConstants.DependencyAttributeType.DEPENDENCY_OR_NONDEPENDENCY, (boolean)webLibsOnly);
                boolean hasDepAttrib = false;
                if (attrib != null && attrib.getName().equals("org.eclipse.jst.component.dependency")) {
                    hasDepAttrib = true;
                }
                IPath runtimePath = ClasspathDependencyUtil.getRuntimePath((IClasspathAttribute)attrib, (boolean)isWebApp, (boolean)ClasspathDependencyUtil.isClassFolderEntry((IClasspathEntry)entry));
                if (element.isSelected()) {
                    if (!hasDepAttrib) {
                        selectedEntriesToRuntimePath.put(entry, runtimePath);
                    }
                } else if (hasDepAttrib) {
                    unselectedEntriesToRuntimePath.put(entry, runtimePath);
                }
            }
            ++i;
        }
        if (!selectedEntriesToRuntimePath.isEmpty()) {
            IDataModelOperation op = UpdateClasspathAttributeUtil.createAddDependencyAttributesOperation((String)this.project.getName(), selectedEntriesToRuntimePath);
            composedOp.addRunnable((IRunnableWithProgress)WTPUIPlugin.getRunnableWithProgress((IUndoableOperation)op));
        }
        if (!unselectedEntriesToRuntimePath.isEmpty()) {
            IDataModelOperation op = UpdateClasspathAttributeUtil.createRemoveDependencyAttributesOperation((String)this.project.getName(), unselectedEntriesToRuntimePath);
            composedOp.addRunnable((IRunnableWithProgress)WTPUIPlugin.getRunnableWithProgress((IUndoableOperation)op));
        }
    }

    protected boolean isReadOnly() {
        return JemProjectUtilities.isBinaryProject((IProject)this.project) && this.project.findMember((IPath)IModuleConstants.COMPONENT_FILE_PATH) == null;
    }

    protected void modifyEARBundledLibs() {
        List compsToUncheckList = this.tableManager.getCheckedLibsAsList();
        if (compsToUncheckList.size() == 0) {
            return;
        }
        HashSet<IVirtualComponent> allCompsToUncheck = new HashSet<IVirtualComponent>();
        HashSet<String> allCompNamesToUncheck = new HashSet<String>();
        int i = 0;
        while (i < compsToUncheckList.size()) {
            IVirtualComponent comp = (IVirtualComponent)compsToUncheckList.get(i);
            allCompsToUncheck.add(comp);
            if (comp instanceof J2EEModuleVirtualArchiveComponent) {
                allCompNamesToUncheck.add(comp.getName());
            }
            ++i;
        }
        IProject[] ears = EarUtilities.getReferencingEARProjects((IProject)this.project);
        int i2 = 0;
        while (i2 < ears.length) {
            IVirtualComponent earComponent;
            List listToUncheck;
            if (J2EEProjectUtilities.isJEEProject((IProject)ears[i2]) && (listToUncheck = this.createListToUncheck(earComponent = ComponentCore.createComponent((IProject)ears[i2]), allCompsToUncheck, allCompNamesToUncheck)).size() != 0) {
                this.removeModulesFromEAR((IProgressMonitor)new NullProgressMonitor(), earComponent, listToUncheck);
                this.addModulesToEAR((IProgressMonitor)new NullProgressMonitor(), earComponent, listToUncheck);
            }
            ++i2;
        }
    }

    private IStatus removeModulesFromEAR(IProgressMonitor monitor, IVirtualComponent earComponent, List compsToUncheckList) {
        IStatus stat = IDataModelProvider.OK_STATUS;
        String libDir = ((Application)ModelProviderManager.getModelProvider((IProject)earComponent.getProject()).getModelObject()).getLibraryDirectory();
        libDir = libDir == null ? "/lib" : libDir;
        Map dependentComps = this.getEARModuleDependencies(earComponent, compsToUncheckList);
        try {
            IDataModelOperation op = this.removeComponentFromEAROperation(earComponent, compsToUncheckList, libDir);
            op.execute(null, null);
            J2EEComponentClasspathUpdater.getInstance().queueUpdateEAR(earComponent.getProject());
            this.removeEARComponentDependencies(dependentComps);
        }
        catch (ExecutionException e) {
            Logger.getLogger().log((Throwable)e);
        }
        return stat;
    }

    private IStatus addModulesToEAR(IProgressMonitor monitor, final IVirtualComponent earComponent, final List compsToUncheckList) {
        try {
            IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    JARDependencyPropertiesPage.this.execAddOp(monitor, compsToUncheckList, "/", earComponent);
                }
            };
            J2EEUIPlugin.getWorkspace().run(runnable, monitor);
        }
        catch (Exception e) {
            Logger.getLogger().log((Throwable)e);
        }
        return IDataModelProvider.OK_STATUS;
    }

    private List createListToUncheck(IVirtualComponent earComponent, Set compsToUncheckList, Set compNamesToUncheck) {
        LinkedList<IVirtualComponent> res = new LinkedList<IVirtualComponent>();
        IVirtualReference[] refs = earComponent.getReferences();
        int j = 0;
        while (j < refs.length) {
            if (!refs[j].getRuntimePath().isRoot() && (compsToUncheckList.contains(refs[j].getReferencedComponent()) || compNamesToUncheck.contains(refs[j].getReferencedComponent().getName()))) {
                res.add(refs[j].getReferencedComponent());
            }
            ++j;
        }
        return res;
    }

    private void execAddOp(IProgressMonitor monitor, List list, String path, IVirtualComponent earComponent) throws CoreException {
        IDataModel dm = DataModelFactory.createDataModel((IDataModelProvider)new AddComponentToEnterpriseApplicationDataModelProvider());
        dm.setProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT", (Object)earComponent);
        dm.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT", (Object)list);
        dm.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT_DEPLOY_PATH", (Object)path);
        IStatus stat = dm.validateProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT");
        if (stat != IDataModelProvider.OK_STATUS) {
            throw new CoreException(stat);
        }
        try {
            dm.getDefaultOperation().execute(monitor, null);
        }
        catch (ExecutionException e) {
            Logger.getLogger().log((Throwable)e);
        }
    }

    protected IDataModelOperation removeComponentFromEAROperation(IVirtualComponent sourceComponent, List targetComponentsHandles, String dir) {
        IDataModel model = DataModelFactory.createDataModel((IDataModelProvider)new RemoveComponentFromEnterpriseApplicationDataModelProvider());
        model.setProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT", (Object)sourceComponent);
        List modHandlesList = (List)model.getProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT");
        modHandlesList.addAll(targetComponentsHandles);
        model.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT", (Object)modHandlesList);
        model.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT_DEPLOY_PATH", (Object)dir);
        return model.getDefaultOperation();
    }

    private Map getEARModuleDependencies(IVirtualComponent earComponent, List components) {
        HashMap dependentComps = new HashMap();
        int i = 0;
        while (i < components.size()) {
            ArrayList<IVirtualComponent> compsForProject = new ArrayList<IVirtualComponent>();
            IVirtualComponent comp = (IVirtualComponent)components.get(i);
            Set referencingComponents = IDependencyGraph.INSTANCE.getReferencingComponents(this.project);
            IProject[] dependentProjects = referencingComponents.toArray(new IProject[referencingComponents.size()]);
            int j = 0;
            while (j < dependentProjects.length) {
                IProject project = dependentProjects[j];
                if (!JavaEEProjectUtilities.isEARProject((IProject)project)) {
                    IVirtualReference ref;
                    IVirtualComponent dependentComp = ComponentCore.createComponent((IProject)project);
                    IProject[] refEARs = EarUtilities.getReferencingEARProjects((IProject)project);
                    boolean sameEAR = false;
                    int k = 0;
                    while (k < refEARs.length) {
                        if (refEARs[k].equals((Object)earComponent.getProject())) {
                            sameEAR = true;
                            break;
                        }
                        ++k;
                    }
                    if (!(!sameEAR || JavaEEProjectUtilities.isDynamicWebProject((IProject)project) && (ref = dependentComp.getReference(comp.getName())) != null && ref.getRuntimePath().equals((Object)new Path("/WEB-INF/lib")))) {
                        compsForProject.add(dependentComp);
                    }
                }
                ++j;
            }
            dependentComps.put(comp, compsForProject);
            ++i;
        }
        return dependentComps;
    }

    private void removeEARComponentDependencies(Map dependentComps) throws ExecutionException {
        for (IVirtualComponent target : dependentComps.keySet()) {
            List sources = (List)dependentComps.get(target);
            int i = 0;
            while (i < sources.size()) {
                IVirtualComponent source = (IVirtualComponent)sources.get(i);
                IDataModel model = DataModelFactory.createDataModel((IDataModelProvider)new RemoveReferenceComponentsDataModelProvider());
                model.setProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT", (Object)source);
                List modHandlesList = (List)model.getProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT");
                modHandlesList.add(target);
                model.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT", (Object)modHandlesList);
                model.getDefaultOperation().execute(null, null);
                this.removeManifestDependency(source, target);
                ++i;
            }
        }
    }

    private void removeManifestDependency(IVirtualComponent source, IVirtualComponent target) throws ExecutionException {
        String sourceProjName = source.getProject().getName();
        String targetProjName = target.getProject().getName();
        NullProgressMonitor monitor = new NullProgressMonitor();
        IFile manifestmf = J2EEProjectUtilities.getManifestFile((IProject)source.getProject());
        ArchiveManifest mf = J2EEProjectUtilities.readManifest((IProject)source.getProject());
        if (mf == null) {
            return;
        }
        IDataModel updateManifestDataModel = DataModelFactory.createDataModel((IDataModelProvider)new UpdateManifestDataModelProvider());
        updateManifestDataModel.setProperty("UpdateManifestDataModel.PROJECT_NAME", (Object)sourceProjName);
        updateManifestDataModel.setBooleanProperty("UpdateManifestDataModel.MERGE", false);
        updateManifestDataModel.setProperty("UpdateManifestDataModel.MANIFEST_FILE", (Object)manifestmf);
        String[] cp = mf.getClassPathTokenized();
        ArrayList<String> cpList = new ArrayList<String>();
        String cpToRemove = String.valueOf(targetProjName) + ".jar";
        int i = 0;
        while (i < cp.length) {
            if (!cp[i].equals(cpToRemove)) {
                cpList.add(cp[i]);
            }
            ++i;
        }
        updateManifestDataModel.setProperty("UpdateManifestDataModel.CLASSPATH_LIST", cpList);
        updateManifestDataModel.getDefaultOperation().execute((IProgressMonitor)monitor, null);
    }
}

