/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.internal;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.internal.IMemento;
import org.eclipse.wst.server.core.internal.ModulePublishInfo;
import org.eclipse.wst.server.core.internal.ModuleResourceDelta;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.internal.Trace;
import org.eclipse.wst.server.core.internal.XMLMemento;
import org.eclipse.wst.server.core.model.IModuleFile;
import org.eclipse.wst.server.core.model.IModuleFolder;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerPublishInfo {
    private static final String VERSION = "version";
    protected IPath path;
    protected Map<String, ModulePublishInfo> modulePublishInfo;

    protected ServerPublishInfo(IPath path) {
        this.path = path;
        this.modulePublishInfo = new HashMap<String, ModulePublishInfo>();
        this.load();
    }

    private String getKey(IModule[] module) {
        StringBuffer sb = new StringBuffer();
        if (module != null) {
            int size = module.length;
            int i = 0;
            while (i < size) {
                if (i != 0) {
                    sb.append("#");
                }
                if (module[i] != null) {
                    sb.append(module[i].getId());
                } else {
                    sb.append("null");
                }
                ++i;
            }
        }
        return sb.toString();
    }

    private String getKey(String moduleId) {
        return moduleId;
    }

    private IModule[] getModule(String moduleId) {
        if (moduleId == null || moduleId.length() == 0) {
            return new IModule[0];
        }
        ArrayList<IModule> list = new ArrayList<IModule>();
        StringTokenizer st = new StringTokenizer(moduleId, "#");
        while (st.hasMoreTokens()) {
            String mid = st.nextToken();
            if (mid == null || mid.length() <= 0) continue;
            IModule m = ServerUtil.getModule(mid);
            if (m == null) {
                return null;
            }
            list.add(m);
        }
        IModule[] modules = new IModule[list.size()];
        list.toArray(modules);
        return modules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasModulePublishInfo(IModule[] module) {
        String key = this.getKey(module);
        Map<String, ModulePublishInfo> map = this.modulePublishInfo;
        synchronized (map) {
            return this.modulePublishInfo.containsKey(key);
        }
    }

    public void removeDeletedModulePublishInfo(List moduleList) {
        this.removeDeletedModulePublishInfo(null, moduleList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDeletedModulePublishInfo(Server server, List moduleList) {
        int size = moduleList.size();
        ArrayList<String> removed = new ArrayList<String>();
        Map<String, ModulePublishInfo> map = this.modulePublishInfo;
        synchronized (map) {
            for (String key : this.modulePublishInfo.keySet()) {
                boolean found = false;
                int i = 0;
                while (i < size) {
                    IModule[] module = (IModule[])moduleList.get(i);
                    String key2 = this.getKey(module);
                    if (key != null && key.equals(key2)) {
                        found = true;
                    }
                    ++i;
                }
                if (server != null) {
                    try {
                        Integer in = server.modulePublishState.get(key);
                        if (in != null && in != 1) {
                            found = true;
                        }
                    }
                    catch (Exception exception) {}
                }
                if (found) continue;
                removed.add(key);
            }
            for (String key : removed) {
                this.modulePublishInfo.remove(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ModulePublishInfo getModulePublishInfo(IModule[] module) {
        String key = this.getKey(module);
        Map<String, ModulePublishInfo> map = this.modulePublishInfo;
        synchronized (map) {
            if (this.modulePublishInfo.containsKey(key)) {
                return this.modulePublishInfo.get(key);
            }
            IModule mod = module[module.length - 1];
            ModulePublishInfo mpi = new ModulePublishInfo(this.getKey(module), mod.getName(), mod.getModuleType(), mod.isExternal());
            this.modulePublishInfo.put(key, mpi);
            return mpi;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRemovedModules(List<IModule[]> moduleList) {
        int size = moduleList.size();
        ArrayList<ModulePublishInfo> removed = new ArrayList<ModulePublishInfo>();
        Map<String, ModulePublishInfo> map = this.modulePublishInfo;
        synchronized (map) {
            for (String key : this.modulePublishInfo.keySet()) {
                boolean found = false;
                int i = 0;
                while (i < size) {
                    IModule[] module = moduleList.get(i);
                    String key2 = this.getKey(module);
                    if (key != null && key.equals(key2)) {
                        found = true;
                    }
                    ++i;
                }
                if (found) continue;
                ModulePublishInfo mpi = this.modulePublishInfo.get(key);
                removed.add(mpi);
            }
            for (ModulePublishInfo mpi : removed) {
                String moduleId;
                IModule[] module2 = this.getModule(mpi.getModuleId());
                if ((module2 == null || module2.length == 0) && (moduleId = mpi.getModuleId()) != null) {
                    String[] ids = this.getModuleIds(moduleId);
                    int depth = ids.length;
                    module2 = new IModule[depth];
                    String s = "";
                    int i = 0;
                    while (i < depth) {
                        s = String.valueOf(s) + ids[i];
                        if (i == depth - 1) {
                            module2[i] = mpi.getDeletedModule();
                        } else {
                            ModulePublishInfo mpi2 = this.modulePublishInfo.get(s);
                            if (mpi2 != null) {
                                module2[i] = mpi2.getDeletedModule();
                            }
                        }
                        s = String.valueOf(s) + "#";
                        ++i;
                    }
                }
                if (module2 == null || module2.length <= 0) continue;
                moduleList.add(module2);
            }
        }
    }

    private String[] getModuleIds(String moduleId) {
        StringTokenizer st = new StringTokenizer(moduleId, "#");
        ArrayList<String> list = new ArrayList<String>(2);
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        String[] s = new String[list.size()];
        list.toArray(s);
        return s;
    }

    public void load() {
        block13: {
            String filename;
            block12: {
                filename = this.path.toOSString();
                if (new File(filename).exists()) {
                    if (Trace.FINEST) {
                        Trace.trace("/finest", "Loading publish info from " + filename);
                    }
                    DataInputStream in = null;
                    try {
                        in = new DataInputStream(new BufferedInputStream(new FileInputStream(filename)));
                        in.readByte();
                        in.readByte();
                        byte ver = in.readByte();
                        if (ver <= 1) {
                            int size = in.readInt();
                            int i = 0;
                            while (i < size) {
                                ModulePublishInfo mpi = new ModulePublishInfo(in);
                                this.modulePublishInfo.put(this.getKey(mpi.getModuleId()), mpi);
                                ++i;
                            }
                            return;
                        }
                    }
                    catch (Exception e) {
                        if (!Trace.WARNING) break block12;
                        Trace.trace("/warning", "Could not load publish information", e);
                    }
                }
            }
            if (new File(filename = String.valueOf(filename.substring(0, filename.length() - 3)) + "xml").exists()) {
                if (Trace.FINEST) {
                    Trace.trace("/finest", "Loading publish info from old format " + filename);
                }
                try {
                    IMemento memento2 = XMLMemento.loadMemento(filename);
                    Float f = memento2.getFloat(VERSION);
                    if (f != null && f.floatValue() >= 3.0f) {
                        return;
                    }
                    IMemento[] children = memento2.getChildren("module");
                    int size = children.length;
                    int i = 0;
                    while (i < size) {
                        ModulePublishInfo mpi = new ModulePublishInfo(children[i]);
                        this.modulePublishInfo.put(this.getKey(mpi.getModuleId()), mpi);
                        ++i;
                    }
                }
                catch (Exception e) {
                    if (!Trace.WARNING) break block13;
                    Trace.trace("/warning", "Could not load publish information", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        File f;
        String filename;
        block21: {
            filename = this.path.toOSString();
            if (Trace.FINEST) {
                Trace.trace("/finest", "Saving publish info to " + filename);
            }
            FilterOutputStream out = null;
            try {
                try {
                    out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(filename)));
                    ((DataOutputStream)out).writeByte(14);
                    ((DataOutputStream)out).writeByte(14);
                    ((DataOutputStream)out).writeByte(1);
                    Map<String, ModulePublishInfo> map = this.modulePublishInfo;
                    synchronized (map) {
                        ((DataOutputStream)out).writeInt(this.modulePublishInfo.keySet().size());
                        for (String controlRef : this.modulePublishInfo.keySet()) {
                            ModulePublishInfo mpi = this.modulePublishInfo.get(controlRef);
                            mpi.save((DataOutput)((Object)out));
                        }
                    }
                }
                catch (Exception e) {
                    if (Trace.SEVERE) {
                        Trace.trace("/severe", "Could not save publish information", e);
                    }
                    try {
                        if (out != null) {
                            out.close();
                        }
                        break block21;
                    }
                    catch (Exception exception) {}
                    break block21;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
        }
        if ((f = new File(filename = String.valueOf(filename.substring(0, filename.length() - 3)) + "xml")).exists()) {
            f.delete();
        }
    }

    public void fill(IModule[] module) {
        ModulePublishInfo mpi = this.getModulePublishInfo(module);
        mpi.fill(module);
    }

    protected IModuleResourceDelta[] getDelta(IModule[] module) {
        if (module == null) {
            return new IModuleResourceDelta[0];
        }
        return this.getModulePublishInfo(module).getDelta(module);
    }

    protected IModuleResource[] getResources(IModule[] module) {
        if (module == null) {
            return new IModuleResource[0];
        }
        return this.getModulePublishInfo(module).getModuleResources(module);
    }

    protected static IModuleResourceDelta[] getDelta(IModuleResource[] original, IModuleResource[] current) {
        if (original == null || current == null) {
            return new IModuleResourceDelta[0];
        }
        ArrayList<ModuleResourceDelta> list = new ArrayList<ModuleResourceDelta>();
        int size = original.length;
        int size2 = current.length;
        HashMap<IModuleResource, IModuleResource> originalMap = new HashMap<IModuleResource, IModuleResource>(size);
        int i = 0;
        while (i < size) {
            originalMap.put(original[i], original[i]);
            ++i;
        }
        i = 0;
        while (i < size2) {
            IModuleResource mf2;
            IModuleResource mf1;
            IModuleResource old = (IModuleResource)originalMap.remove(current[i]);
            if (old == null) {
                ModuleResourceDelta delta = new ModuleResourceDelta(current[i], 1);
                if (current[i] instanceof IModuleFolder) {
                    IModuleFolder currentFolder = (IModuleFolder)current[i];
                    delta.setChildren(ServerPublishInfo.getDeltaTree(currentFolder.members(), 1));
                }
                list.add(delta);
            } else if (current[i] instanceof IModuleFile) {
                mf1 = (IModuleFile)old;
                mf2 = (IModuleFile)current[i];
                if (mf1.getModificationStamp() != mf2.getModificationStamp()) {
                    list.add(new ModuleResourceDelta(current[i], 2));
                }
            } else {
                mf1 = (IModuleFolder)old;
                mf2 = (IModuleFolder)current[i];
                IModuleResourceDelta[] mrdc = ServerPublishInfo.getDelta(mf1.members(), mf2.members());
                if (mrdc.length > 0) {
                    ModuleResourceDelta mrd = new ModuleResourceDelta(current[i], 0);
                    mrd.setChildren(mrdc);
                    list.add(mrd);
                }
            }
            ++i;
        }
        i = 0;
        while (i < size) {
            if (originalMap.containsKey(original[i])) {
                ModuleResourceDelta delta = new ModuleResourceDelta(original[i], 3);
                if (original[i] instanceof IModuleFolder) {
                    IModuleFolder removedFolder = (IModuleFolder)original[i];
                    delta.setChildren(ServerPublishInfo.getDeltaTree(removedFolder.members(), 3));
                }
                list.add(delta);
            }
            ++i;
        }
        return list.toArray(new IModuleResourceDelta[list.size()]);
    }

    protected boolean hasDelta(IModule[] module) {
        if (module == null) {
            return false;
        }
        return this.hasModulePublishInfo(module) && this.getModulePublishInfo(module).hasDelta(module);
    }

    protected static boolean hasDelta(IModuleResource[] original, IModuleResource[] current) {
        if (original == null || current == null) {
            return false;
        }
        int size = original.length;
        int size2 = current.length;
        HashMap<IModuleResource, IModuleResource> originalMap = new HashMap<IModuleResource, IModuleResource>(size);
        int i = 0;
        while (i < size) {
            originalMap.put(original[i], original[i]);
            ++i;
        }
        i = 0;
        while (i < size2) {
            IModuleResource mf2;
            IModuleResource mf1;
            IModuleResource old = (IModuleResource)originalMap.remove(current[i]);
            if (old == null) {
                return true;
            }
            if (current[i] instanceof IModuleFile) {
                mf1 = (IModuleFile)old;
                mf2 = (IModuleFile)current[i];
                if (mf1.getModificationStamp() != mf2.getModificationStamp()) {
                    return true;
                }
            } else {
                mf1 = (IModuleFolder)old;
                mf2 = (IModuleFolder)current[i];
                if (ServerPublishInfo.hasDelta(mf1.members(), mf2.members())) {
                    return true;
                }
            }
            ++i;
        }
        return !originalMap.isEmpty();
    }

    private static IModuleResourceDelta[] getDeltaTree(IModuleResource[] resources, int kind) {
        if (resources == null) {
            return new IModuleResourceDelta[0];
        }
        ArrayList<ModuleResourceDelta> list = new ArrayList<ModuleResourceDelta>();
        int size = resources.length;
        int i = 0;
        while (i < size) {
            ModuleResourceDelta mrd = new ModuleResourceDelta(resources[i], kind);
            if (resources[i] instanceof IModuleFolder) {
                IModuleFolder mf = (IModuleFolder)resources[i];
                mrd.setChildren(ServerPublishInfo.getDeltaTree(mf.members(), kind));
            }
            list.add(mrd);
            ++i;
        }
        return list.toArray(new IModuleResourceDelta[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasStructureChanged(List<IModule[]> modules) {
        Map<String, ModulePublishInfo> map = this.modulePublishInfo;
        synchronized (map) {
            block5: {
                if (modules.size() == this.modulePublishInfo.keySet().size()) break block5;
                return true;
            }
            boolean[] changed = new boolean[1];
            for (IModule[] module : modules) {
                String key = this.getKey(module);
                if (this.modulePublishInfo.containsKey(key)) continue;
                changed[0] = true;
            }
            return changed[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startCaching() {
        Map<String, ModulePublishInfo> map = this.modulePublishInfo;
        synchronized (map) {
            for (ModulePublishInfo mpi : this.modulePublishInfo.values()) {
                mpi.startCaching();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        Map<String, ModulePublishInfo> map = this.modulePublishInfo;
        synchronized (map) {
            for (ModulePublishInfo mpi : this.modulePublishInfo.values()) {
                mpi.clearCache();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuildCache(IModule[] module) {
        Map<String, ModulePublishInfo> map = this.modulePublishInfo;
        synchronized (map) {
            String publishInfoKey = this.getKey(module);
            ModulePublishInfo mpi = this.modulePublishInfo.get(publishInfoKey);
            if (mpi != null) {
                mpi.startCaching();
                mpi.fill(module);
            }
        }
    }
}

