/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.editor;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.ui.internal.Trace;
import org.eclipse.wst.server.ui.internal.editor.IServerEditorPartFactory;

public class ServerEditorPartFactory
implements IServerEditorPartFactory {
    private IConfigurationElement element;
    private Expression fContextualLaunchExpr = null;

    public ServerEditorPartFactory(IConfigurationElement element) {
        this.element = element;
    }

    protected IConfigurationElement getConfigurationElement() {
        return this.element;
    }

    public String getId() {
        return this.element.getAttribute("id");
    }

    public String getName() {
        return this.element.getAttribute("name");
    }

    protected String[] getInsertionIds() {
        try {
            String insertionIds = this.element.getAttribute("insertionIds");
            ArrayList<String> list = new ArrayList<String>();
            if (insertionIds != null && insertionIds.length() > 0) {
                StringTokenizer st = new StringTokenizer(insertionIds, ",");
                while (st.hasMoreTokens()) {
                    String str = st.nextToken();
                    if (str == null || str.length() <= 0) continue;
                    list.add(str.trim());
                }
            }
            String[] s = new String[list.size()];
            list.toArray(s);
            return s;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean supportsInsertionId(String id) {
        if (id == null || id.length() == 0) {
            return false;
        }
        String[] s = this.getInsertionIds();
        if (s == null) {
            return false;
        }
        int size = s.length;
        int i = 0;
        while (i < size) {
            if (s[i].endsWith("*") ? id.length() >= s[i].length() && id.startsWith(s[i].substring(0, s[i].length() - 1)) : id.equals(s[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int getOrder() {
        try {
            String o = this.element.getAttribute("order");
            return Integer.parseInt(o);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    protected String[] getTypeIds() {
        try {
            ArrayList<String> list = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(this.element.getAttribute("typeIds"), ",");
            while (st.hasMoreTokens()) {
                String str = st.nextToken();
                if (str == null || str.length() <= 0) continue;
                list.add(str.trim());
            }
            String[] s = new String[list.size()];
            list.toArray(s);
            return s;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean supportsType(String id) {
        String[] s = this.getTypeIds();
        if (s == null || s.length == 0 || "*".equals(s[0])) {
            return true;
        }
        if (id == null || id.length() == 0) {
            return false;
        }
        int size = s.length;
        int i = 0;
        while (i < size) {
            if (s[i].endsWith("*") ? id.length() >= s[i].length() && id.startsWith(s[i].substring(0, s[i].length() - 1)) : id.equals(s[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean shouldCreatePage(IServerWorkingCopy server) {
        try {
            return this.isEnabled(server);
        }
        catch (Exception e) {
            if (Trace.SEVERE) {
                Trace.trace("/severe", "Error calling delegate", e);
            }
            return false;
        }
    }

    public IEditorPart createPage() {
        try {
            return (IEditorPart)this.element.createExecutableExtension("class");
        }
        catch (Exception e) {
            if (Trace.SEVERE) {
                Trace.trace("/severe", "Error calling delegate", e);
            }
            return null;
        }
    }

    public Expression getContextualLaunchEnablementExpression() throws CoreException {
        if (this.fContextualLaunchExpr == null) {
            IConfigurationElement enablement;
            IConfigurationElement[] elements = this.element.getChildren("enablement");
            IConfigurationElement iConfigurationElement = enablement = elements.length > 0 ? elements[0] : null;
            if (enablement != null) {
                this.fContextualLaunchExpr = ExpressionConverter.getDefault().perform(enablement);
            }
        }
        return this.fContextualLaunchExpr;
    }

    protected boolean evalEnablementExpression(IEvaluationContext context, Expression exp) throws CoreException {
        return exp != null ? exp.evaluate(context) != EvaluationResult.FALSE : false;
    }

    public boolean isEnabled(Object obj) throws CoreException {
        if (this.getContextualLaunchEnablementExpression() == null) {
            return true;
        }
        EvaluationContext context = new EvaluationContext(null, obj);
        context.setAllowPluginActivation(true);
        context.addVariable("server", obj);
        return this.evalEnablementExpression((IEvaluationContext)context, this.getContextualLaunchEnablementExpression());
    }
}

