/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.jdt.internal.javalite;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jst.common.jdt.internal.javalite.IJavaProjectLite;
import org.eclipse.jst.common.jdt.internal.javalite.JavaProjectLite;

public final class JavaCoreLite {
    public static String NATURE_ID = "org.eclipse.jdt.core.javanature";
    private static Object lock = new Object();
    private static JavaCoreLite INSTANCE = null;
    private Set<IProject> initializedJavaProjects = new HashSet<IProject>();
    private Map<IProject, JavaProjectLite> javaProjectLiteCache = new HashMap<IProject, JavaProjectLite>();
    private JavaCoreLiteListener listener = new JavaCoreLiteListener();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JavaCoreLite getInstance() {
        Object object = lock;
        synchronized (object) {
            if (INSTANCE == null) {
                INSTANCE = new JavaCoreLite();
            }
        }
        return INSTANCE;
    }

    private JavaCoreLite() {
        JavaCore.addElementChangedListener((IElementChangedListener)this.listener);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.listener, 6);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IJavaProjectLite createImpl(IProject project) {
        Object object = lock;
        synchronized (object) {
            if (this.javaProjectLiteCache.containsKey(project)) {
                return this.javaProjectLiteCache.get(project);
            }
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject != null) {
            boolean javaProjectInitialized = false;
            Object object2 = lock;
            synchronized (object2) {
                javaProjectInitialized = this.initializedJavaProjects.contains(project);
            }
            if (!javaProjectInitialized && JavaCoreLite.isInitialized(javaProject)) {
                object2 = lock;
                synchronized (object2) {
                    this.initializedJavaProjects.add(project);
                }
                javaProjectInitialized = true;
            }
            JavaProjectLite javaProjectLite = new JavaProjectLite(javaProject, javaProjectInitialized);
            Object object3 = lock;
            synchronized (object3) {
                this.javaProjectLiteCache.put(project, javaProjectLite);
            }
            return javaProjectLite;
        }
        return null;
    }

    static boolean isInitialized(IJavaProject javaProject) {
        JavaModelManager.PerProjectInfo projectInfo;
        return javaProject.isOpen() && (projectInfo = JavaModelManager.getJavaModelManager().getPerProjectInfo(javaProject.getProject(), false)) != null && projectInfo.getResolvedClasspath() != null;
    }

    public static final IJavaProjectLite create(IProject project) {
        if (project == null) {
            throw new NullPointerException();
        }
        return JavaCoreLite.getInstance().createImpl(project);
    }

    public static final IJavaProjectLite create(IJavaProject javaProject) {
        if (javaProject == null) {
            throw new NullPointerException();
        }
        return JavaCoreLite.create(javaProject.getProject());
    }

    public static ClasspathContainerInitializer getClasspathContainerInitializer(String containerID) {
        return JavaCore.getClasspathContainerInitializer((String)containerID);
    }

    public static IClasspathEntry newProjectEntry(IPath path) {
        return JavaCore.newProjectEntry((IPath)path);
    }

    public static IClasspathEntry newProjectEntry(IPath path, boolean isExported) {
        return JavaCore.newProjectEntry((IPath)path, (boolean)isExported);
    }

    public static IClasspathEntry newProjectEntry(IPath path, IAccessRule[] accessRules, boolean combineAccessRules, IClasspathAttribute[] extraAttributes, boolean isExported) {
        return JavaCore.newProjectEntry((IPath)path, (IAccessRule[])accessRules, (boolean)combineAccessRules, (IClasspathAttribute[])extraAttributes, (boolean)isExported);
    }

    public static IClasspathEntry newLibraryEntry(IPath path, IPath sourceAttachmentPath, IPath sourceAttachmentRootPath) {
        return JavaCore.newLibraryEntry((IPath)path, (IPath)sourceAttachmentPath, (IPath)sourceAttachmentRootPath);
    }

    public static IClasspathEntry newLibraryEntry(IPath path, IPath sourceAttachmentPath, IPath sourceAttachmentRootPath, boolean isExported) {
        return JavaCore.newLibraryEntry((IPath)path, (IPath)sourceAttachmentPath, (IPath)sourceAttachmentRootPath, (boolean)isExported);
    }

    public static IClasspathEntry newLibraryEntry(IPath path, IPath sourceAttachmentPath, IPath sourceAttachmentRootPath, IAccessRule[] accessRules, IClasspathAttribute[] extraAttributes, boolean isExported) {
        return JavaCore.newLibraryEntry((IPath)path, (IPath)sourceAttachmentPath, (IPath)sourceAttachmentRootPath, (IAccessRule[])accessRules, (IClasspathAttribute[])extraAttributes, (boolean)isExported);
    }

    private class JavaCoreLiteListener
    implements IElementChangedListener,
    IResourceChangeListener {
        private JavaCoreLiteListener() {
        }

        public void elementChanged(ElementChangedEvent event) {
            IJavaElementDelta delta = event.getDelta();
            IJavaElementDelta[] children = delta.getAffectedChildren();
            int i = 0;
            while (i < children.length) {
                this.processDelta(children[i]);
                ++i;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processDelta(IJavaElementDelta delta) {
            IJavaElement element;
            int flags = delta.getFlags();
            if ((flags & 0x400) != 0) {
                IJavaElement element2 = delta.getElement();
                IJavaProject javaProject = (IJavaProject)element2;
                IProject project = javaProject.getProject();
                Object object = lock;
                synchronized (object) {
                    JavaCoreLite.this.initializedJavaProjects.remove(project);
                    JavaCoreLite.this.javaProjectLiteCache.remove(project);
                }
            }
            if ((flags & 0x20000) != 0) {
                IJavaElement element3 = delta.getElement();
                if (element3.getElementType() == 2) {
                    IJavaProject javaProject = (IJavaProject)element3;
                    IProject project = javaProject.getProject();
                    Object object = lock;
                    synchronized (object) {
                        if (!JavaCoreLite.this.initializedJavaProjects.contains(project) && JavaCoreLite.this.javaProjectLiteCache.containsKey(project)) {
                            JavaProjectLite javaProjectLite = (JavaProjectLite)JavaCoreLite.this.javaProjectLiteCache.get(project);
                            javaProjectLite.flushClasspath();
                        }
                    }
                }
            } else if ((flags & 0x200000) != 0 && (element = delta.getElement()).getElementType() == 2) {
                IJavaProject javaProject = (IJavaProject)element;
                IProject project = javaProject.getProject();
                Object object = lock;
                synchronized (object) {
                    if (!JavaCoreLite.this.initializedJavaProjects.contains(project)) {
                        JavaCoreLite.this.initializedJavaProjects.add(project);
                        if (JavaCoreLite.this.javaProjectLiteCache.containsKey(project)) {
                            JavaProjectLite javaProjectLite = (JavaProjectLite)JavaCoreLite.this.javaProjectLiteCache.get(project);
                            javaProjectLite.markJavaProjectInitialized();
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resourceChanged(IResourceChangeEvent event) {
            switch (event.getType()) {
                case 2: 
                case 4: {
                    IResource resource = event.getResource();
                    if (resource.getType() != 4) break;
                    IProject project = (IProject)resource;
                    Object object = lock;
                    synchronized (object) {
                        JavaCoreLite.this.initializedJavaProjects.remove(project);
                        JavaCoreLite.this.javaProjectLiteCache.remove(project);
                        break;
                    }
                }
            }
        }
    }
}

