/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.codegen.javamofvisitors;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jem.java.Field;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.JavaParameter;
import org.eclipse.jem.java.Method;
import org.eclipse.jst.ws.internal.consumption.codegen.Visitor;
import org.eclipse.jst.ws.internal.consumption.codegen.VisitorAction;
import org.eclipse.jst.ws.internal.consumption.command.common.JavaMofReflectionCommand;
import org.eclipse.jst.ws.internal.consumption.datamodel.beanmodel.TypeFactory;
import org.eclipse.jst.ws.internal.consumption.sampleapp.common.SamplePropertyDescriptor;
import org.eclipse.wst.common.environment.IEnvironment;

public class JavaMofAttributeVisitor
implements Visitor {
    public static final String copyright = "(c) Copyright IBM Corporation 2000, 2002.";
    private String clientProject;
    private boolean returnParameter;
    private IEnvironment env;

    public void setEnvironment(IEnvironment env) {
        this.env = env;
    }

    public void setProject(String clientProject) {
        this.clientProject = clientProject;
    }

    public String getProject() {
        return this.clientProject;
    }

    public void setReturnParameter(boolean returnParameter) {
        this.returnParameter = returnParameter;
    }

    public IStatus run(Object javaclass, VisitorAction vAction) {
        IStatus status = Status.OK_STATUS;
        JavaClass javaClass = (JavaClass)javaclass;
        Hashtable<String, SamplePropertyDescriptor> spdMap = new Hashtable<String, SamplePropertyDescriptor>();
        Iterator m = javaClass.getPublicMethods().iterator();
        while (m.hasNext()) {
            Method method = (Method)m.next();
            if ((!method.getMethodElementSignature().startsWith("get") && !method.getMethodElementSignature().startsWith("is") || method.listParametersWithoutReturn().length != 0) && (!method.getMethodElementSignature().startsWith("set") || method.listParametersWithoutReturn().length <= 0)) continue;
            int sub = 3;
            if (method.getMethodElementSignature().startsWith("is")) {
                sub = 2;
            }
            String propertyName = method.getMethodElementSignature().substring(sub);
            String lower = propertyName.substring(0, 1).toLowerCase();
            String remainder = propertyName.substring(1);
            propertyName = String.valueOf(lower) + remainder;
            String temp = propertyName;
            int index = propertyName.lastIndexOf("(");
            SamplePropertyDescriptor spd = (SamplePropertyDescriptor)spdMap.get(propertyName = temp.substring(0, index));
            if (spd == null) {
                spd = new SamplePropertyDescriptor(propertyName);
                spdMap.put(propertyName, spd);
            }
            if (method.getMethodElementSignature().startsWith("set")) {
                spd.setWriteMethod(method);
            } else {
                spd.setReadMethod(method);
            }
            Field field = javaClass.getFieldNamed(propertyName);
            JavaHelpers propertyType = null;
            if (field != null) {
                propertyType = (JavaHelpers)field.getEType();
                spd.setfStatic(field.isStatic());
            } else if (method.getMethodElementSignature().startsWith("get") || method.getMethodElementSignature().startsWith("is")) {
                propertyType = method.getReturnType();
            } else {
                JavaParameter[] params = method.listParametersWithoutReturn();
                propertyType = params[0].getJavaType();
            }
            spd.setPropertyType(propertyType);
        }
        Enumeration spdEnum = spdMap.elements();
        while (spdEnum.hasMoreElements()) {
            SamplePropertyDescriptor spd = (SamplePropertyDescriptor)spdEnum.nextElement();
            if (this.spdCheck(spd) && (status = vAction.visit(spd)).getSeverity() == 4) break;
        }
        return status;
    }

    private boolean spdCheck(SamplePropertyDescriptor spd) {
        Method writeMethod = spd.getWriteMethod();
        if (writeMethod != null && writeMethod.listParametersWithoutReturn().length > 1) {
            return false;
        }
        if (spd.getPropertyType() == null) {
            return false;
        }
        if (spd.getPropertyType().isPrimitive()) {
            return true;
        }
        if (this.returnParameter && TypeFactory.isRecognizedReturnType(spd.getPropertyType())) {
            return true;
        }
        if (!this.returnParameter && TypeFactory.isUnSupportedType(spd.getPropertyType())) {
            return true;
        }
        if (!this.checkPolarity(spd)) {
            return false;
        }
        JavaMofReflectionCommand javaMofRef = new JavaMofReflectionCommand();
        javaMofRef.setClientProject(this.getProject());
        javaMofRef.setProxyBean(spd.getPropertyType().getQualifiedName());
        javaMofRef.setEnvironment(this.env);
        javaMofRef.execute(null, null);
        if (javaMofRef.getJavaClass() instanceof JavaClass) {
            if (TypeFactory.recognizedBean(javaMofRef.getJavaClass().getJavaName())) {
                return true;
            }
            return this.defaultCheck((JavaClass)javaMofRef.getJavaClass());
        }
        return true;
    }

    private boolean checkPolarity(SamplePropertyDescriptor spd) {
        Method readMethod = spd.getReadMethod();
        Method writeMethod = spd.getWriteMethod();
        if (readMethod == null && writeMethod != null || readMethod != null && writeMethod == null) {
            return true;
        }
        if (readMethod == null && writeMethod == null) {
            return false;
        }
        JavaParameter[] javaParameter = writeMethod.listParametersWithoutReturn();
        int i = 0;
        while (i < javaParameter.length) {
            JavaParameter jp = javaParameter[i];
            jp.getJavaType().getJavaName();
            readMethod.getReturnType().getJavaName();
            if (jp.getJavaType().getJavaName().equals(readMethod.getReturnType().getJavaName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean defaultCheck(JavaClass javaClass) {
        Iterator m = javaClass.getMethods().iterator();
        boolean defaultConst = true;
        while (m.hasNext()) {
            Method method = (Method)m.next();
            if (!javaClass.getName().equals(method.getName())) continue;
            JavaParameter[] javaParameter = method.listParametersWithoutReturn();
            if (javaParameter.length > 0) {
                defaultConst = false;
                continue;
            }
            if (javaParameter.length != 0 || method.getJavaVisibility().getValue() != 0) continue;
            return true;
        }
        return defaultConst;
    }
}

