/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.refactoring;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterables.CompositeIterable;
import org.eclipse.jpt.common.utility.internal.iterables.FilteringIterable;
import org.eclipse.jpt.common.utility.internal.iterables.TransformationIterable;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.JpaProjectManager;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.context.persistence.MappingFileRef;
import org.eclipse.jpt.jpa.core.context.persistence.Persistence;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceXml;
import org.eclipse.jpt.jpa.core.internal.refactoring.JpaCoreRefactoringMessages;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.DeleteParticipant;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJpaDeleteTypeParticipant
extends DeleteParticipant {
    protected final Set<IType> allTypes = new HashSet<IType>();
    protected final Map<IFile, Iterable<DeleteEdit>> persistenceXmlDeleteEdits = new HashMap<IFile, Iterable<DeleteEdit>>();
    protected final Map<IFile, Iterable<DeleteEdit>> mappingFilePersistentTypeDeleteEdits = new HashMap<IFile, Iterable<DeleteEdit>>();

    protected AbstractJpaDeleteTypeParticipant() {
    }

    protected void addType(IType type) {
        this.allTypes.add(type);
        this.addNestedTypes(type);
    }

    private void addNestedTypes(IType type) {
        IType[] nestedTypes;
        try {
            nestedTypes = type.getTypes();
        }
        catch (JavaModelException ex) {
            JptJpaCorePlugin.log(ex);
            return;
        }
        IType[] iTypeArray = nestedTypes;
        int n = nestedTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IType nestedType = iTypeArray[n2];
            this.addType(nestedType);
            ++n2;
        }
    }

    public RefactoringStatus checkConditions(IProgressMonitor monitor, CheckConditionsContext context) throws OperationCanceledException {
        monitor.subTask(JpaCoreRefactoringMessages.JPA_REFACORING_PARTICIPANT_LOADING_JPA_PROJECTS_SUB_TASK_NAME);
        JpaProjectManager jpaProjectManager = JptJpaCorePlugin.getJpaProjectManager();
        if (jpaProjectManager.getJpaProjectsSize() == 0) {
            return null;
        }
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)(jpaProjectManager.getJpaProjectsSize() * 10 + 2));
        sm.subTask(this.getCheckConditionsSubTaskName());
        ResourceChangeChecker checker = (ResourceChangeChecker)context.getChecker(ResourceChangeChecker.class);
        IResourceChangeDescriptionFactory deltaFactory = checker.getDeltaFactory();
        for (JpaProject jpaProject : jpaProjectManager.getJpaProjects()) {
            this.createDeleteEdits((IProgressMonitor)sm.newChild(10), jpaProject);
        }
        if (sm.isCanceled()) {
            throw new OperationCanceledException();
        }
        for (IFile file : this.persistenceXmlDeleteEdits.keySet()) {
            deltaFactory.change(file);
        }
        sm.worked(1);
        for (IFile file : this.mappingFilePersistentTypeDeleteEdits.keySet()) {
            deltaFactory.change(file);
        }
        sm.worked(1);
        return null;
    }

    protected String getCheckConditionsSubTaskName() {
        return JpaCoreRefactoringMessages.JPA_DELETE_TYPE_REFACTORING_SUB_TASK_NAME;
    }

    public Change createChange(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        if (this.persistenceXmlDeleteEdits.isEmpty() && this.mappingFilePersistentTypeDeleteEdits.isEmpty()) {
            return null;
        }
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)(this.persistenceXmlDeleteEdits.size() + this.mappingFilePersistentTypeDeleteEdits.size()));
        sm.subTask(this.getCreateChangeSubTaskName());
        CompositeChange compositeChange = new CompositeChange(JpaCoreRefactoringMessages.JPA_DELETE_TYPE_REFACTORING_CHANGE_NAME);
        for (IFile persistenceXmlFile : this.persistenceXmlDeleteEdits.keySet()) {
            this.addPersistenceXmlDeleteTypeChange(persistenceXmlFile, compositeChange);
            sm.worked(1);
        }
        for (IFile mappingFile : this.mappingFilePersistentTypeDeleteEdits.keySet()) {
            if (sm.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.addMappingFileDeleteTypeChange(mappingFile, compositeChange);
            sm.worked(1);
        }
        return compositeChange.getChildren().length == 0 ? null : compositeChange;
    }

    protected String getCreateChangeSubTaskName() {
        return JpaCoreRefactoringMessages.JPA_DELETE_TYPE_REFACTORING_SUB_TASK_NAME;
    }

    protected void createDeleteEdits(IProgressMonitor monitor, JpaProject jpaProject) throws OperationCanceledException {
        PersistenceUnit persistenceUnit = this.getPersistenceUnit(jpaProject);
        if (persistenceUnit == null) {
            return;
        }
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)(1 + persistenceUnit.mappingFileRefsSize()));
        Iterable<DeleteEdit> persistenceXmlDeleteEdits = this.createPersistenceXmlDeleteEdits(persistenceUnit);
        if (!CollectionTools.isEmpty(persistenceXmlDeleteEdits)) {
            this.persistenceXmlDeleteEdits.put(jpaProject.getPersistenceXmlResource().getFile(), persistenceXmlDeleteEdits);
        }
        sm.worked(1);
        for (MappingFileRef mappingFileRef : CollectionTools.iterable(persistenceUnit.mappingFileRefs())) {
            if (sm.isCanceled()) {
                throw new OperationCanceledException();
            }
            Iterable<DeleteEdit> mappingFileDeleteEdits = this.createMappingFileDeleteTypeEdits(mappingFileRef);
            if (!CollectionTools.isEmpty(mappingFileDeleteEdits)) {
                this.mappingFilePersistentTypeDeleteEdits.put((IFile)mappingFileRef.getMappingFile().getResource(), mappingFileDeleteEdits);
            }
            sm.worked(1);
        }
    }

    protected Iterable<DeleteEdit> createPersistenceXmlDeleteEdits(final PersistenceUnit persistenceUnit) {
        return new CompositeIterable((Iterable)new TransformationIterable<IType, Iterable<DeleteEdit>>(this.getTypesOnClasspath(persistenceUnit.getJpaProject())){

            protected Iterable<DeleteEdit> transform(IType type) {
                return persistenceUnit.createDeleteTypeEdits(type);
            }
        });
    }

    protected Iterable<IType> getTypesOnClasspath(JpaProject jpaProject) {
        final IJavaProject javaProject = jpaProject.getJavaProject();
        return new FilteringIterable<IType>(this.allTypes){

            protected boolean accept(IType type) {
                return javaProject.isOnClasspath((IJavaElement)type);
            }
        };
    }

    protected void addPersistenceXmlDeleteTypeChange(IFile persistenceXmlFile, CompositeChange compositeChange) {
        Iterable<DeleteEdit> deleteTypeEdits = this.persistenceXmlDeleteEdits.get(persistenceXmlFile);
        TextChange textChange = this.getTextChange(persistenceXmlFile);
        if (textChange == null) {
            textChange = new TextFileChange(JpaCoreRefactoringMessages.JPA_DELETE_TYPE_REFACTORING_CHANGE_PERSISTENCE_XML_NAME, persistenceXmlFile);
            MultiTextEdit multiTextEdit = new MultiTextEdit();
            textChange.setEdit((TextEdit)multiTextEdit);
            compositeChange.add((Change)textChange);
        }
        this.addEdits(textChange, deleteTypeEdits);
    }

    private Iterable<DeleteEdit> createMappingFileDeleteTypeEdits(final MappingFileRef mappingFileRef) {
        return new CompositeIterable((Iterable)new TransformationIterable<IType, Iterable<DeleteEdit>>(this.getTypesOnClasspath(mappingFileRef.getJpaProject())){

            protected Iterable<DeleteEdit> transform(IType type) {
                return mappingFileRef.createDeleteTypeEdits(type);
            }
        });
    }

    protected void addMappingFileDeleteTypeChange(IFile mappingFile, CompositeChange compositeChange) {
        Iterable<DeleteEdit> deleteTypeEdits = this.mappingFilePersistentTypeDeleteEdits.get(mappingFile);
        TextChange textChange = this.getTextChange(mappingFile);
        if (textChange == null) {
            textChange = new TextFileChange(JpaCoreRefactoringMessages.JPA_DELETE_TYPE_REFACTORING_CHANGE_MAPPING_FILE_NAME, mappingFile);
            MultiTextEdit multiTextEdit = new MultiTextEdit();
            textChange.setEdit((TextEdit)multiTextEdit);
            compositeChange.add((Change)textChange);
        }
        this.addEdits(textChange, deleteTypeEdits);
    }

    private PersistenceUnit getPersistenceUnit(JpaProject jpaProject) {
        PersistenceXml persistenceXml = jpaProject.getRootContextNode().getPersistenceXml();
        if (persistenceXml == null) {
            return null;
        }
        Persistence persistence = persistenceXml.getPersistence();
        if (persistence == null) {
            return null;
        }
        if (persistence.persistenceUnitsSize() != 1) {
            return null;
        }
        return persistence.persistenceUnits().next();
    }

    private void addEdits(TextChange textChange, Iterable<? extends TextEdit> textEdits) {
        for (TextEdit textEdit : textEdits) {
            try {
                textChange.addEdit(textEdit);
            }
            catch (MalformedTreeException ex) {
                JptJpaCorePlugin.log(ex);
            }
        }
    }
}

