/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.audio;

import java.net.URL;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.server.ui.internal.ImageResource;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.audio.AudioCore;
import org.eclipse.wst.server.ui.internal.audio.AudioPreferencePage;
import org.eclipse.wst.server.ui.internal.audio.Sound;

class AudioTableLabelProvider
implements ITableLabelProvider {
    protected AudioPreferencePage page;

    public AudioTableLabelProvider(AudioPreferencePage page) {
        this.page = page;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 1) {
            if (element instanceof String) {
                return ImageResource.getImage("category");
            }
            return ImageResource.getImage("sound");
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return "";
        }
        if (element instanceof String) {
            String categoryId = (String)element;
            if (columnIndex == 1) {
                if (categoryId.equals("miscCategory")) {
                    return "";
                }
                Map<String, String> categories = AudioCore.getInstance().getCategories();
                return categories.get(categoryId);
            }
            return "";
        }
        Sound sound = (Sound)element;
        if (columnIndex == 1) {
            String s = sound.getName();
            if (s != null) {
                return s;
            }
            return Messages.audioUnknown;
        }
        if (columnIndex == 2) {
            IPath path = this.page.getUserSoundPath(sound.getId());
            if (path != null) {
                return path.lastSegment();
            }
            URL url = this.page.getSoundURL(sound.getId());
            if (url == null) {
                return Messages.audioNone;
            }
            return Messages.audioDefault;
        }
        return "";
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

