/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.resource.java.binary;

import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.iterators.CloneListIterator;
import org.eclipse.jpt.jpa.core.internal.resource.java.binary.BinaryAnnotation;
import org.eclipse.jpt.jpa.core.internal.resource.java.binary.BinaryQueryHintAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.jpa.core.resource.java.QueryAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.QueryHintAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BinaryQueryAnnotation
extends BinaryAnnotation
implements QueryAnnotation {
    String name = this.buildName();
    String query = this.buildQuery();
    final Vector<QueryHintAnnotation> hints = this.buildHints();

    BinaryQueryAnnotation(JavaResourceNode parent, IAnnotation jdtAnnotation) {
        super(parent, jdtAnnotation);
    }

    @Override
    public void update() {
        super.update();
        this.setName_(this.buildName());
        this.setQuery_(this.buildQuery());
        this.updateHints();
    }

    public void toString(StringBuilder sb) {
        sb.append(this.name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        throw new UnsupportedOperationException();
    }

    private void setName_(String name) {
        String old = this.name;
        this.name = name;
        this.firePropertyChanged("name", old, name);
    }

    private String buildName() {
        return (String)this.getJdtMemberValue(this.getNameElementName());
    }

    abstract String getNameElementName();

    @Override
    public TextRange getNameTextRange(CompilationUnit astRoot) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public void setQuery(String query) {
        throw new UnsupportedOperationException();
    }

    private void setQuery_(String query) {
        String old = this.query;
        this.query = query;
        this.firePropertyChanged("query", old, query);
    }

    private String buildQuery() {
        return (String)this.getJdtMemberValue(this.getQueryElementName());
    }

    abstract String getQueryElementName();

    @Override
    public TextRange getQueryTextRange(CompilationUnit astRoot) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<QueryHintAnnotation> hints() {
        return new CloneListIterator(this.hints);
    }

    @Override
    public int hintsSize() {
        return this.hints.size();
    }

    @Override
    public QueryHintAnnotation hintAt(int index) {
        return this.hints.get(index);
    }

    @Override
    public int indexOfHint(QueryHintAnnotation queryHint) {
        return this.hints.indexOf(queryHint);
    }

    @Override
    public QueryHintAnnotation addHint(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void moveHint(int targetIndex, int sourceIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeHint(int index) {
        throw new UnsupportedOperationException();
    }

    private Vector<QueryHintAnnotation> buildHints() {
        Object[] jdtHints = this.getJdtMemberValues(this.getHintsElementName());
        Vector<QueryHintAnnotation> result = new Vector<QueryHintAnnotation>(jdtHints.length);
        Object[] objectArray = jdtHints;
        int n = jdtHints.length;
        int n2 = 0;
        while (n2 < n) {
            Object jdtHint = objectArray[n2];
            result.add(new BinaryQueryHintAnnotation(this, (IAnnotation)jdtHint));
            ++n2;
        }
        return result;
    }

    abstract String getHintsElementName();

    private void updateHints() {
        throw new UnsupportedOperationException();
    }
}

