/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.resource.java.binary;

import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jpt.common.core.internal.utility.jdt.JPTTools;
import org.eclipse.jpt.common.utility.MethodSignature;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneIterable;
import org.eclipse.jpt.common.utility.internal.iterators.CompositeIterator;
import org.eclipse.jpt.common.utility.internal.iterators.FilteringIterator;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.internal.resource.java.binary.BinaryPersistentAttribute;
import org.eclipse.jpt.jpa.core.internal.resource.java.binary.BinaryPersistentMember;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.GeneratedAnnotation;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.JavaResourcePersistentType2_0;
import org.eclipse.jpt.jpa.core.resource.java.AccessType;
import org.eclipse.jpt.jpa.core.resource.java.Annotation;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class BinaryPersistentType
extends BinaryPersistentMember
implements JavaResourcePersistentType2_0 {
    private String name = this.buildName();
    private String qualifiedName = this.buildQualifiedName();
    private String packageName = this.buildPackageName();
    private String superclassQualifiedName = this.buildSuperclassQualifiedName();
    private String declaringTypeName = this.buildDeclaringTypeName();
    private boolean abstract_ = this.buildAbstract();
    private boolean static_ = this.buildStatic();
    private boolean memberType = this.buildMemberType();
    private boolean hasPrivateNoArgConstructor;
    private boolean hasNoArgConstructor = this.buildHasNoArgConstructor();
    private final Vector<JavaResourcePersistentAttribute> fields;
    private final Vector<JavaResourcePersistentAttribute> methods;
    private static final IField[] EMPTY_FIELD_ARRAY = new IField[0];
    private static final IMethod[] EMPTY_METHOD_ARRAY = new IMethod[0];

    BinaryPersistentType(JavaResourceNode parent, IType type) {
        super(parent, new TypeAdapter(type));
        this.hasPrivateNoArgConstructor = this.buildHasPrivateNoArgConstructor();
        this.fields = this.buildFields();
        this.methods = this.buildMethods();
    }

    @Override
    public void update() {
        super.update();
        this.setName(this.buildName());
        this.setQualifiedName(this.buildQualifiedName());
        this.setPackageName(this.buildPackageName());
        this.setSuperclassQualifiedName(this.buildSuperclassQualifiedName());
        this.setDeclaringTypeName(this.buildDeclaringTypeName());
        this.setAbstract(this.buildAbstract());
        this.setStatic(this.buildStatic());
        this.setMemberType(this.buildMemberType());
        this.setHasNoArgConstructor(this.buildHasNoArgConstructor());
        this.setHasPrivateNoArgConstructor(this.buildHasPrivateNoArgConstructor());
        this.updateFields();
        this.updateMethods();
    }

    private void updateFields() {
        throw new UnsupportedOperationException();
    }

    private void updateMethods() {
        throw new UnsupportedOperationException();
    }

    public void toString(StringBuilder sb) {
        sb.append(this.name);
    }

    @Override
    Annotation buildAnnotation(IAnnotation jdtAnnotation) {
        return this.getAnnotationProvider().buildTypeAnnotation(this, jdtAnnotation);
    }

    @Override
    Annotation buildNullAnnotation(String annotationName) {
        return this.getAnnotationProvider().buildNullTypeAnnotation(this, annotationName);
    }

    @Override
    Iterator<String> validAnnotationNames() {
        return this.getAnnotationProvider().typeAnnotationNames();
    }

    @Override
    public String getName() {
        return this.name;
    }

    private void setName(String name) {
        String old = this.name;
        this.name = name;
        this.firePropertyChanged("name", old, name);
    }

    private String buildName() {
        return this.getMember().getElementName();
    }

    @Override
    public String getQualifiedName() {
        return this.qualifiedName;
    }

    private void setQualifiedName(String qualifiedName) {
        String old = this.qualifiedName;
        this.qualifiedName = qualifiedName;
        this.firePropertyChanged("qualifiedName", old, qualifiedName);
    }

    private String buildQualifiedName() {
        return this.getMember().getFullyQualifiedName('.');
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    private void setPackageName(String packageName) {
        String old = this.packageName;
        this.packageName = packageName;
        this.firePropertyChanged("packageName", old, packageName);
    }

    private String buildPackageName() {
        return this.getMember().getPackageFragment().getElementName();
    }

    @Override
    public boolean isIn(IPackageFragment packageFragment) {
        return StringTools.stringsAreEqual((String)packageFragment.getElementName(), (String)this.packageName);
    }

    @Override
    public String getSuperclassQualifiedName() {
        return this.superclassQualifiedName;
    }

    private void setSuperclassQualifiedName(String superclassQualifiedName) {
        String old = this.superclassQualifiedName;
        this.superclassQualifiedName = superclassQualifiedName;
        this.firePropertyChanged("superclassQualifiedName", old, superclassQualifiedName);
    }

    private String buildSuperclassQualifiedName() {
        return BinaryPersistentType.convertTypeSignatureToTypeName(this.getSuperclassTypeSignature());
    }

    private String getSuperclassTypeSignature() {
        try {
            return this.getMember().getSuperclassTypeSignature();
        }
        catch (JavaModelException ex) {
            JptJpaCorePlugin.log(ex);
            return null;
        }
    }

    @Override
    public String getDeclaringTypeName() {
        return this.declaringTypeName;
    }

    private void setDeclaringTypeName(String declaringTypeName) {
        String old = this.declaringTypeName;
        this.declaringTypeName = declaringTypeName;
        this.firePropertyChanged("declaringTypeName", old, declaringTypeName);
    }

    private String buildDeclaringTypeName() {
        IType declaringType = this.getMember().getDeclaringType();
        return declaringType == null ? null : declaringType.getFullyQualifiedName('.');
    }

    @Override
    public boolean isAbstract() {
        return this.abstract_;
    }

    private void setAbstract(boolean abstract_) {
        boolean old = this.abstract_;
        this.abstract_ = abstract_;
        this.firePropertyChanged("abstract", old, abstract_);
    }

    private boolean buildAbstract() {
        try {
            return Flags.isAbstract((int)this.getMember().getFlags());
        }
        catch (JavaModelException ex) {
            JptJpaCorePlugin.log(ex);
            return false;
        }
    }

    @Override
    public boolean isStatic() {
        return this.static_;
    }

    private void setStatic(boolean static_) {
        boolean old = this.static_;
        this.static_ = static_;
        this.firePropertyChanged("static", old, static_);
    }

    private boolean buildStatic() {
        try {
            return Flags.isStatic((int)this.getMember().getFlags());
        }
        catch (JavaModelException ex) {
            JptJpaCorePlugin.log(ex);
            return false;
        }
    }

    @Override
    public boolean isMemberType() {
        return this.memberType;
    }

    private void setMemberType(boolean memberType) {
        boolean old = this.memberType;
        this.memberType = memberType;
        this.firePropertyChanged("memberType", old, memberType);
    }

    private boolean buildMemberType() {
        try {
            return this.getMember().isMember();
        }
        catch (JavaModelException ex) {
            JptJpaCorePlugin.log(ex);
            return false;
        }
    }

    @Override
    public boolean hasNoArgConstructor() {
        return this.hasNoArgConstructor;
    }

    private void setHasNoArgConstructor(boolean hasNoArgConstructor) {
        boolean old = this.hasNoArgConstructor;
        this.hasNoArgConstructor = hasNoArgConstructor;
        this.firePropertyChanged("noArgConstructor", old, hasNoArgConstructor);
    }

    private boolean buildHasNoArgConstructor() {
        return this.findNoArgConstructor() != null;
    }

    private IMethod findNoArgConstructor() {
        try {
            IMethod[] iMethodArray = this.getMember().getMethods();
            int n = iMethodArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod method = iMethodArray[n2];
                if (method.isConstructor()) {
                    return method;
                }
                ++n2;
            }
        }
        catch (JavaModelException ex) {
            JptJpaCorePlugin.log(ex);
        }
        return null;
    }

    @Override
    public boolean hasPrivateNoArgConstructor() {
        return this.hasPrivateNoArgConstructor;
    }

    private void setHasPrivateNoArgConstructor(boolean hasPrivateNoArgConstructor) {
        boolean old = this.hasPrivateNoArgConstructor;
        this.hasPrivateNoArgConstructor = hasPrivateNoArgConstructor;
        this.firePropertyChanged("privateNoArgConstructor", old, hasPrivateNoArgConstructor);
    }

    private boolean buildHasPrivateNoArgConstructor() {
        IMethod method = this.findNoArgConstructor();
        try {
            return method != null && Flags.isPrivate((int)method.getFlags());
        }
        catch (JavaModelException ex) {
            JptJpaCorePlugin.log(ex);
            return false;
        }
    }

    @Override
    public boolean isMapped() {
        for (Annotation annotation : CollectionTools.iterable(this.annotations())) {
            if (!this.annotationIsMappingAnnotation(annotation)) continue;
            return true;
        }
        return false;
    }

    private boolean annotationIsMappingAnnotation(Annotation annotation) {
        return CollectionTools.contains(this.mappingAnnotationNames(), (Object)annotation.getAnnotationName());
    }

    private Iterator<String> mappingAnnotationNames() {
        return this.getAnnotationProvider().typeMappingAnnotationNames();
    }

    @Override
    public boolean hasAnyAnnotatedAttributes() {
        Iterator<JavaResourcePersistentAttribute> stream = this.persistableAttributes();
        while (stream.hasNext()) {
            if (!stream.next().isAnnotated()) continue;
            return true;
        }
        return false;
    }

    public IType getMember() {
        return (IType)super.getMember();
    }

    @Override
    public Iterator<JavaResourcePersistentAttribute> fields() {
        return this.getFields().iterator();
    }

    private Iterable<JavaResourcePersistentAttribute> getFields() {
        return new LiveCloneIterable(this.fields);
    }

    @Override
    public Iterator<JavaResourcePersistentAttribute> persistableFields() {
        return this.persistableMembers(this.fields());
    }

    @Override
    public Iterator<JavaResourcePersistentAttribute> persistableFieldsWithSpecifiedFieldAccess() {
        return new FilteringIterator(this.persistableFields(), FIELD_ACCESS_TYPE_FILTER);
    }

    private void addField(JavaResourcePersistentAttribute field) {
        this.addItemToCollection(field, this.fields, "fields");
    }

    private JavaResourcePersistentAttribute getField(String fieldName, int occurrence) {
        for (JavaResourcePersistentAttribute field : this.getFields()) {
            if (!field.isFor(fieldName, occurrence)) continue;
            return field;
        }
        return null;
    }

    private void removeFields(Collection<JavaResourcePersistentAttribute> remove) {
        this.removeItemsFromCollection(remove, this.fields, "fields");
    }

    private Vector<JavaResourcePersistentAttribute> buildFields() {
        IField[] jdtFields = this.getFields(this.getMember());
        Vector<JavaResourcePersistentAttribute> result = new Vector<JavaResourcePersistentAttribute>(jdtFields.length);
        IField[] iFieldArray = jdtFields;
        int n = jdtFields.length;
        int n2 = 0;
        while (n2 < n) {
            IField jdtField = iFieldArray[n2];
            result.add(this.buildField(jdtField));
            ++n2;
        }
        return result;
    }

    private IField[] getFields(IType type) {
        try {
            return type.getFields();
        }
        catch (JavaModelException ex) {
            JptJpaCorePlugin.log(ex);
            return EMPTY_FIELD_ARRAY;
        }
    }

    private JavaResourcePersistentAttribute buildField(IField jdtField) {
        return new BinaryPersistentAttribute((JavaResourcePersistentType)this, jdtField);
    }

    @Override
    public Iterator<JavaResourcePersistentAttribute> methods() {
        return this.getMethods().iterator();
    }

    private Iterable<JavaResourcePersistentAttribute> getMethods() {
        return new LiveCloneIterable(this.methods);
    }

    @Override
    public Iterator<JavaResourcePersistentAttribute> persistableProperties() {
        return this.persistableMembers(this.methods());
    }

    @Override
    public Iterator<JavaResourcePersistentAttribute> persistablePropertiesWithSpecifiedPropertyAccess() {
        return new FilteringIterator(this.persistableProperties(), PROPERTY_ACCESS_TYPE_FILTER);
    }

    private JavaResourcePersistentAttribute getMethod(MethodSignature signature, int occurrence) {
        for (JavaResourcePersistentAttribute method : this.getMethods()) {
            if (!method.isFor(signature, occurrence)) continue;
            return method;
        }
        return null;
    }

    private void addMethod(JavaResourcePersistentAttribute method) {
        this.addItemToCollection(method, this.methods, "methods");
    }

    private void removeMethods(Collection<JavaResourcePersistentAttribute> remove) {
        this.removeItemsFromCollection(remove, this.methods, "methods");
    }

    private Vector<JavaResourcePersistentAttribute> buildMethods() {
        IMethod[] jdtMethods = this.getMethods(this.getMember());
        Vector<JavaResourcePersistentAttribute> result = new Vector<JavaResourcePersistentAttribute>(jdtMethods.length);
        IMethod[] iMethodArray = jdtMethods;
        int n = jdtMethods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod jdtMethod = iMethodArray[n2];
            result.add(this.buildMethod(jdtMethod));
            ++n2;
        }
        return result;
    }

    private IMethod[] getMethods(IType type) {
        try {
            return type.getMethods();
        }
        catch (JavaModelException ex) {
            JptJpaCorePlugin.log(ex);
            return EMPTY_METHOD_ARRAY;
        }
    }

    private JavaResourcePersistentAttribute buildMethod(IMethod jdtMethod) {
        return new BinaryPersistentAttribute((JavaResourcePersistentType)this, jdtMethod);
    }

    @Override
    public Iterator<JavaResourcePersistentAttribute> persistableAttributes() {
        return new CompositeIterator(new Iterator[]{this.persistableFields(), this.persistableProperties()});
    }

    @Override
    public Iterator<JavaResourcePersistentAttribute> persistableAttributes(AccessType specifiedAccess) {
        switch (specifiedAccess) {
            case FIELD: {
                return this.persistableAttributesForFieldAccessType();
            }
            case PROPERTY: {
                return this.persistableAttributesForPropertyAccessType();
            }
        }
        throw new IllegalArgumentException("unknown access: " + (Object)((Object)specifiedAccess));
    }

    private Iterator<JavaResourcePersistentAttribute> persistableAttributesForFieldAccessType() {
        return new CompositeIterator(new Iterator[]{this.persistableFields(), this.persistablePropertiesWithSpecifiedPropertyAccess()});
    }

    private Iterator<JavaResourcePersistentAttribute> persistableAttributesForPropertyAccessType() {
        return new CompositeIterator(new Iterator[]{this.persistableProperties(), this.persistableFieldsWithSpecifiedFieldAccess()});
    }

    static boolean typeIsPersistable(IType type) {
        return type != null && type.exists() && JPTTools.typeIsPersistable((JPTTools.TypeAdapter)new JPTToolsAdapter(type));
    }

    @Override
    public Iterator<JavaResourcePersistentType> types() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<JavaResourcePersistentType> allTypes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<JavaResourcePersistentType> persistableTypes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isGeneratedMetamodelTopLevelType(IPackageFragmentRoot sourceFolder) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isGeneratedMetamodelTopLevelType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isMetamodel() {
        throw new UnsupportedOperationException();
    }

    @Override
    public GeneratedAnnotation getGeneratedAnnotation() {
        throw new UnsupportedOperationException();
    }

    static class JPTToolsAdapter
    implements JPTTools.TypeAdapter {
        private final IType type;

        protected JPTToolsAdapter(IType type) {
            if (type == null) {
                throw new NullPointerException();
            }
            this.type = type;
        }

        public int getModifiers() {
            try {
                return this.type.getFlags();
            }
            catch (JavaModelException ex) {
                JptJpaCorePlugin.log(ex);
                return 0;
            }
        }

        public boolean isAnnotation() {
            try {
                return this.type.isAnnotation();
            }
            catch (JavaModelException ex) {
                JptJpaCorePlugin.log(ex);
                return false;
            }
        }

        public boolean isAnonymous() {
            try {
                return this.type.isAnonymous();
            }
            catch (JavaModelException ex) {
                JptJpaCorePlugin.log(ex);
                return false;
            }
        }

        public boolean isArray() {
            return false;
        }

        public boolean isEnum() {
            try {
                return this.type.isEnum();
            }
            catch (JavaModelException ex) {
                JptJpaCorePlugin.log(ex);
                return false;
            }
        }

        public boolean isInterface() {
            try {
                return this.type.isInterface();
            }
            catch (JavaModelException ex) {
                JptJpaCorePlugin.log(ex);
                return false;
            }
        }

        public boolean isLocal() {
            try {
                return this.type.isLocal();
            }
            catch (JavaModelException ex) {
                JptJpaCorePlugin.log(ex);
                return false;
            }
        }

        public boolean isMember() {
            try {
                return this.type.isMember();
            }
            catch (JavaModelException ex) {
                JptJpaCorePlugin.log(ex);
                return false;
            }
        }

        public boolean isPrimitive() {
            return false;
        }
    }

    static class TypeAdapter
    implements BinaryPersistentMember.Adapter {
        private final IType type;

        TypeAdapter(IType type) {
            this.type = type;
        }

        public IType getElement() {
            return this.type;
        }

        public boolean isPersistable() {
            return true;
        }

        public IAnnotation[] getAnnotations() throws JavaModelException {
            return this.type.getAnnotations();
        }
    }
}

