/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa1.context.java;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.Filter;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterables.CompositeListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.FilteringIterable;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SubIterableWrapper;
import org.eclipse.jpt.common.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.common.utility.internal.iterators.FilteringIterator;
import org.eclipse.jpt.jpa.core.context.BaseColumn;
import org.eclipse.jpt.jpa.core.context.JpaContextNode;
import org.eclipse.jpt.jpa.core.context.Override_;
import org.eclipse.jpt.jpa.core.context.TypeMapping;
import org.eclipse.jpt.jpa.core.context.VirtualOverride;
import org.eclipse.jpt.jpa.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.jpa.core.context.java.JavaOverride;
import org.eclipse.jpt.jpa.core.context.java.JavaOverrideContainer;
import org.eclipse.jpt.jpa.core.context.java.JavaReadOnlyOverride;
import org.eclipse.jpt.jpa.core.context.java.JavaVirtualOverride;
import org.eclipse.jpt.jpa.core.internal.context.BaseColumnTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.context.ContextContainerTools;
import org.eclipse.jpt.jpa.core.internal.context.JptValidator;
import org.eclipse.jpt.jpa.core.internal.context.OverrideTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.jpa.core.resource.java.Annotation;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.jpa.core.resource.java.NestableAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.OverrideAnnotation;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaOverrideContainer<O extends JavaOverrideContainer.Owner, R extends JavaReadOnlyOverride, S extends JavaOverride, V extends JavaVirtualOverride, A extends OverrideAnnotation & NestableAnnotation>
extends AbstractJavaJpaContextNode
implements JavaOverrideContainer {
    protected final O owner;
    protected final Vector<S> specifiedOverrides = new Vector();
    protected final SpecifiedOverrideContainerAdapter specifiedOverrideContainerAdapter = new SpecifiedOverrideContainerAdapter();
    protected final Vector<V> virtualOverrides = new Vector();
    protected final VirtualOverrideContainerAdapter virtualOverrideContainerAdapter = new VirtualOverrideContainerAdapter();

    protected AbstractJavaOverrideContainer(JavaJpaContextNode parent, O owner) {
        super(parent);
        this.owner = owner;
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.synchronizeNodesWithResourceModel((Iterable<? extends JpaContextNode>)this.getSpecifiedOverrides());
    }

    @Override
    public void update() {
        super.update();
        this.updateSpecifiedOverrides();
        this.updateVirtualOverrides();
    }

    public ListIterator<R> overrides() {
        return this.getOverrides().iterator();
    }

    protected ListIterable<R> getOverrides() {
        return new CompositeListIterable(new ListIterable[]{this.getReadOnlySpecifiedOverrides(), this.getReadOnlyVirtualOverrides()});
    }

    @Override
    public int overridesSize() {
        return this.specifiedOverrides.size() + this.virtualOverrides.size();
    }

    public R getOverrideNamed(String name) {
        return this.selectOverrideNamed((Iterable<R>)this.getOverrides(), name);
    }

    public V convertOverrideToVirtual(Override_ override) {
        if (override.isVirtual()) {
            throw new IllegalArgumentException("Override is already virtual: " + override);
        }
        JavaOverride specifiedOverride = (JavaOverride)override;
        int virtualIndex = this.virtualOverrides.size();
        String overrideName = specifiedOverride.getName();
        Object virtualOverride = null;
        if (this.overrideWillBeVirtual(overrideName, specifiedOverride)) {
            virtualOverride = this.buildVirtualOverride(overrideName);
            this.virtualOverrides.add(virtualIndex, virtualOverride);
        }
        this.removeSpecifiedOverride(specifiedOverride);
        if (virtualOverride != null) {
            this.fireItemAdded("virtualOverrides", virtualIndex, virtualOverride);
        }
        return (V)virtualOverride;
    }

    protected boolean overrideWillBeVirtual(String overrideName, S specifiedOverrideToBeRemoved) {
        return CollectionTools.contains(this.allOverridableNames(), (Object)overrideName) && this.getSpecifiedOverrideNamed(overrideName, specifiedOverrideToBeRemoved) == null;
    }

    public S convertOverrideToSpecified(VirtualOverride override) {
        if (!override.isVirtual()) {
            throw new IllegalArgumentException("Override is already specified: " + override);
        }
        JavaVirtualOverride virtualOverride = (JavaVirtualOverride)override;
        int virtualIndex = this.virtualOverrides.indexOf(virtualOverride);
        this.virtualOverrides.remove(virtualIndex);
        int specifiedIndex = this.specifiedOverrides.size();
        S specifiedOverride = this.buildSpecifiedOverride(this.buildOverrideAnnotation(specifiedIndex));
        this.specifiedOverrides.add(specifiedIndex, specifiedOverride);
        this.initializeSpecifiedOverride(specifiedOverride, virtualOverride);
        this.fireItemRemoved("virtualOverrides", virtualIndex, virtualOverride);
        this.fireItemAdded("specifiedOverrides", specifiedIndex, specifiedOverride);
        return specifiedOverride;
    }

    protected abstract void initializeSpecifiedOverride(S var1, V var2);

    public ListIterator<S> specifiedOverrides() {
        return this.getSpecifiedOverrides().iterator();
    }

    protected ListIterable<S> getSpecifiedOverrides() {
        return new LiveCloneListIterable(this.specifiedOverrides);
    }

    protected ListIterable<R> getReadOnlySpecifiedOverrides() {
        return this.getSpecifiedOverrides();
    }

    @Override
    public int specifiedOverridesSize() {
        return this.specifiedOverrides.size();
    }

    public S getSpecifiedOverride(int index) {
        return (S)((JavaOverride)this.specifiedOverrides.get(index));
    }

    public S getSpecifiedOverrideNamed(String name) {
        return this.getSpecifiedOverrideNamed(name, null);
    }

    protected S getSpecifiedOverrideNamed(String name, S exclude) {
        return (S)((JavaOverride)this.selectOverrideNamed((Iterable<R>)this.getReadOnlySpecifiedOverrides(), name, exclude));
    }

    protected S addSpecifiedOverride() {
        return this.addSpecifiedOverride(this.specifiedOverrides.size());
    }

    protected S addSpecifiedOverride(int index) {
        A annotation = this.buildOverrideAnnotation(index);
        return this.addSpecifiedOverride_(index, annotation);
    }

    protected A buildOverrideAnnotation(int index) {
        int annotationIndex = this.calculateNewAnnotationIndex(index);
        return (A)((OverrideAnnotation)((Object)this.getResourcePersistentMember().addAnnotation(annotationIndex, this.getOverrideAnnotationName(), this.getOverrideContainerAnnotationName())));
    }

    protected int calculateNewAnnotationIndex(int index) {
        if (index == this.specifiedOverrides.size()) {
            return CollectionTools.size(this.getOverrideAnnotations());
        }
        if (index == 0) {
            return 0;
        }
        return this.translateToAnnotationIndex(index - 1) + 1;
    }

    protected int translateToAnnotationIndex(int index) {
        return CollectionTools.indexOf(this.getOverrideAnnotations(), (Object)((JavaOverride)this.specifiedOverrides.get(index)).getOverrideAnnotation());
    }

    protected abstract String getOverrideAnnotationName();

    protected abstract String getOverrideContainerAnnotationName();

    protected void removeSpecifiedOverride(S override) {
        this.removeSpecifiedOverride(this.specifiedOverrides.indexOf(override));
    }

    protected void removeSpecifiedOverride(int index) {
        this.removeOverrideAnnotation(index);
        this.removeSpecifiedOverride_(index);
    }

    protected void removeOverrideAnnotation(int index) {
        int annotationIndex = this.translateToAnnotationIndex(index);
        this.getResourcePersistentMember().removeAnnotation(annotationIndex, this.getOverrideAnnotationName(), this.getOverrideContainerAnnotationName());
    }

    protected void removeSpecifiedOverride_(int index) {
        this.removeItemFromList(index, this.specifiedOverrides, "specifiedOverrides");
    }

    @Override
    public void moveSpecifiedOverride(int targetIndex, int sourceIndex) {
        this.moveOverrideAnnotation(targetIndex, sourceIndex);
        this.moveItemInList(targetIndex, sourceIndex, this.specifiedOverrides, "specifiedOverrides");
    }

    protected void moveOverrideAnnotation(int targetIndex, int sourceIndex) {
        int targetAnnotationIndex = this.translateToAnnotationIndex(targetIndex);
        int sourceAnnotationIndex = this.translateToAnnotationIndex(sourceIndex);
        this.getResourcePersistentMember().moveAnnotation(targetAnnotationIndex, sourceAnnotationIndex, this.getOverrideContainerAnnotationName());
    }

    protected abstract S buildSpecifiedOverride(A var1);

    protected void updateSpecifiedOverrides() {
        ContextContainerTools.update(this.specifiedOverrideContainerAdapter);
    }

    protected Iterable<A> getRelevantOverrideAnnotations() {
        return new FilteringIterable<A>(this.getOverrideAnnotations()){

            protected boolean accept(A annotation) {
                String overrideName = annotation.getName();
                return overrideName != null && AbstractJavaOverrideContainer.this.owner.isRelevant(overrideName);
            }
        };
    }

    protected Iterable<A> getOverrideAnnotations() {
        return new SubIterableWrapper(CollectionTools.iterable(this.overrideAnnotations()));
    }

    protected Iterator<NestableAnnotation> overrideAnnotations() {
        return this.owner == null ? EmptyIterator.instance() : this.overrideAnnotations_();
    }

    protected Iterator<NestableAnnotation> overrideAnnotations_() {
        return this.getResourcePersistentMember().annotations(this.getOverrideAnnotationName(), this.getOverrideContainerAnnotationName());
    }

    protected void moveSpecifiedOverride_(int index, S override) {
        this.moveItemInList(index, override, this.specifiedOverrides, "specifiedOverrides");
    }

    protected S addSpecifiedOverride_(int index, A overrideAnnotation) {
        S override = this.buildSpecifiedOverride(overrideAnnotation);
        this.addItemToList(index, override, this.specifiedOverrides, "specifiedOverrides");
        return override;
    }

    protected void removeSpecifiedOverride_(S override) {
        this.removeSpecifiedOverride_(this.specifiedOverrides.indexOf(override));
    }

    public ListIterator<V> virtualOverrides() {
        return this.getVirtualOverrides().iterator();
    }

    protected ListIterable<V> getVirtualOverrides() {
        return new LiveCloneListIterable(this.virtualOverrides);
    }

    @Override
    public int virtualOverridesSize() {
        return this.virtualOverrides.size();
    }

    protected ListIterable<R> getReadOnlyVirtualOverrides() {
        return this.getVirtualOverrides();
    }

    protected void updateVirtualOverrides() {
        ContextContainerTools.update(this.virtualOverrideContainerAdapter);
    }

    protected Iterable<String> getVirtualOverrideNames() {
        return CollectionTools.iterable(this.virtualOverrideNames());
    }

    protected Iterator<String> virtualOverrideNames() {
        return new FilteringIterator<String>(this.allOverridableNames()){

            protected boolean accept(String name) {
                return AbstractJavaOverrideContainer.this.overrideIsVirtual(name);
            }
        };
    }

    protected boolean overrideIsVirtual(String name) {
        return this.getSpecifiedOverrideNamed(name) == null;
    }

    protected void moveVirtualOverride(int index, V override) {
        this.moveItemInList(index, override, this.virtualOverrides, "virtualOverrides");
    }

    protected V addVirtualOverride(int index, String name) {
        V override = this.buildVirtualOverride(name);
        this.addItemToList(index, override, this.virtualOverrides, "virtualOverrides");
        return override;
    }

    protected abstract V buildVirtualOverride(String var1);

    protected void removeVirtualOverride(V override) {
        this.removeItemFromList(override, this.virtualOverrides, "virtualOverrides");
    }

    @Override
    public TypeMapping getTypeMapping() {
        return this.owner.getTypeMapping();
    }

    protected JavaResourcePersistentMember getResourcePersistentMember() {
        return this.owner.getResourcePersistentMember();
    }

    @Override
    public TypeMapping getOverridableTypeMapping() {
        return this.owner.getOverridableTypeMapping();
    }

    @Override
    public Iterator<String> allOverridableNames() {
        return this.owner != null ? this.owner.allOverridableNames() : EmptyIterator.instance();
    }

    @Override
    public boolean tableNameIsInvalid(String tableName) {
        return this.owner.tableNameIsInvalid(tableName);
    }

    @Override
    public Iterator<String> candidateTableNames() {
        return this.owner.candidateTableNames();
    }

    @Override
    public Table resolveDbTable(String tableName) {
        return this.owner.resolveDbTable(tableName);
    }

    @Override
    public String getDefaultTableName() {
        return this.owner.getDefaultTableName();
    }

    @Override
    public JptValidator buildValidator(Override_ override, OverrideTextRangeResolver textRangeResolver) {
        return this.owner.buildValidator(override, this, textRangeResolver);
    }

    @Override
    public JptValidator buildColumnValidator(Override_ override, BaseColumn column, BaseColumn.Owner columnOwner, BaseColumnTextRangeResolver textRangeResolver) {
        return this.owner.buildColumnValidator(override, column, columnOwner, textRangeResolver);
    }

    @Override
    public String getPossiblePrefix() {
        return this.owner.getPossiblePrefix();
    }

    @Override
    public String getWritePrefix() {
        return this.owner.getWritePrefix();
    }

    protected R selectOverrideNamed(Iterable<R> overrides, String name) {
        return this.selectOverrideNamed(overrides, name, null);
    }

    protected R selectOverrideNamed(Iterable<R> overrides, String name, S exclude) {
        for (JavaReadOnlyOverride override : overrides) {
            if (override == exclude || !this.valuesAreEqual(override.getName(), name)) continue;
            return (R)override;
        }
        return null;
    }

    @Override
    public Iterator<String> javaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator result = super.javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        for (JavaReadOnlyOverride override : this.getOverrides()) {
            result = override.javaCompletionProposals(pos, filter, astRoot);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        for (JavaReadOnlyOverride override : this.getOverrides()) {
            override.validate(messages, reporter, astRoot);
        }
    }

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        TextRange textRange = this.getValidationAnnotationTextRange(astRoot);
        return textRange != null ? textRange : this.owner.getValidationTextRange(astRoot);
    }

    protected TextRange getValidationAnnotationTextRange(CompilationUnit astRoot) {
        Annotation annotation = this.getValidationAnnotation();
        return annotation == null ? null : annotation.getTextRange(astRoot);
    }

    protected Annotation getValidationAnnotation() {
        JavaResourcePersistentMember resourceMember = this.getResourcePersistentMember();
        Annotation annotation = resourceMember.getAnnotation(this.getOverrideContainerAnnotationName());
        return annotation != null ? annotation : resourceMember.getAnnotation(this.getOverrideAnnotationName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SpecifiedOverrideContainerAdapter
    implements ContextContainerTools.Adapter<S, A> {
        protected SpecifiedOverrideContainerAdapter() {
        }

        @Override
        public Iterable<S> getContextElements() {
            return AbstractJavaOverrideContainer.this.getSpecifiedOverrides();
        }

        @Override
        public Iterable<A> getResourceElements() {
            return AbstractJavaOverrideContainer.this.getRelevantOverrideAnnotations();
        }

        @Override
        public A getResourceElement(S contextElement) {
            return contextElement.getOverrideAnnotation();
        }

        @Override
        public void moveContextElement(int index, S element) {
            AbstractJavaOverrideContainer.this.moveSpecifiedOverride_(index, element);
        }

        @Override
        public void addContextElement(int index, A resourceElement) {
            AbstractJavaOverrideContainer.this.addSpecifiedOverride_(index, resourceElement);
        }

        @Override
        public void removeContextElement(S element) {
            AbstractJavaOverrideContainer.this.removeSpecifiedOverride_(element);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class VirtualOverrideContainerAdapter
    implements ContextContainerTools.Adapter<V, String> {
        protected VirtualOverrideContainerAdapter() {
        }

        @Override
        public Iterable<V> getContextElements() {
            return AbstractJavaOverrideContainer.this.getVirtualOverrides();
        }

        @Override
        public Iterable<String> getResourceElements() {
            return AbstractJavaOverrideContainer.this.getVirtualOverrideNames();
        }

        @Override
        public String getResourceElement(V contextElement) {
            return contextElement.getName();
        }

        @Override
        public void moveContextElement(int index, V element) {
            AbstractJavaOverrideContainer.this.moveVirtualOverride(index, element);
        }

        @Override
        public void addContextElement(int index, String resourceElement) {
            AbstractJavaOverrideContainer.this.addVirtualOverride(index, resourceElement);
        }

        @Override
        public void removeContextElement(V element) {
            AbstractJavaOverrideContainer.this.removeVirtualOverride(element);
        }
    }
}

