/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.orm;

import java.util.List;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.jpa.core.JpaStructureNode;
import org.eclipse.jpt.jpa.core.context.AccessType;
import org.eclipse.jpt.jpa.core.context.CollectionMapping;
import org.eclipse.jpt.jpa.core.context.ReadOnlyPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmAttributeMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmAttributeMappingDefinition;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmReadOnlyPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmTypeMapping;
import org.eclipse.jpt.jpa.core.internal.context.JptValidator;
import org.eclipse.jpt.jpa.core.internal.context.PersistentAttributeTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmXmlContextNode;
import org.eclipse.jpt.jpa.core.internal.context.orm.OrmPersistentAttributeTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.jpa.core.jpa2.context.MetamodelField;
import org.eclipse.jpt.jpa.core.jpa2.context.java.JavaPersistentAttribute2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.orm.OrmPersistentAttribute2_0;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.jpa.core.resource.orm.XmlAttributeMapping;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SpecifiedOrmPersistentAttribute
extends AbstractOrmXmlContextNode
implements OrmPersistentAttribute2_0 {
    protected OrmAttributeMapping mapping;
    protected JavaPersistentAttribute javaPersistentAttribute;
    protected JavaPersistentAttribute cachedJavaPersistentAttribute;
    protected AccessType defaultAccess;

    protected SpecifiedOrmPersistentAttribute(OrmPersistentType parent, XmlAttributeMapping xmlMapping) {
        super(parent);
        this.mapping = this.buildMapping(xmlMapping);
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.mapping.synchronizeWithResourceModel();
        if (this.cachedJavaPersistentAttribute != null) {
            this.cachedJavaPersistentAttribute.synchronizeWithResourceModel();
        }
    }

    @Override
    public void update() {
        super.update();
        this.setDefaultAccess(this.buildDefaultAccess());
        this.setJavaPersistentAttribute(this.buildJavaPersistentAttribute());
        this.mapping.update();
        if (this.cachedJavaPersistentAttribute != null) {
            this.cachedJavaPersistentAttribute.update();
        }
    }

    @Override
    public OrmAttributeMapping getMapping() {
        return this.mapping;
    }

    @Override
    public String getMappingKey() {
        return this.mapping.getKey();
    }

    @Override
    public OrmAttributeMapping setMappingKey(String mappingKey) {
        if (this.valuesAreDifferent(this.getMappingKey(), mappingKey)) {
            this.setMappingKey_(mappingKey);
        }
        return this.mapping;
    }

    protected void setMappingKey_(String mappingKey) {
        OrmAttributeMappingDefinition mappingDefinition = this.getMappingFileDefinition().getAttributeMappingDefinition(mappingKey);
        XmlAttributeMapping xmlAttributeMapping = mappingDefinition.buildResourceMapping(this.getResourceNodeFactory());
        this.setMapping(this.buildMapping(xmlAttributeMapping));
    }

    protected final OrmAttributeMapping buildMapping(XmlAttributeMapping xmlAttributeMapping) {
        OrmAttributeMappingDefinition md = this.getMappingFileDefinition().getAttributeMappingDefinition(xmlAttributeMapping.getMappingKey());
        return md.buildContextMapping(this, xmlAttributeMapping, this.getContextNodeFactory());
    }

    protected void setMapping(OrmAttributeMapping mapping) {
        OrmAttributeMapping old = this.mapping;
        this.mapping = mapping;
        this.firePropertyChanged("mapping", old, mapping);
        this.getOwningPersistentType().changeMapping(this, old, mapping);
    }

    @Override
    public String getDefaultMappingKey() {
        return null;
    }

    protected XmlAttributeMapping getXmlAttributeMapping() {
        return this.mapping.getXmlAttributeMapping();
    }

    @Override
    public String getName() {
        return this.mapping.getName();
    }

    @Override
    public void nameChanged(String oldName, String newName) {
        this.firePropertyChanged("name", oldName, newName);
    }

    @Override
    public JavaPersistentAttribute getJavaPersistentAttribute() {
        return this.javaPersistentAttribute;
    }

    @Override
    public JavaPersistentAttribute resolveJavaPersistentAttribute() {
        return this.getJavaPersistentAttribute();
    }

    protected void setJavaPersistentAttribute(JavaPersistentAttribute javaPersistentAttribute) {
        JavaPersistentAttribute old = this.javaPersistentAttribute;
        this.javaPersistentAttribute = javaPersistentAttribute;
        this.firePropertyChanged("javaPersistentAttribute", old, javaPersistentAttribute);
    }

    protected JavaPersistentAttribute buildJavaPersistentAttribute() {
        JavaPersistentAttribute javaAttribute;
        String name = this.getName();
        if (name == null) {
            return null;
        }
        JavaPersistentType javaType = this.getOwningPersistentTypeJavaType();
        if (javaType == null) {
            return null;
        }
        ReadOnlyPersistentAttribute pAttribute = javaType.resolveAttribute(name);
        JavaPersistentAttribute javaPersistentAttribute = javaAttribute = pAttribute == null ? null : pAttribute.getJavaPersistentAttribute();
        if (javaAttribute != null && javaAttribute.getAccess() == this.getAccess()) {
            this.cachedJavaPersistentAttribute = null;
            return javaAttribute;
        }
        return this.getCachedJavaAttribute();
    }

    protected JavaPersistentAttribute getCachedJavaAttribute() {
        JavaResourcePersistentType javaResourceType = this.getOwningPersistentTypeJavaType().getResourcePersistentType();
        JavaResourcePersistentAttribute javaResourceAttribute = this.getJavaResourceAttribute(javaResourceType);
        if (javaResourceAttribute == null) {
            this.cachedJavaPersistentAttribute = null;
        } else if (this.cachedJavaPersistentAttribute == null || this.cachedJavaPersistentAttribute.getResourcePersistentAttribute() != javaResourceAttribute) {
            this.cachedJavaPersistentAttribute = this.buildJavaPersistentAttribute(javaResourceAttribute);
        }
        return this.cachedJavaPersistentAttribute;
    }

    protected JavaResourcePersistentAttribute getJavaResourceAttribute(JavaResourcePersistentType javaResourceType) {
        for (JavaResourcePersistentAttribute javaResourceAttribute : this.getJavaResourceAttributes(javaResourceType)) {
            if (!javaResourceAttribute.getName().equals(this.getName())) continue;
            return javaResourceAttribute;
        }
        String superclassName = javaResourceType.getSuperclassQualifiedName();
        if (superclassName == null) {
            return null;
        }
        JavaResourcePersistentType superclass = this.getJpaProject().getJavaResourcePersistentType(superclassName);
        if (superclass == null) {
            return null;
        }
        return this.getJavaResourceAttribute(superclass);
    }

    protected Iterable<JavaResourcePersistentAttribute> getJavaResourceAttributes(JavaResourcePersistentType javaResourceType) {
        return CollectionTools.iterable(javaResourceType.persistableAttributes(this.getAccess().getJavaAccessType()));
    }

    protected JavaPersistentAttribute buildJavaPersistentAttribute(JavaResourcePersistentAttribute javaResourceAttribute) {
        return this.getJpaFactory().buildJavaPersistentAttribute(this.getOwningPersistentType(), javaResourceAttribute);
    }

    @Override
    public JavaResourcePersistentAttribute getJavaResourcePersistentAttribute() {
        return this.javaPersistentAttribute == null ? null : this.javaPersistentAttribute.getResourcePersistentAttribute();
    }

    @Override
    public AccessType getAccess() {
        AccessType specifiedAccess = this.getSpecifiedAccess();
        return specifiedAccess != null ? specifiedAccess : this.defaultAccess;
    }

    @Override
    public abstract AccessType getSpecifiedAccess();

    @Override
    public AccessType getDefaultAccess() {
        return this.defaultAccess;
    }

    protected void setDefaultAccess(AccessType access) {
        AccessType old = this.defaultAccess;
        this.defaultAccess = access;
        this.firePropertyChanged("defaultAccess", (Object)old, (Object)access);
    }

    protected AccessType buildDefaultAccess() {
        return this.getOwningPersistentType().getAccess();
    }

    @Override
    public boolean isVirtual() {
        return false;
    }

    @Override
    public OrmReadOnlyPersistentAttribute convertToVirtual() {
        return this.getOwningPersistentType().convertAttributeToVirtual(this);
    }

    @Override
    public OrmPersistentAttribute convertToSpecified() {
        throw new UnsupportedOperationException();
    }

    @Override
    public OrmPersistentAttribute convertToSpecified(String mappingKey) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getId() {
        return "org.eclipse.jpt.jpa.core.orm.persistentAttribute";
    }

    @Override
    public JpaStructureNode getStructureNode(int offset) {
        return this;
    }

    @Override
    public boolean contains(int textOffset) {
        return this.mapping.contains(textOffset);
    }

    @Override
    public TextRange getSelectionTextRange() {
        return this.mapping.getSelectionTextRange();
    }

    @Override
    public void dispose() {
    }

    @Override
    public Iterable<ReplaceEdit> createRenameTypeEdits(IType originalType, String newName) {
        return this.mapping.createRenameTypeEdits(originalType, newName);
    }

    @Override
    public Iterable<ReplaceEdit> createMoveTypeEdits(IType originalType, IPackageFragment newPackage) {
        return this.mapping.createMoveTypeEdits(originalType, newPackage);
    }

    @Override
    public Iterable<ReplaceEdit> createRenamePackageEdits(IPackageFragment originalPackage, String newName) {
        return this.mapping.createRenamePackageEdits(originalPackage, newName);
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateAttribute(messages, reporter);
        this.mapping.validate(messages, reporter);
    }

    protected void validateAttribute(List<IMessage> messages, IReporter reporter) {
        if (this.javaPersistentAttribute == null) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "PERSISTENT_ATTRIBUTE_UNRESOLVED_NAME", new String[]{this.getName(), this.getOwningTypeMapping().getClass_()}, this.mapping, this.mapping.getNameTextRange()));
        } else {
            this.buildAttibuteValidator().validate(messages, reporter);
        }
    }

    protected PersistentAttributeTextRangeResolver buildTextRangeResolver() {
        return new OrmPersistentAttributeTextRangeResolver(this);
    }

    protected abstract JptValidator buildAttibuteValidator();

    @Override
    public TextRange getValidationTextRange() {
        return this.mapping.getValidationTextRange();
    }

    @Override
    public String getMetamodelContainerFieldTypeName() {
        return this.getJpaContainerDefinition().getMetamodelContainerFieldTypeName();
    }

    @Override
    public String getMetamodelContainerFieldMapKeyTypeName() {
        return this.getJpaContainerDefinition().getMetamodelContainerFieldMapKeyTypeName((CollectionMapping)((Object)this.mapping));
    }

    @Override
    public String getMetamodelTypeName() {
        JavaPersistentAttribute2_0 javaAttribute = (JavaPersistentAttribute2_0)this.javaPersistentAttribute;
        return javaAttribute != null ? javaAttribute.getMetamodelTypeName() : MetamodelField.DEFAULT_TYPE_NAME;
    }

    protected JavaPersistentAttribute.JpaContainerDefinition getJpaContainerDefinition() {
        JavaPersistentAttribute2_0 javaAttribute = (JavaPersistentAttribute2_0)this.javaPersistentAttribute;
        return javaAttribute != null ? javaAttribute.getJpaContainerDefinition() : JavaPersistentAttribute.JpaContainerDefinition.Null.instance();
    }

    @Override
    public OrmPersistentType getParent() {
        return (OrmPersistentType)super.getParent();
    }

    @Override
    public OrmPersistentType getOwningPersistentType() {
        return this.getParent();
    }

    protected JavaPersistentType getOwningPersistentTypeJavaType() {
        return this.getOwningPersistentType().getJavaPersistentType();
    }

    @Override
    public OrmTypeMapping getOwningTypeMapping() {
        return this.getOwningPersistentType().getMapping();
    }

    @Override
    public String getPrimaryKeyColumnName() {
        return this.mapping.getPrimaryKeyColumnName();
    }

    @Override
    public String getTypeName() {
        return this.javaPersistentAttribute == null ? null : this.javaPersistentAttribute.getTypeName();
    }

    public void toString(StringBuilder sb) {
        sb.append(this.getName());
    }
}

