/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.orm;

import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SingleElementListIterable;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.core.context.JoinColumn;
import org.eclipse.jpt.jpa.core.context.JoinTable;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.ReadOnlyBaseJoinColumn;
import org.eclipse.jpt.jpa.core.context.ReadOnlyJoinColumn;
import org.eclipse.jpt.jpa.core.context.RelationshipMapping;
import org.eclipse.jpt.jpa.core.context.TypeMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmVirtualJoinColumn;
import org.eclipse.jpt.jpa.core.context.orm.OrmVirtualJoinTable;
import org.eclipse.jpt.jpa.core.context.orm.OrmVirtualJoinTableRelationshipStrategy;
import org.eclipse.jpt.jpa.core.context.orm.OrmVirtualRelationship;
import org.eclipse.jpt.jpa.core.internal.context.ContextContainerTools;
import org.eclipse.jpt.jpa.core.internal.context.MappingTools;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmVirtualReferenceTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericOrmVirtualJoinTable
extends AbstractOrmVirtualReferenceTable<JoinTable>
implements OrmVirtualJoinTable {
    protected final JoinTable overriddenTable;
    protected final Vector<OrmVirtualJoinColumn> specifiedInverseJoinColumns = new Vector();
    protected final SpecifiedInverseJoinColumnContainerAdapter specifiedInverseJoinColumnContainerAdapter = new SpecifiedInverseJoinColumnContainerAdapter();
    protected final ReadOnlyJoinColumn.Owner inverseJoinColumnOwner;
    protected OrmVirtualJoinColumn defaultInverseJoinColumn;

    public GenericOrmVirtualJoinTable(OrmVirtualJoinTableRelationshipStrategy parent, JoinTable overriddenTable) {
        super(parent);
        this.overriddenTable = overriddenTable;
        this.inverseJoinColumnOwner = this.buildInverseJoinColumnOwner();
    }

    @Override
    public void update() {
        super.update();
        this.updateSpecifiedInverseJoinColumns();
        this.updateDefaultInverseJoinColumn();
    }

    @Override
    public JoinTable getOverriddenTable() {
        return this.overriddenTable;
    }

    @Override
    public ListIterator<OrmVirtualJoinColumn> inverseJoinColumns() {
        return this.getInverseJoinColumns().iterator();
    }

    protected ListIterable<OrmVirtualJoinColumn> getInverseJoinColumns() {
        return this.hasSpecifiedInverseJoinColumns() ? this.getSpecifiedInverseJoinColumns() : this.getDefaultInverseJoinColumns();
    }

    @Override
    public int inverseJoinColumnsSize() {
        return this.hasSpecifiedInverseJoinColumns() ? this.specifiedInverseJoinColumnsSize() : this.getDefaultInverseJoinColumnsSize();
    }

    @Override
    public ListIterator<OrmVirtualJoinColumn> specifiedInverseJoinColumns() {
        return this.getSpecifiedInverseJoinColumns().iterator();
    }

    protected ListIterable<OrmVirtualJoinColumn> getSpecifiedInverseJoinColumns() {
        return new LiveCloneListIterable(this.specifiedInverseJoinColumns);
    }

    @Override
    public int specifiedInverseJoinColumnsSize() {
        return this.specifiedInverseJoinColumns.size();
    }

    @Override
    public boolean hasSpecifiedInverseJoinColumns() {
        return this.specifiedInverseJoinColumns.size() != 0;
    }

    @Override
    public OrmVirtualJoinColumn getSpecifiedInverseJoinColumn(int index) {
        return this.specifiedInverseJoinColumns.get(index);
    }

    protected void updateSpecifiedInverseJoinColumns() {
        ContextContainerTools.update(this.specifiedInverseJoinColumnContainerAdapter);
    }

    protected Iterable<JoinColumn> getOverriddenInverseJoinColumns() {
        return CollectionTools.iterable(this.getOverriddenTable().specifiedInverseJoinColumns());
    }

    protected void moveSpecifiedInverseJoinColumn(int index, OrmVirtualJoinColumn joinColumn) {
        this.moveItemInList(index, joinColumn, this.specifiedInverseJoinColumns, "specifiedInverseJoinColumns");
    }

    protected OrmVirtualJoinColumn addSpecifiedInverseJoinColumn(int index, JoinColumn joinColumn) {
        OrmVirtualJoinColumn virtualJoinColumn = this.buildInverseJoinColumn(joinColumn);
        this.addItemToList(index, virtualJoinColumn, this.specifiedInverseJoinColumns, "specifiedInverseJoinColumns");
        return virtualJoinColumn;
    }

    protected void removeSpecifiedInverseJoinColumn(OrmVirtualJoinColumn joinColumn) {
        this.removeItemFromList(joinColumn, this.specifiedInverseJoinColumns, "specifiedInverseJoinColumns");
    }

    @Override
    public OrmVirtualJoinColumn getDefaultInverseJoinColumn() {
        return this.defaultInverseJoinColumn;
    }

    protected void setDefaultInverseJoinColumn(OrmVirtualJoinColumn joinColumn) {
        OrmVirtualJoinColumn old = this.defaultInverseJoinColumn;
        this.defaultInverseJoinColumn = joinColumn;
        this.firePropertyChanged("defaultInverseJoinColumn", old, joinColumn);
    }

    protected ListIterable<OrmVirtualJoinColumn> getDefaultInverseJoinColumns() {
        return this.defaultInverseJoinColumn != null ? new SingleElementListIterable((Object)this.defaultInverseJoinColumn) : EmptyListIterable.instance();
    }

    protected int getDefaultInverseJoinColumnsSize() {
        return this.defaultInverseJoinColumn == null ? 0 : 1;
    }

    protected void updateDefaultInverseJoinColumn() {
        if (this.buildsDefaultInverseJoinColumn()) {
            if (this.defaultInverseJoinColumn == null) {
                this.setDefaultInverseJoinColumn(this.buildInverseJoinColumn(this.getOverriddenTable().getDefaultInverseJoinColumn()));
            } else {
                this.defaultInverseJoinColumn.update();
            }
        } else {
            this.setDefaultInverseJoinColumn(null);
        }
    }

    protected boolean buildsDefaultInverseJoinColumn() {
        return !this.hasSpecifiedInverseJoinColumns();
    }

    @Override
    public OrmVirtualJoinTableRelationshipStrategy getParent() {
        return (OrmVirtualJoinTableRelationshipStrategy)super.getParent();
    }

    protected OrmVirtualJoinTableRelationshipStrategy getJoinStrategy() {
        return this.getParent();
    }

    @Override
    protected ReadOnlyJoinColumn.Owner buildJoinColumnOwner() {
        return new JoinColumnOwner();
    }

    protected ReadOnlyJoinColumn.Owner buildInverseJoinColumnOwner() {
        return new InverseJoinColumnOwner();
    }

    protected OrmVirtualJoinColumn buildInverseJoinColumn(JoinColumn joinColumn) {
        return this.buildJoinColumn(this.inverseJoinColumnOwner, joinColumn);
    }

    @Override
    protected String buildDefaultName() {
        return this.getJoinStrategy().getJoinTableDefaultName();
    }

    @Override
    public RelationshipMapping getRelationshipMapping() {
        return this.getJoinStrategy().getRelationship().getMapping();
    }

    @Override
    public PersistentAttribute getPersistentAttribute() {
        return this.getRelationshipMapping().getPersistentAttribute();
    }

    protected abstract class AbstractJoinColumnOwner
    implements ReadOnlyJoinColumn.Owner {
        protected AbstractJoinColumnOwner() {
        }

        public TypeMapping getTypeMapping() {
            return this.getRelationship().getTypeMapping();
        }

        public String getDefaultTableName() {
            return GenericOrmVirtualJoinTable.this.getName();
        }

        public String getDefaultColumnName() {
            throw new UnsupportedOperationException();
        }

        protected OrmVirtualRelationship getRelationship() {
            return GenericOrmVirtualJoinTable.this.getJoinStrategy().getRelationship();
        }
    }

    protected class InverseJoinColumnOwner
    extends AbstractJoinColumnOwner {
        protected InverseJoinColumnOwner() {
        }

        public Entity getRelationshipTarget() {
            RelationshipMapping relationshipMapping = GenericOrmVirtualJoinTable.this.getRelationshipMapping();
            return relationshipMapping == null ? null : relationshipMapping.getResolvedTargetEntity();
        }

        public String getAttributeName() {
            RelationshipMapping relationshipMapping = GenericOrmVirtualJoinTable.this.getRelationshipMapping();
            return relationshipMapping == null ? null : relationshipMapping.getName();
        }

        public boolean joinColumnIsDefault(ReadOnlyBaseJoinColumn joinColumn) {
            return GenericOrmVirtualJoinTable.this.defaultInverseJoinColumn == joinColumn;
        }

        public int joinColumnsSize() {
            return GenericOrmVirtualJoinTable.this.inverseJoinColumnsSize();
        }
    }

    protected class JoinColumnOwner
    extends AbstractJoinColumnOwner {
        protected JoinColumnOwner() {
        }

        public Entity getRelationshipTarget() {
            return this.getRelationship().getEntity();
        }

        public String getAttributeName() {
            return MappingTools.getTargetAttributeName(GenericOrmVirtualJoinTable.this.getRelationshipMapping());
        }

        public boolean joinColumnIsDefault(ReadOnlyBaseJoinColumn joinColumn) {
            return GenericOrmVirtualJoinTable.this.defaultJoinColumn == joinColumn;
        }

        public int joinColumnsSize() {
            return GenericOrmVirtualJoinTable.this.joinColumnsSize();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SpecifiedInverseJoinColumnContainerAdapter
    implements ContextContainerTools.Adapter<OrmVirtualJoinColumn, JoinColumn> {
        protected SpecifiedInverseJoinColumnContainerAdapter() {
        }

        @Override
        public Iterable<OrmVirtualJoinColumn> getContextElements() {
            return GenericOrmVirtualJoinTable.this.getSpecifiedInverseJoinColumns();
        }

        @Override
        public Iterable<JoinColumn> getResourceElements() {
            return GenericOrmVirtualJoinTable.this.getOverriddenInverseJoinColumns();
        }

        @Override
        public JoinColumn getResourceElement(OrmVirtualJoinColumn contextElement) {
            return contextElement.getOverriddenColumn();
        }

        @Override
        public void moveContextElement(int index, OrmVirtualJoinColumn element) {
            GenericOrmVirtualJoinTable.this.moveSpecifiedInverseJoinColumn(index, element);
        }

        @Override
        public void addContextElement(int index, JoinColumn element) {
            GenericOrmVirtualJoinTable.this.addSpecifiedInverseJoinColumn(index, element);
        }

        @Override
        public void removeContextElement(OrmVirtualJoinColumn element) {
            GenericOrmVirtualJoinTable.this.removeSpecifiedInverseJoinColumn(element);
        }
    }
}

