/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.commentelement.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.wst.xml.core.internal.Logger;
import org.eclipse.wst.xml.core.internal.commentelement.CommentElementAdapter;
import org.eclipse.wst.xml.core.internal.commentelement.CommentElementHandler;
import org.eclipse.wst.xml.core.internal.commentelement.impl.BasicCommentElementHandler;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CommentElementConfiguration {
    private Map fAttributes = null;
    private boolean fCustom;
    private IConfigurationElement fElement = null;
    private boolean fEmpty;
    private CommentElementHandler fHandler = null;
    private String fID = null;
    private boolean fJSPComment;
    private String[] fPrefix = null;
    private boolean fXMLComment;
    static /* synthetic */ Class class$0;

    CommentElementConfiguration(IConfigurationElement element) {
        this.fElement = element;
        this.fCustom = "handler-custom".equalsIgnoreCase(element.getName());
        this.fillAttributes(element);
        this.fJSPComment = false;
        this.fXMLComment = false;
        String commentType = this.getProperty("commenttype");
        if ("xml".equalsIgnoreCase(commentType)) {
            this.fXMLComment = true;
        } else if ("jsp".equalsIgnoreCase(commentType)) {
            this.fJSPComment = true;
        } else if ("both".equalsIgnoreCase(commentType)) {
            this.fJSPComment = true;
            this.fXMLComment = true;
        }
        String empty = this.getProperty("isempty");
        this.fEmpty = Boolean.valueOf(empty);
    }

    public boolean acceptJSPComment() {
        return this.fJSPComment;
    }

    public boolean acceptXMLComment() {
        return this.fXMLComment;
    }

    public Element createElement(Document document, String data, boolean isJSPTag) {
        IDOMElement element = (IDOMElement)this.getHandler().createElement(document, data, isJSPTag);
        if (element != null) {
            CommentElementAdapter adapter;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.xml.core.internal.commentelement.CommentElementAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((adapter = (CommentElementAdapter)element.getAdapterFor(clazz)) != null) {
                adapter.setConfiguration(this);
            }
        }
        return element;
    }

    private void fillAttributes(IConfigurationElement element) {
        if (this.fAttributes == null) {
            this.fAttributes = new HashMap();
        } else {
            this.fAttributes.clear();
        }
        String[] names = element.getAttributeNames();
        if (names == null) {
            return;
        }
        int length = names.length;
        int i = 0;
        while (i < length) {
            String name = names[i];
            this.fAttributes.put(name.toLowerCase(), element.getAttribute(name));
            ++i;
        }
    }

    public CommentElementHandler getHandler() {
        if (this.fHandler == null) {
            if (this.fElement != null) {
                try {
                    if (this.isCustom()) {
                        this.fHandler = (CommentElementHandler)this.fElement.createExecutableExtension("class");
                    } else {
                        String elementName = this.getProperty("elementname");
                        if (elementName != null) {
                            this.fHandler = new BasicCommentElementHandler(elementName, this.fEmpty);
                        }
                    }
                }
                catch (Exception e) {
                    Logger.logException(e);
                    this.fHandler = null;
                }
            }
            if (this.fHandler == null) {
                this.fHandler = new CommentElementHandler(){

                    public Element createElement(Document document, String data, boolean isJSPTag) {
                        return null;
                    }

                    public String generateEndTagContent(IDOMElement element) {
                        return null;
                    }

                    public String generateStartTagContent(IDOMElement element) {
                        return null;
                    }

                    public boolean isCommentElement(IDOMElement element) {
                        return false;
                    }

                    public boolean isEmpty() {
                        return false;
                    }
                };
            }
        }
        return this.fHandler;
    }

    public String getHandlerID() {
        if (this.fID == null) {
            this.fID = this.getProperty("id");
            if (this.fID == null) {
                if (this.isCustom()) {
                    this.fID = this.getProperty("class");
                } else {
                    StringBuffer buf = new StringBuffer();
                    buf.append(this.fElement.getDeclaringExtension().getNamespace());
                    buf.append('.');
                    buf.append(this.getProperty("elementname"));
                    this.fID = buf.toString();
                }
            }
        }
        return this.fID;
    }

    public String[] getPrefix() {
        if (this.fPrefix == null && this.fElement != null) {
            if (this.isCustom()) {
                IConfigurationElement[] prefixes = this.fElement.getChildren("startwith");
                if (prefixes != null) {
                    ArrayList<String> prefixValues = new ArrayList<String>(prefixes.length);
                    int i = 0;
                    while (i < prefixes.length) {
                        String prefix = prefixes[i].getAttribute("prefix");
                        if (prefix != null) {
                            prefixValues.add(prefix);
                        } else {
                            try {
                                Logger.log(2, "misconfigured comment element in" + this.fElement.getContributor().getName(), new IllegalArgumentException("startwith"));
                            }
                            catch (InvalidRegistryObjectException invalidRegistryObjectException) {}
                        }
                        ++i;
                    }
                    if (!prefixValues.isEmpty()) {
                        this.fPrefix = prefixValues.toArray(new String[prefixValues.size()]);
                    }
                }
            } else {
                String name = this.getProperty("elementname");
                if (name != null) {
                    if (this.isEmpty()) {
                        this.fPrefix = new String[1];
                        this.fPrefix[0] = name;
                    } else {
                        this.fPrefix = new String[2];
                        this.fPrefix[0] = name;
                        this.fPrefix[1] = String.valueOf('/') + name;
                    }
                }
            }
        }
        if (this.fPrefix == null) {
            this.fPrefix = new String[0];
        }
        return this.fPrefix;
    }

    public String getProperty(String name) {
        return this.fAttributes != null ? (String)this.fAttributes.get(name) : null;
    }

    private boolean isCustom() {
        return this.fCustom;
    }

    private boolean isEmpty() {
        return this.fEmpty;
    }

    void setupCommentElement(IDOMElement element) {
        element.setCommentTag(true);
        CommentElementAdapter adapter = new CommentElementAdapter(false, this.fHandler);
        adapter.setConfiguration(this);
        element.addAdapter(adapter);
    }
}

