/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.widgets;

import java.util.Vector;
import org.eclipse.jst.ws.internal.consumption.ui.ConsumptionUIMessages;
import org.eclipse.jst.ws.internal.consumption.ui.wizard.PrivateUDDIRegistryTypeRegistry;
import org.eclipse.jst.ws.internal.ui.uddi.PrivateUDDIRegistryType;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.wst.command.internal.env.ui.widgets.SimpleWidgetDataContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;
import org.eclipse.wst.ws.internal.explorer.LaunchOption;

public class PublishWSWidget
extends SimpleWidgetDataContributor {
    private String INFOPOP_PWPB_PAGE = "org.eclipse.jst.ws.consumption.ui.PWPB0001";
    private String INFOPOP_PWPB_CHECKBOX_WS_LAUNCH = "org.eclipse.jst.ws.consumption.ui.PWPB0002";
    private Button launchUDDICheckbox_;
    private Button launchPrivateUDDICheckbox_;
    private Listener statusListener;
    private Boolean publish;

    public PublishWSWidget(boolean publish) {
        this.publish = new Boolean(publish);
    }

    public WidgetDataEvents addControls(Composite parent, Listener statusListener) {
        this.statusListener = statusListener;
        Listener selListener = new Listener(){

            public void handleEvent(Event event) {
                PublishWSWidget.this.handleSelectionEvent(event);
            }
        };
        parent.setToolTipText(ConsumptionUIMessages.TOOLTIP_PWPB_PAGE);
        IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
        helpSystem.setHelp((Control)parent, this.INFOPOP_PWPB_PAGE);
        this.launchPrivateUDDICheckbox_ = new Button(parent, 32);
        if (this.publish.booleanValue()) {
            this.launchPrivateUDDICheckbox_.setText(ConsumptionUIMessages.BUTTON_WS_PUBLISH_PRIVATE_UDDI);
        } else {
            this.launchPrivateUDDICheckbox_.setText(ConsumptionUIMessages.BUTTON_WS_FIND_PRIVATE_UDDI);
        }
        this.launchPrivateUDDICheckbox_.setToolTipText(ConsumptionUIMessages.TOOLTIP_PWPB_CHECKBOX_WS_LAUNCH);
        this.launchPrivateUDDICheckbox_.addListener(13, selListener);
        helpSystem.setHelp((Control)this.launchPrivateUDDICheckbox_, this.INFOPOP_PWPB_CHECKBOX_WS_LAUNCH);
        this.launchUDDICheckbox_ = new Button(parent, 32);
        if (this.publish.booleanValue()) {
            this.launchUDDICheckbox_.setText(ConsumptionUIMessages.BUTTON_WS_PUBLISH);
        } else {
            this.launchUDDICheckbox_.setText(ConsumptionUIMessages.BUTTON_WS_FIND);
        }
        this.launchUDDICheckbox_.setToolTipText(ConsumptionUIMessages.TOOLTIP_PWPB_CHECKBOX_WS_LAUNCH);
        this.launchUDDICheckbox_.addListener(13, selListener);
        helpSystem.setHelp((Control)this.launchUDDICheckbox_, this.INFOPOP_PWPB_CHECKBOX_WS_LAUNCH);
        this.initPrivateUDDI();
        return this;
    }

    private void initPrivateUDDI() {
        if (!this.publish.booleanValue() && !PrivateUDDIRegistryTypeRegistry.getInstance().getPrivateUDDIRegistryType().isPrivateUDDIRegistryInstalled()) {
            this.launchPrivateUDDICheckbox_.setEnabled(false);
        }
    }

    private void handleSelectionEvent(Event event) {
        this.statusListener.handleEvent(event);
    }

    public void setPublishToPublicUDDI(boolean publish) {
        this.launchUDDICheckbox_.setSelection(publish);
    }

    public void setPublishToPublicUDDI(Boolean publish) {
        this.setPublishToPublicUDDI((boolean)publish);
    }

    public void setPublishToPrivateUDDI(boolean publish) {
        this.launchPrivateUDDICheckbox_.setSelection(publish);
    }

    public void setPublishToPrivateUDDI(Boolean publish) {
        this.setPublishToPrivateUDDI((boolean)publish);
    }

    public boolean getPublishToPublicUDDI() {
        return this.launchUDDICheckbox_.getSelection();
    }

    public boolean getPublishToPrivateUDDI() {
        return this.launchPrivateUDDICheckbox_.getSelection();
    }

    public boolean getForceLaunchOutsideIDE() {
        return false;
    }

    public LaunchOption[] getLaunchOptions() {
        Vector<LaunchOption> launchOptionVector = new Vector<LaunchOption>();
        if (this.launchUDDICheckbox_.getSelection()) {
            launchOptionVector.add(new LaunchOption("inquiry", ""));
            launchOptionVector.add(new LaunchOption("publish", ""));
        }
        if (this.launchPrivateUDDICheckbox_.getSelection()) {
            PrivateUDDIRegistryTypeRegistry privateReg = PrivateUDDIRegistryTypeRegistry.getInstance();
            PrivateUDDIRegistryType privateType = privateReg.getPrivateUDDIRegistryType();
            String[] privateInquiryURL = privateType.getPrivateUDDIRegistryInquiryAPI();
            String[] privatePublishURL = privateType.getPrivateUDDIRegistryPublishAPI();
            int i = 0;
            while (i < privateInquiryURL.length) {
                launchOptionVector.add(new LaunchOption("inquiry", privateInquiryURL[i]));
                launchOptionVector.add(new LaunchOption("publish", privatePublishURL[i]));
                ++i;
            }
        }
        return launchOptionVector.toArray(new LaunchOption[0]);
    }
}

