/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa1.context.java;

import org.eclipse.jpt.jpa.core.context.ReadOnlyColumn;
import org.eclipse.jpt.jpa.core.context.java.JavaColumn;
import org.eclipse.jpt.jpa.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaBaseColumn;
import org.eclipse.jpt.jpa.core.resource.java.CompleteColumnAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaColumn
extends AbstractJavaBaseColumn<CompleteColumnAnnotation, JavaColumn.Owner>
implements JavaColumn {
    protected Integer specifiedLength = this.buildSpecifiedLength();
    protected int defaultLength;
    protected Integer specifiedPrecision = this.buildSpecifiedPrecision();
    protected int defaultPrecision;
    protected Integer specifiedScale = this.buildSpecifiedScale();
    protected int defaultScale;

    public GenericJavaColumn(JavaJpaContextNode parent, JavaColumn.Owner owner) {
        super(parent, owner);
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setSpecifiedLength_(this.buildSpecifiedLength());
        this.setSpecifiedPrecision_(this.buildSpecifiedPrecision());
        this.setSpecifiedScale_(this.buildSpecifiedScale());
    }

    @Override
    public void update() {
        super.update();
        this.setDefaultLength(this.buildDefaultLength());
        this.setDefaultPrecision(this.buildDefaultPrecision());
        this.setDefaultScale(this.buildDefaultScale());
    }

    @Override
    public CompleteColumnAnnotation getColumnAnnotation() {
        return ((JavaColumn.Owner)this.owner).getColumnAnnotation();
    }

    @Override
    protected void removeColumnAnnotation() {
        ((JavaColumn.Owner)this.owner).removeColumnAnnotation();
    }

    @Override
    public int getLength() {
        return this.specifiedLength != null ? this.specifiedLength : this.defaultLength;
    }

    @Override
    public Integer getSpecifiedLength() {
        return this.specifiedLength;
    }

    @Override
    public void setSpecifiedLength(Integer length) {
        if (this.valuesAreDifferent(this.specifiedLength, length)) {
            this.getColumnAnnotation().setLength(length);
            this.removeColumnAnnotationIfUnset();
            this.setSpecifiedLength_(length);
        }
    }

    protected void setSpecifiedLength_(Integer length) {
        Integer old = this.specifiedLength;
        this.specifiedLength = length;
        this.firePropertyChanged("specifiedLength", old, length);
    }

    protected Integer buildSpecifiedLength() {
        return this.getColumnAnnotation().getLength();
    }

    @Override
    public int getDefaultLength() {
        return this.defaultLength;
    }

    protected void setDefaultLength(int length) {
        int old = this.defaultLength;
        this.defaultLength = length;
        this.firePropertyChanged("defaultLength", old, length);
    }

    protected int buildDefaultLength() {
        return 255;
    }

    @Override
    public int getPrecision() {
        return this.specifiedPrecision != null ? this.specifiedPrecision : this.defaultPrecision;
    }

    @Override
    public Integer getSpecifiedPrecision() {
        return this.specifiedPrecision;
    }

    @Override
    public void setSpecifiedPrecision(Integer precision) {
        if (this.valuesAreDifferent(this.specifiedPrecision, precision)) {
            this.getColumnAnnotation().setPrecision(precision);
            this.removeColumnAnnotationIfUnset();
            this.setSpecifiedPrecision_(precision);
        }
    }

    protected void setSpecifiedPrecision_(Integer precision) {
        Integer old = this.specifiedPrecision;
        this.specifiedPrecision = precision;
        this.firePropertyChanged("specifiedPrecision", old, precision);
    }

    protected Integer buildSpecifiedPrecision() {
        return this.getColumnAnnotation().getPrecision();
    }

    @Override
    public int getDefaultPrecision() {
        return this.defaultPrecision;
    }

    protected void setDefaultPrecision(int precision) {
        int old = this.defaultPrecision;
        this.defaultPrecision = precision;
        this.firePropertyChanged("defaultPrecision", old, precision);
    }

    protected int buildDefaultPrecision() {
        return 0;
    }

    @Override
    public int getScale() {
        return this.specifiedScale != null ? this.specifiedScale : this.defaultScale;
    }

    @Override
    public Integer getSpecifiedScale() {
        return this.specifiedScale;
    }

    @Override
    public void setSpecifiedScale(Integer scale) {
        if (this.valuesAreDifferent(this.specifiedScale, scale)) {
            this.getColumnAnnotation().setScale(scale);
            this.removeColumnAnnotationIfUnset();
            this.setSpecifiedScale_(scale);
        }
    }

    protected void setSpecifiedScale_(Integer scale) {
        Integer old = this.specifiedScale;
        this.specifiedScale = scale;
        this.firePropertyChanged("specifiedScale", old, scale);
    }

    protected Integer buildSpecifiedScale() {
        return this.getColumnAnnotation().getScale();
    }

    @Override
    public int getDefaultScale() {
        return this.defaultScale;
    }

    protected void setDefaultScale(int scale) {
        int old = this.defaultScale;
        this.defaultScale = scale;
        this.firePropertyChanged("defaultScale", old, scale);
    }

    protected int buildDefaultScale() {
        return 0;
    }

    @Override
    public void initializeFrom(ReadOnlyColumn oldColumn) {
        super.initializeFrom(oldColumn);
        this.setSpecifiedLength(oldColumn.getSpecifiedLength());
        this.setSpecifiedPrecision(oldColumn.getSpecifiedPrecision());
        this.setSpecifiedScale(oldColumn.getSpecifiedScale());
    }

    @Override
    public void initializeFromVirtual(ReadOnlyColumn virtualColumn) {
        super.initializeFromVirtual(virtualColumn);
    }
}

