/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.taglibprocessing.attributevalues;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jst.jsf.core.jsfappconfig.JSFAppConfigManager;
import org.eclipse.jst.jsf.facesconfig.emf.ValidatorType;
import org.eclipse.jst.jsf.metadataprocessors.features.PossibleValue;
import org.eclipse.jst.jsf.taglibprocessing.attributevalues.FacesConfigIdentifierFeatures;
import org.eclipse.jst.jsf.taglibprocessing.attributevalues.Messages;
import org.eclipse.osgi.util.NLS;

public class FacesConfigValidatorIDFeatures
extends FacesConfigIdentifierFeatures {
    protected static final String VALIDATOR = "javax.faces.validator.Validator";
    protected static final String IMAGE_NAME = "/icons/full/obj16/FacesConfig_Validator.gif";

    protected String getReturnType() {
        return VALIDATOR;
    }

    protected List getElements(JSFAppConfigManager mgr) {
        if (mgr != null) {
            return mgr.getValidators();
        }
        return new ArrayList(0);
    }

    protected List getPossibleValueProposals(List elements) {
        ArrayList<PossibleValue> ret = new ArrayList<PossibleValue>();
        Collections.sort(elements, new ValidatorSorter());
        for (ValidatorType obj : elements) {
            PossibleValue pv;
            if (obj.getValidatorId() == null || obj.getValidatorId().getTextContent() == null || (pv = this.createProposal(obj.getValidatorId().getTextContent(), obj.getDisplayName(), obj.getDescription())) == null) continue;
            pv.setIcon(this.getImage());
            ret.add(pv);
        }
        return ret;
    }

    protected String getImageName() {
        return IMAGE_NAME;
    }

    protected String getMyValidationMessage(String value) {
        if (value == null || value.trim().equals("")) {
            return Messages.FacesConfigValidatorIDFeatures_validatorid_empty;
        }
        return NLS.bind((String)Messages.FacesConfigIdentifierType_invalid_validator_id, (Object[])new String[]{this.singleQuote(value)});
    }

    protected List getElementIDs(JSFAppConfigManager mgr) {
        List elements = this.getElements(mgr);
        ArrayList<String> ret = new ArrayList<String>(elements.size());
        for (ValidatorType aType : elements) {
            String id;
            if (aType.getValidatorId() == null || aType.getValidatorId().getTextContent() == null || (id = aType.getValidatorId().getTextContent()) == null) continue;
            ret.add(id.trim());
        }
        return ret;
    }

    private static class ValidatorSorter
    implements Comparator,
    Serializable {
        private static final long serialVersionUID = -398026037193914126L;

        private ValidatorSorter() {
        }

        public int compare(Object o1, Object o2) {
            return 0;
        }
    }
}

