/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.jpa1.context.java;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.BaseColumn;
import org.eclipse.jpt.core.context.BaseOverride;
import org.eclipse.jpt.core.context.Column;
import org.eclipse.jpt.core.context.NamedColumn;
import org.eclipse.jpt.core.context.TypeMapping;
import org.eclipse.jpt.core.context.java.JavaAttributeOverride;
import org.eclipse.jpt.core.context.java.JavaAttributeOverrideContainer;
import org.eclipse.jpt.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.core.internal.context.java.VirtualAttributeOverrideAnnotation;
import org.eclipse.jpt.core.resource.java.Annotation;
import org.eclipse.jpt.core.resource.java.AttributeOverrideAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.core.resource.java.NestableAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.db.Table;
import org.eclipse.jpt.utility.Filter;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.HashBag;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.jpt.utility.internal.iterators.CompositeListIterator;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaAttributeOverrideContainer
extends AbstractJavaJpaContextNode
implements JavaAttributeOverrideContainer {
    protected JavaResourcePersistentMember javaResourcePersistentMember;
    protected final List<JavaAttributeOverride> specifiedAttributeOverrides;
    protected final List<JavaAttributeOverride> virtualAttributeOverrides;
    protected final JavaAttributeOverrideContainer.Owner owner;

    public GenericJavaAttributeOverrideContainer(JavaJpaContextNode parent, JavaAttributeOverrideContainer.Owner owner) {
        super(parent);
        this.owner = owner;
        this.specifiedAttributeOverrides = new ArrayList<JavaAttributeOverride>();
        this.virtualAttributeOverrides = new ArrayList<JavaAttributeOverride>();
    }

    protected JavaAttributeOverrideContainer.Owner getOwner() {
        return this.owner;
    }

    @Override
    public ListIterator<JavaAttributeOverride> attributeOverrides() {
        return new CompositeListIterator(new ListIterator[]{this.specifiedAttributeOverrides(), this.virtualAttributeOverrides()});
    }

    @Override
    public int attributeOverridesSize() {
        return this.specifiedAttributeOverridesSize() + this.virtualAttributeOverridesSize();
    }

    @Override
    public ListIterator<JavaAttributeOverride> virtualAttributeOverrides() {
        return new CloneListIterator(this.virtualAttributeOverrides);
    }

    @Override
    public int virtualAttributeOverridesSize() {
        return this.virtualAttributeOverrides.size();
    }

    @Override
    public ListIterator<JavaAttributeOverride> specifiedAttributeOverrides() {
        return new CloneListIterator(this.specifiedAttributeOverrides);
    }

    @Override
    public int specifiedAttributeOverridesSize() {
        return this.specifiedAttributeOverrides.size();
    }

    protected JavaAttributeOverride addSpecifiedAttributeOverride(int index) {
        JavaAttributeOverride attributeOverride = this.getJpaFactory().buildJavaAttributeOverride(this, this.createAttributeOverrideOwner());
        this.specifiedAttributeOverrides.add(index, attributeOverride);
        AttributeOverrideAnnotation attributeOverrideResource = (AttributeOverrideAnnotation)((Object)this.javaResourcePersistentMember.addAnnotation(index, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides"));
        attributeOverride.initialize(attributeOverrideResource);
        this.fireItemAdded("specifiedAttributeOverrides", index, attributeOverride);
        return attributeOverride;
    }

    protected JavaAttributeOverride setAttributeOverrideVirtual(boolean virtual, JavaAttributeOverride attributeOverride) {
        if (virtual) {
            return this.setAttributeOverrideVirtual(attributeOverride);
        }
        return this.setAttributeOverrideSpecified(attributeOverride);
    }

    protected JavaAttributeOverride setAttributeOverrideVirtual(JavaAttributeOverride specifiedAttributeOverride) {
        int index = this.specifiedAttributeOverrides.indexOf(specifiedAttributeOverride);
        this.specifiedAttributeOverrides.remove(index);
        String attributeOverrideName = specifiedAttributeOverride.getName();
        JavaAttributeOverride virtualAttributeOverride = null;
        if (attributeOverrideName != null) {
            for (String name : CollectionTools.iterable(this.allOverridableAttributeNames())) {
                if (!name.equals(attributeOverrideName)) continue;
                virtualAttributeOverride = this.buildVirtualAttributeOverride(name);
                this.virtualAttributeOverrides.add(virtualAttributeOverride);
                break;
            }
        }
        this.javaResourcePersistentMember.removeAnnotation(this.resourceIndexOf(specifiedAttributeOverride), "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        this.fireItemRemoved("specifiedAttributeOverrides", index, specifiedAttributeOverride);
        if (virtualAttributeOverride != null) {
            this.fireItemAdded("virtualAttributeOverrides", this.virtualAttributeOverridesSize() - 1, virtualAttributeOverride);
        }
        return virtualAttributeOverride;
    }

    protected JavaAttributeOverride setAttributeOverrideSpecified(JavaAttributeOverride virtualAttributeOverride) {
        int index = this.specifiedAttributeOverridesSize();
        int resourceIndex = 0;
        if (this.specifiedAttributeOverridesSize() > 0) {
            resourceIndex = this.resourceIndexOf(this.specifiedAttributeOverrides.get(index - 1)) + 1;
        }
        JavaAttributeOverride specifiedAttributeOverride = this.getJpaFactory().buildJavaAttributeOverride(this, this.createAttributeOverrideOwner());
        AttributeOverrideAnnotation attributeOverrideResource = (AttributeOverrideAnnotation)((Object)this.javaResourcePersistentMember.addAnnotation(resourceIndex, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides"));
        specifiedAttributeOverride.initialize(attributeOverrideResource);
        int defaultIndex = this.virtualAttributeOverrides.indexOf(virtualAttributeOverride);
        this.virtualAttributeOverrides.remove(defaultIndex);
        String name = virtualAttributeOverride.getName();
        String prefix = this.getOwner().getWritePrefix();
        if (prefix != null) {
            name = String.valueOf(prefix) + name;
        }
        this.specifiedAttributeOverrides.add(index, specifiedAttributeOverride);
        specifiedAttributeOverride.setName(name);
        specifiedAttributeOverride.getColumn().setSpecifiedName(virtualAttributeOverride.getColumn().getName());
        this.fireItemRemoved("virtualAttributeOverrides", defaultIndex, virtualAttributeOverride);
        this.fireItemAdded("specifiedAttributeOverrides", index, specifiedAttributeOverride);
        return specifiedAttributeOverride;
    }

    protected JavaAttributeOverride.Owner createAttributeOverrideOwner() {
        return new AttributeOverrideOwner();
    }

    protected void addSpecifiedAttributeOverride(int index, JavaAttributeOverride attributeOverride) {
        this.addItemToList(index, attributeOverride, this.specifiedAttributeOverrides, "specifiedAttributeOverrides");
    }

    protected void addSpecifiedAttributeOverride(JavaAttributeOverride attributeOverride) {
        this.addSpecifiedAttributeOverride(this.specifiedAttributeOverrides.size(), attributeOverride);
    }

    protected void removeSpecifiedAttributeOverride_(JavaAttributeOverride attributeOverride) {
        this.removeItemFromList(attributeOverride, this.specifiedAttributeOverrides, "specifiedAttributeOverrides");
    }

    @Override
    public void moveSpecifiedAttributeOverride(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.specifiedAttributeOverrides, (int)targetIndex, (int)sourceIndex);
        this.javaResourcePersistentMember.moveAnnotation(targetIndex, sourceIndex, "javax.persistence.AttributeOverrides");
        this.fireItemMoved("specifiedAttributeOverrides", targetIndex, sourceIndex);
    }

    protected void addVirtualAttributeOverride(JavaAttributeOverride attributeOverride) {
        this.addItemToList(attributeOverride, this.virtualAttributeOverrides, "virtualAttributeOverrides");
    }

    protected void removeVirtualAttributeOverride(JavaAttributeOverride attributeOverride) {
        this.removeItemFromList(attributeOverride, this.virtualAttributeOverrides, "virtualAttributeOverrides");
    }

    @Override
    public JavaAttributeOverride getAttributeOverrideNamed(String name) {
        return (JavaAttributeOverride)this.getOverrideNamed(name, this.attributeOverrides());
    }

    public boolean containsAttributeOverride(String name) {
        return this.containsOverride(name, this.attributeOverrides());
    }

    public boolean containsDefaultAttributeOverride(String name) {
        return this.containsOverride(name, this.virtualAttributeOverrides());
    }

    public boolean containsSpecifiedAttributeOverride(String name) {
        return this.containsOverride(name, this.specifiedAttributeOverrides());
    }

    protected BaseOverride getOverrideNamed(String name, ListIterator<? extends BaseOverride> overrides) {
        for (BaseOverride override : CollectionTools.iterable(overrides)) {
            String overrideName = override.getName();
            if (overrideName == null && name == null) {
                return override;
            }
            if (overrideName == null || !overrideName.equals(name)) continue;
            return override;
        }
        return null;
    }

    protected boolean containsOverride(String name, ListIterator<? extends BaseOverride> overrides) {
        return this.getOverrideNamed(name, overrides) != null;
    }

    protected Iterator<String> allOverridableAttributeNames() {
        return this.getOwner().allOverridableNames();
    }

    @Override
    public void initialize(JavaResourcePersistentMember resourcePersistentMember) {
        this.javaResourcePersistentMember = resourcePersistentMember;
        this.initializeSpecifiedAttributeOverrides();
        this.initializeVirtualAttributeOverrides();
    }

    protected void initializeSpecifiedAttributeOverrides() {
        Iterator<NestableAnnotation> stream = this.relavantResourceAttributeOverrides();
        while (stream.hasNext()) {
            this.specifiedAttributeOverrides.add(this.buildAttributeOverride((AttributeOverrideAnnotation)((Object)stream.next())));
        }
    }

    protected void initializeVirtualAttributeOverrides() {
        for (String name : CollectionTools.iterable(this.allOverridableAttributeNames())) {
            JavaAttributeOverride attributeOverride = this.getAttributeOverrideNamed(name);
            if (attributeOverride != null) continue;
            this.virtualAttributeOverrides.add(this.buildVirtualAttributeOverride(name));
        }
    }

    @Override
    public void update(JavaResourcePersistentMember resourcePersistentMember) {
        this.javaResourcePersistentMember = resourcePersistentMember;
        this.updateSpecifiedAttributeOverrides();
        this.updateVirtualAttributeOverrides();
    }

    protected void updateSpecifiedAttributeOverrides() {
        ListIterator<JavaAttributeOverride> attributeOverrides = this.specifiedAttributeOverrides();
        Iterator<NestableAnnotation> resourceAttributeOverrides = this.relavantResourceAttributeOverrides();
        while (attributeOverrides.hasNext()) {
            JavaAttributeOverride attributeOverride = attributeOverrides.next();
            if (resourceAttributeOverrides.hasNext()) {
                attributeOverride.update((AttributeOverrideAnnotation)((Object)resourceAttributeOverrides.next()));
                continue;
            }
            this.removeSpecifiedAttributeOverride_(attributeOverride);
        }
        while (resourceAttributeOverrides.hasNext()) {
            this.addSpecifiedAttributeOverride(this.buildAttributeOverride((AttributeOverrideAnnotation)((Object)resourceAttributeOverrides.next())));
        }
    }

    protected Iterator<NestableAnnotation> relavantResourceAttributeOverrides() {
        Iterator<NestableAnnotation> resourceAttributeOverrides = this.javaResourcePersistentMember.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        return new FilteringIterator<NestableAnnotation>(resourceAttributeOverrides){

            protected boolean accept(NestableAnnotation o) {
                String overrideName = ((AttributeOverrideAnnotation)((Object)o)).getName();
                return overrideName != null && GenericJavaAttributeOverrideContainer.this.getOwner().isRelevant(overrideName);
            }
        };
    }

    protected int resourceIndexOf(JavaAttributeOverride specifiedAttributeOverride) {
        Iterator<NestableAnnotation> overrideAnnotations = this.javaResourcePersistentMember.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        return CollectionTools.indexOf(overrideAnnotations, (Object)specifiedAttributeOverride.getOverrideAnnotation());
    }

    protected JavaAttributeOverride buildAttributeOverride(AttributeOverrideAnnotation attributeOverrideResource) {
        JavaAttributeOverride attributeOverride = this.getJpaFactory().buildJavaAttributeOverride(this, this.createAttributeOverrideOwner());
        attributeOverride.initialize(attributeOverrideResource);
        return attributeOverride;
    }

    protected JavaAttributeOverride buildVirtualAttributeOverride(String attributeOverrideName) {
        return this.buildAttributeOverride(this.buildVirtualAttributeOverrideAnnotation(attributeOverrideName));
    }

    protected VirtualAttributeOverrideAnnotation buildVirtualAttributeOverrideAnnotation(String attributeOverrideName) {
        Column column = this.resolveOverriddenColumn(attributeOverrideName);
        return new VirtualAttributeOverrideAnnotation(this.javaResourcePersistentMember, attributeOverrideName, column);
    }

    private Column resolveOverriddenColumn(String attributeOverrideName) {
        return this.getOwner().resolveOverriddenColumn(attributeOverrideName);
    }

    protected void updateVirtualAttributeOverrides() {
        for (String name : CollectionTools.iterable(this.allOverridableAttributeNames())) {
            JavaAttributeOverride attributeOverride = this.getAttributeOverrideNamed(name);
            if (attributeOverride == null) {
                this.addVirtualAttributeOverride(this.buildVirtualAttributeOverride(name));
                continue;
            }
            if (!attributeOverride.isVirtual()) continue;
            attributeOverride.update(this.buildVirtualAttributeOverrideAnnotation(name));
        }
        HashBag attributeNames = CollectionTools.collection(this.allOverridableAttributeNames());
        for (JavaAttributeOverride attributeOverride : CollectionTools.iterable(this.virtualAttributeOverrides())) {
            if (attributeNames.contains(attributeOverride.getName()) && !this.containsSpecifiedAttributeOverride(attributeOverride.getName())) continue;
            this.removeVirtualAttributeOverride(attributeOverride);
        }
    }

    @Override
    public Iterator<String> javaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator result = super.javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        for (JavaAttributeOverride override : CollectionTools.iterable(this.attributeOverrides())) {
            result = override.javaCompletionProposals(pos, filter, astRoot);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        ListIterator<JavaAttributeOverride> stream = this.attributeOverrides();
        while (stream.hasNext()) {
            ((JavaAttributeOverride)stream.next()).validate(messages, reporter, astRoot);
        }
    }

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        Annotation annotation = this.javaResourcePersistentMember.getAnnotation("javax.persistence.AttributeOverrides");
        if (annotation == null) {
            annotation = this.javaResourcePersistentMember.getAnnotation("javax.persistence.AttributeOverride");
        }
        return annotation == null ? this.getOwner().getValidationTextRange(astRoot) : annotation.getTextRange(astRoot);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class AttributeOverrideOwner
    implements JavaAttributeOverride.Owner {
        protected AttributeOverrideOwner() {
        }

        @Override
        public Column resolveOverriddenColumn(String attributeName) {
            if (attributeName == null) {
                return null;
            }
            return GenericJavaAttributeOverrideContainer.this.resolveOverriddenColumn(attributeName);
        }

        @Override
        public boolean isVirtual(BaseOverride override) {
            return GenericJavaAttributeOverrideContainer.this.virtualAttributeOverrides.contains(override);
        }

        @Override
        public BaseOverride setVirtual(boolean virtual, BaseOverride attributeOverride) {
            return GenericJavaAttributeOverrideContainer.this.setAttributeOverrideVirtual(virtual, (JavaAttributeOverride)attributeOverride);
        }

        @Override
        public TypeMapping getTypeMapping() {
            return GenericJavaAttributeOverrideContainer.this.getOwner().getTypeMapping();
        }

        @Override
        public Iterator<String> allOverridableAttributeNames() {
            return GenericJavaAttributeOverrideContainer.this.allOverridableAttributeNames();
        }

        @Override
        public String getPossiblePrefix() {
            return GenericJavaAttributeOverrideContainer.this.getOwner().getPossiblePrefix();
        }

        @Override
        public boolean tableNameIsInvalid(String tableName) {
            return GenericJavaAttributeOverrideContainer.this.getOwner().tableNameIsInvalid(tableName);
        }

        @Override
        public Iterator<String> candidateTableNames() {
            return GenericJavaAttributeOverrideContainer.this.getOwner().candidateTableNames();
        }

        @Override
        public String getDefaultTableName() {
            return GenericJavaAttributeOverrideContainer.this.getOwner().getDefaultTableName();
        }

        @Override
        public Table getDbTable(String tableName) {
            return GenericJavaAttributeOverrideContainer.this.getOwner().getDbTable(tableName);
        }

        @Override
        public IMessage buildColumnTableNotValidMessage(BaseOverride override, BaseColumn column, TextRange textRange) {
            return GenericJavaAttributeOverrideContainer.this.getOwner().buildColumnTableNotValidMessage(override, column, textRange);
        }

        @Override
        public IMessage buildColumnUnresolvedNameMessage(BaseOverride override, NamedColumn column, TextRange textRange) {
            return GenericJavaAttributeOverrideContainer.this.getOwner().buildColumnUnresolvedNameMessage(override, column, textRange);
        }
    }
}

