/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.jpt.core.context.JoinColumn;
import org.eclipse.jpt.core.context.JoinTable;
import org.eclipse.jpt.core.context.UniqueConstraint;
import org.eclipse.jpt.core.context.orm.OrmTypeMapping;
import org.eclipse.jpt.core.internal.context.orm.VirtualXmlJoinColumn;
import org.eclipse.jpt.core.internal.context.orm.VirtualXmlUniqueConstraint;
import org.eclipse.jpt.core.resource.orm.XmlJoinColumn;
import org.eclipse.jpt.core.resource.orm.XmlJoinTable;
import org.eclipse.jpt.core.resource.orm.XmlUniqueConstraint;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.utility.internal.CollectionTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualXmlJoinTable
extends XmlJoinTable {
    protected OrmTypeMapping ormTypeMapping;
    protected JoinTable joinTable;

    public VirtualXmlJoinTable(OrmTypeMapping ormTypeMapping, JoinTable joinTable) {
        this.ormTypeMapping = ormTypeMapping;
        this.joinTable = joinTable;
    }

    protected boolean isOrmMetadataComplete() {
        return this.ormTypeMapping.isMetadataComplete();
    }

    @Override
    public String getName() {
        if (this.isOrmMetadataComplete()) {
            return this.joinTable.getDefaultName();
        }
        return this.joinTable.getName();
    }

    @Override
    public void setName(String value) {
        throw new UnsupportedOperationException("cannot set values on a virtual mapping");
    }

    @Override
    public String getCatalog() {
        if (this.isOrmMetadataComplete()) {
            return this.joinTable.getDefaultCatalog();
        }
        return this.joinTable.getCatalog();
    }

    @Override
    public void setCatalog(String value) {
        throw new UnsupportedOperationException("cannot set values on a virtual mapping");
    }

    @Override
    public String getSchema() {
        if (this.isOrmMetadataComplete()) {
            return this.joinTable.getDefaultSchema();
        }
        return this.joinTable.getSchema();
    }

    @Override
    public void setSchema(String value) {
        throw new UnsupportedOperationException("cannot set values on a virtual mapping");
    }

    @Override
    public EList<XmlJoinColumn> getJoinColumns() {
        EObjectContainmentEList joinColumns = new EObjectContainmentEList(XmlJoinColumn.class, (InternalEObject)this, 4);
        if (this.joinTable == null || this.isOrmMetadataComplete()) {
            return joinColumns;
        }
        for (JoinColumn joinColumn : CollectionTools.iterable(this.joinTable.specifiedJoinColumns())) {
            VirtualXmlJoinColumn xmlJoinColumn = new VirtualXmlJoinColumn(joinColumn, this.isOrmMetadataComplete());
            joinColumns.add((Object)xmlJoinColumn);
        }
        return joinColumns;
    }

    @Override
    public EList<XmlJoinColumn> getInverseJoinColumns() {
        EObjectContainmentEList inverseJoinColumns = new EObjectContainmentEList(XmlJoinColumn.class, (InternalEObject)this, 5);
        if (this.joinTable == null || this.isOrmMetadataComplete()) {
            return inverseJoinColumns;
        }
        for (JoinColumn joinColumn : CollectionTools.iterable(this.joinTable.specifiedInverseJoinColumns())) {
            VirtualXmlJoinColumn xmlJoinColumn = new VirtualXmlJoinColumn(joinColumn, this.isOrmMetadataComplete());
            inverseJoinColumns.add((Object)xmlJoinColumn);
        }
        return inverseJoinColumns;
    }

    @Override
    public EList<XmlUniqueConstraint> getUniqueConstraints() {
        EObjectContainmentEList xmlUniqueConstraints = new EObjectContainmentEList(XmlUniqueConstraint.class, (InternalEObject)this, 3);
        if (this.joinTable == null || this.isOrmMetadataComplete()) {
            return xmlUniqueConstraints;
        }
        for (UniqueConstraint uniqueConstraint : CollectionTools.iterable(this.joinTable.uniqueConstraints())) {
            VirtualXmlUniqueConstraint xmlUniqueConstraint = new VirtualXmlUniqueConstraint(uniqueConstraint, this.isOrmMetadataComplete());
            xmlUniqueConstraints.add((Object)xmlUniqueConstraint);
        }
        return xmlUniqueConstraints;
    }

    @Override
    public TextRange getNameTextRange() {
        return null;
    }

    @Override
    public TextRange getCatalogTextRange() {
        return null;
    }

    @Override
    public TextRange getSchemaTextRange() {
        return null;
    }
}

