/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.AttributeMapping;
import org.eclipse.jpt.core.context.Column;
import org.eclipse.jpt.core.context.PersistentType;
import org.eclipse.jpt.core.context.RelationshipReference;
import org.eclipse.jpt.core.context.Table;
import org.eclipse.jpt.core.context.TypeMapping;
import org.eclipse.jpt.core.context.java.JavaAttributeMapping;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.context.java.JavaPersistentType;
import org.eclipse.jpt.core.context.java.JavaTypeMapping;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.core.resource.java.Annotation;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.db.Schema;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterables.FilteringIterable;
import org.eclipse.jpt.utility.internal.iterables.TransformationIterable;
import org.eclipse.jpt.utility.internal.iterators.CompositeIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaTypeMapping
extends AbstractJavaJpaContextNode
implements JavaTypeMapping {
    protected JavaResourcePersistentType javaResourcePersistentType;

    protected AbstractJavaTypeMapping(JavaPersistentType parent) {
        super(parent);
    }

    @Override
    public JavaPersistentType getParent() {
        return (JavaPersistentType)super.getParent();
    }

    protected JavaResourcePersistentType getResourcePersistentType() {
        return this.javaResourcePersistentType;
    }

    protected Annotation getResourceMappingAnnotation() {
        return this.javaResourcePersistentType.getAnnotation(this.getAnnotationName());
    }

    @Override
    public JavaPersistentType getPersistentType() {
        return this.getParent();
    }

    @Override
    public JavaPersistentType getIdClass() {
        return null;
    }

    @Override
    public String getPrimaryTableName() {
        return null;
    }

    @Override
    public org.eclipse.jpt.db.Table getPrimaryDbTable() {
        return null;
    }

    @Override
    public org.eclipse.jpt.db.Table getDbTable(String tableName) {
        return null;
    }

    @Override
    public Schema getDbSchema() {
        return null;
    }

    @Override
    public boolean attributeMappingKeyAllowed(String attributeMappingKey) {
        return true;
    }

    @Override
    public Iterator<Table> associatedTables() {
        return EmptyIterator.instance();
    }

    @Override
    public Iterator<String> associatedTableNamesIncludingInherited() {
        return EmptyIterator.instance();
    }

    @Override
    public Iterator<Table> associatedTablesIncludingInherited() {
        return EmptyIterator.instance();
    }

    @Override
    public TypeMapping getSuperTypeMapping() {
        return this.getPersistentType().getSuperPersistentType() == null ? null : this.getPersistentType().getSuperPersistentType().getMapping();
    }

    @Override
    public Iterator<TypeMapping> inheritanceHierarchy() {
        return this.getInheritanceHierarchy().iterator();
    }

    public Iterable<TypeMapping> getInheritanceHierarchy() {
        return new TransformationIterable<PersistentType, TypeMapping>(CollectionTools.iterable(this.getPersistentType().inheritanceHierarchy())){

            protected TypeMapping transform(PersistentType type) {
                return type.getMapping();
            }
        };
    }

    @Override
    public Iterator<JavaAttributeMapping> attributeMappings() {
        return new TransformationIterator<JavaPersistentAttribute, JavaAttributeMapping>(this.getPersistentType().attributes()){

            protected JavaAttributeMapping transform(JavaPersistentAttribute attribute) {
                return attribute.getMapping();
            }
        };
    }

    public Iterable<JavaAttributeMapping> getAttributeMappings(final String mappingKey) {
        return new FilteringIterable<JavaAttributeMapping>((Iterable)CollectionTools.collection(this.attributeMappings())){

            protected boolean accept(JavaAttributeMapping o) {
                return StringTools.stringsAreEqual((String)o.getKey(), (String)mappingKey);
            }
        };
    }

    @Override
    public Iterator<AttributeMapping> allAttributeMappings() {
        return new CompositeIterator((Iterator)new TransformationIterator<TypeMapping, Iterator<AttributeMapping>>(this.inheritanceHierarchy()){

            protected Iterator<AttributeMapping> transform(TypeMapping typeMapping) {
                return typeMapping == null ? EmptyIterator.instance() : typeMapping.attributeMappings();
            }
        });
    }

    public Iterable<AttributeMapping> getAllAttributeMappings(final String mappingKey) {
        return new FilteringIterable<AttributeMapping>((Iterable)CollectionTools.collection(this.allAttributeMappings())){

            protected boolean accept(AttributeMapping o) {
                return StringTools.stringsAreEqual((String)o.getKey(), (String)mappingKey);
            }
        };
    }

    @Override
    public Iterator<String> overridableAttributeNames() {
        return new CompositeIterator((Iterator)new TransformationIterator<AttributeMapping, Iterator<String>>(this.attributeMappings()){

            protected Iterator<String> transform(AttributeMapping mapping) {
                return mapping.allOverrideableAttributeMappingNames();
            }
        });
    }

    @Override
    public Iterator<String> allOverridableAttributeNames() {
        return new CompositeIterator((Iterator)new TransformationIterator<TypeMapping, Iterator<String>>(this.inheritanceHierarchy()){

            protected Iterator<String> transform(TypeMapping mapping) {
                return mapping.overridableAttributeNames();
            }
        });
    }

    @Override
    public Column resolveOverriddenColumn(String attributeName) {
        for (AttributeMapping attributeMapping : CollectionTools.iterable(this.attributeMappings())) {
            Column resolvedColumn = attributeMapping.resolveOverriddenColumn(attributeName);
            if (resolvedColumn == null) continue;
            return resolvedColumn;
        }
        return null;
    }

    @Override
    public RelationshipReference resolveRelationshipReference(String attributeName) {
        for (AttributeMapping attributeMapping : CollectionTools.iterable(this.attributeMappings())) {
            RelationshipReference resolvedRelationshipReference = attributeMapping.resolveRelationshipReference(attributeName);
            if (resolvedRelationshipReference == null) continue;
            return resolvedRelationshipReference;
        }
        return null;
    }

    @Override
    public Iterator<String> overridableAssociationNames() {
        return new CompositeIterator((Iterator)new TransformationIterator<AttributeMapping, Iterator<String>>(this.attributeMappings()){

            protected Iterator<String> transform(AttributeMapping mapping) {
                return mapping.allOverrideableAssociationMappingNames();
            }
        });
    }

    @Override
    public Iterator<String> allOverridableAssociationNames() {
        return new CompositeIterator((Iterator)new TransformationIterator<TypeMapping, Iterator<String>>(this.inheritanceHierarchy()){

            protected Iterator<String> transform(TypeMapping mapping) {
                return mapping.overridableAssociationNames();
            }
        });
    }

    @Override
    public void initialize(JavaResourcePersistentType jrpt) {
        this.javaResourcePersistentType = jrpt;
    }

    @Override
    public void update(JavaResourcePersistentType jrpt) {
        this.javaResourcePersistentType = jrpt;
    }

    @Override
    public boolean shouldValidateAgainstDatabase() {
        return this.getPersistenceUnit().shouldValidateAgainstDatabase();
    }

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        TextRange textRange = this.getResourceMappingAnnotation().getTextRange(astRoot);
        return textRange != null ? textRange : this.getPersistentType().getValidationTextRange(astRoot);
    }

    public void toString(StringBuilder sb) {
        sb.append(this.getPersistentType().getName());
    }
}

