/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.datamodel.beanmodel;

import java.util.Hashtable;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jst.ws.internal.consumption.datamodel.beanmodel.ArrayElement;
import org.eclipse.jst.ws.internal.consumption.datamodel.beanmodel.ArrayType;
import org.eclipse.jst.ws.internal.consumption.datamodel.beanmodel.BeanElement;
import org.eclipse.jst.ws.internal.consumption.datamodel.beanmodel.BigDecimalType;
import org.eclipse.jst.ws.internal.consumption.datamodel.beanmodel.BigIntegerType;
import org.eclipse.jst.ws.internal.consumption.datamodel.beanmodel.DataType;
import org.eclipse.jst.ws.internal.consumption.datamodel.beanmodel.DateType;
import org.eclipse.jst.ws.internal.consumption.datamodel.beanmodel.DomElementType;
import org.eclipse.jst.ws.internal.consumption.datamodel.beanmodel.GregorianCalendarType;
import org.eclipse.jst.ws.internal.consumption.datamodel.beanmodel.HashtableType;
import org.eclipse.jst.ws.internal.consumption.datamodel.beanmodel.MapType;
import org.eclipse.jst.ws.internal.consumption.datamodel.beanmodel.ObjectType;
import org.eclipse.jst.ws.internal.consumption.datamodel.beanmodel.PrimitiveArrayType;
import org.eclipse.jst.ws.internal.consumption.datamodel.beanmodel.PrimitiveBooleanType;
import org.eclipse.jst.ws.internal.consumption.datamodel.beanmodel.PrimitiveByteType;
import org.eclipse.jst.ws.internal.consumption.datamodel.beanmodel.PrimitiveCharType;
import org.eclipse.jst.ws.internal.consumption.datamodel.beanmodel.PrimitiveDoubleType;
import org.eclipse.jst.ws.internal.consumption.datamodel.beanmodel.PrimitiveFloatType;
import org.eclipse.jst.ws.internal.consumption.datamodel.beanmodel.PrimitiveIntType;
import org.eclipse.jst.ws.internal.consumption.datamodel.beanmodel.PrimitiveJavaTypes;
import org.eclipse.jst.ws.internal.consumption.datamodel.beanmodel.PrimitiveLongType;
import org.eclipse.jst.ws.internal.consumption.datamodel.beanmodel.PrimitiveShortType;
import org.eclipse.jst.ws.internal.consumption.datamodel.beanmodel.SOAPElementType;
import org.eclipse.jst.ws.internal.consumption.datamodel.beanmodel.StateLessBeanType;
import org.eclipse.jst.ws.internal.consumption.datamodel.beanmodel.StringType;
import org.eclipse.jst.ws.internal.consumption.datamodel.beanmodel.URLType;
import org.eclipse.jst.ws.internal.consumption.datamodel.beanmodel.VectorType;
import org.eclipse.jst.ws.internal.consumption.datamodel.beanmodel.VoidType;

public class TypeFactory {
    public static final String copyright = "(c) Copyright IBM Corporation 2000, 2002.";
    public static final String URL_NAME = "java.net.URL";
    public static final String STRING_NAME = "java.lang.String";
    public static final String BIG_DECIMAL_NAME = "java.math.BigDecimal";
    public static final String BIG_INTEGER_NAME = "java.math.BigInteger";
    public static final String DATE_NAME = "java.util.Date";
    public static final String GREGORIAN_CALENDAR_NAME = "java.util.GregorianCalendar";
    public static final String CALENDAR_NAME = "java.util.Calendar";
    public static final String BOOLEAN_NAME = "java.lang.Boolean";
    public static final String BYTE_NAME = "java.lang.Byte";
    public static final String DOUBLE_NAME = "java.lang.Double";
    public static final String FLOAT_NAME = "java.lang.Float";
    public static final String INTEGER_NAME = "java.lang.Integer";
    public static final String LONG_NAME = "java.lang.Long";
    public static final String SHORT_NAME = "java.lang.Short";
    public static final String CHARACTER_NAME = "java.lang.Character";
    public static final String OBJECT_NAME = "java.lang.Object";
    public static final String PRIM_BOOLEAN_NAME = "boolean";
    public static final String PRIM_BYTE_NAME = "byte";
    public static final String PRIM_DOUBLE_NAME = "double";
    public static final String PRIM_FLOAT_NAME = "float";
    public static final String PRIM_INTEGER_NAME = "int";
    public static final String PRIM_LONG_NAME = "long";
    public static final String PRIM_SHORT_NAME = "short";
    public static final String PRIM_CHAR_NAME = "char";
    public static final String VOID_NAME = "void";
    public static final String DOM_ELEMENT_NAME = "org.w3c.dom.Element";
    public static final String SOAP_ELEMENT_NAME = "javax.xml.soap.SOAPElement";
    public static final String STATELESS_BEAN = BeanElement.STATELESS_BEAN;
    public static Hashtable javaTypes = new Hashtable();
    public static String HASHTABLE_NAME;
    public static String MAP_NAME;
    public static String VECTOR_NAME;
    public static String ARRAY_NAME;
    public static String PRIMITIVE_ARRAY_NAME;
    public static String DATA_HANDLER;

    static {
        javaTypes.put(BOOLEAN_NAME, new PrimitiveJavaTypes(BOOLEAN_NAME));
        javaTypes.put(BYTE_NAME, new PrimitiveJavaTypes(BYTE_NAME));
        javaTypes.put(DOUBLE_NAME, new PrimitiveJavaTypes(DOUBLE_NAME));
        javaTypes.put(FLOAT_NAME, new PrimitiveJavaTypes(FLOAT_NAME));
        javaTypes.put(INTEGER_NAME, new PrimitiveJavaTypes(INTEGER_NAME));
        javaTypes.put(LONG_NAME, new PrimitiveJavaTypes(LONG_NAME));
        javaTypes.put(SHORT_NAME, new PrimitiveJavaTypes(SHORT_NAME));
        javaTypes.put(CHARACTER_NAME, new PrimitiveJavaTypes(CHARACTER_NAME));
        HASHTABLE_NAME = "java.util.Hashtable";
        MAP_NAME = "java.util.Map";
        VECTOR_NAME = "java.util.Vector";
        ARRAY_NAME = ArrayElement.ARRAY_NAME;
        PRIMITIVE_ARRAY_NAME = "primitivearray";
        DATA_HANDLER = "javax.activation.DataHandler";
    }

    public static boolean recognizedBean(String type) {
        return type.equals(BOOLEAN_NAME) || type.equals(BYTE_NAME) || type.equals(DOUBLE_NAME) || type.equals(FLOAT_NAME) || type.equals(INTEGER_NAME) || type.equals(LONG_NAME) || type.equals(SHORT_NAME) || type.equals(CHARACTER_NAME) || type.equals(DOM_ELEMENT_NAME) || type.equals(SOAP_ELEMENT_NAME) || type.equals(BIG_DECIMAL_NAME) || type.equals(BIG_INTEGER_NAME) || type.equals(DATE_NAME) || type.equals(GREGORIAN_CALENDAR_NAME) || type.equals(CALENDAR_NAME) || type.equals(URL_NAME) || type.equals(OBJECT_NAME) || type.equals(STRING_NAME);
    }

    public static boolean isUnSupportedType(JavaHelpers javaHelpers) {
        return javaHelpers.isArray() || javaHelpers.getJavaName().equals(MAP_NAME) || javaHelpers.getJavaName().equals(VECTOR_NAME) || javaHelpers.getJavaName().equals(DATA_HANDLER) || javaHelpers.getJavaName().equals(OBJECT_NAME) || javaHelpers.getJavaName().equals("java.lang.class");
    }

    public static boolean isRecognizedReturnType(JavaHelpers javaHelpers) {
        if (javaHelpers.isArray()) {
            return true;
        }
        if (javaHelpers.getJavaName().equals(HASHTABLE_NAME)) {
            return true;
        }
        if (javaHelpers.getJavaName().equals(VECTOR_NAME)) {
            return true;
        }
        if (javaHelpers.getJavaName().equals(MAP_NAME)) {
            return true;
        }
        return javaHelpers.getJavaName().equals(OBJECT_NAME);
    }

    public static boolean isRecognizedReturnType(String type) {
        if (type.startsWith(ARRAY_NAME)) {
            return true;
        }
        if (type.equals(HASHTABLE_NAME)) {
            return true;
        }
        if (type.equals(VECTOR_NAME)) {
            return true;
        }
        if (type.equals(MAP_NAME)) {
            return true;
        }
        return type.equals(OBJECT_NAME);
    }

    public static boolean isStateLessBean(String type) {
        return type.startsWith(STATELESS_BEAN);
    }

    public static DataType createType(String type, String UniqueName) {
        boolean stateless = false;
        if (type.startsWith(STATELESS_BEAN)) {
            stateless = true;
            type = type.substring(29);
        }
        DataType datatype = null;
        if (type.equals(PRIM_BOOLEAN_NAME)) {
            datatype = new PrimitiveBooleanType();
        } else if (type.equals(PRIM_BYTE_NAME)) {
            datatype = new PrimitiveByteType();
        } else if (type.equals(PRIM_DOUBLE_NAME)) {
            datatype = new PrimitiveDoubleType();
        } else if (type.equals(PRIM_FLOAT_NAME)) {
            datatype = new PrimitiveFloatType();
        } else if (type.equals(PRIM_LONG_NAME)) {
            datatype = new PrimitiveLongType();
        } else if (type.equals(PRIM_INTEGER_NAME)) {
            datatype = new PrimitiveIntType();
        } else if (type.equals(PRIM_CHAR_NAME)) {
            datatype = new PrimitiveCharType();
        } else if (type.equals(PRIM_SHORT_NAME)) {
            datatype = new PrimitiveShortType();
        } else if (type.equals(BOOLEAN_NAME) || type.equals(BYTE_NAME) || type.equals(DOUBLE_NAME) || type.equals(FLOAT_NAME) || type.equals(INTEGER_NAME) || type.equals(LONG_NAME) || type.equals(CHARACTER_NAME) || type.equals(SHORT_NAME)) {
            datatype = (DataType)javaTypes.get(type);
        } else if (type.equals(STRING_NAME)) {
            datatype = new StringType();
        } else if (type.equals(VOID_NAME)) {
            datatype = new VoidType();
        } else if (type.equals(DOM_ELEMENT_NAME)) {
            datatype = new DomElementType();
        } else if (type.equals(SOAP_ELEMENT_NAME)) {
            datatype = new SOAPElementType();
        } else if (type.equals(BIG_DECIMAL_NAME)) {
            datatype = new BigDecimalType();
        } else if (type.equals(BIG_INTEGER_NAME)) {
            datatype = new BigIntegerType();
        } else if (type.equals(DATE_NAME)) {
            datatype = new DateType();
        } else if (type.equals(URL_NAME)) {
            datatype = new URLType();
        } else if (type.equals(GREGORIAN_CALENDAR_NAME)) {
            datatype = new GregorianCalendarType();
        } else if (type.equals(CALENDAR_NAME)) {
            datatype = new GregorianCalendarType();
        } else if (type.equals(HASHTABLE_NAME)) {
            datatype = new HashtableType();
        } else if (type.equals(VECTOR_NAME)) {
            datatype = new VectorType();
        } else if (type.equals(MAP_NAME)) {
            datatype = new MapType();
        } else if (type.equals(OBJECT_NAME)) {
            datatype = new ObjectType();
        } else if (type.startsWith(ARRAY_NAME)) {
            String name = type.substring(21);
            datatype = name.startsWith(PRIM_BOOLEAN_NAME) || name.startsWith(PRIM_BYTE_NAME) || name.startsWith(PRIM_DOUBLE_NAME) || name.startsWith(PRIM_FLOAT_NAME) || name.startsWith(PRIM_LONG_NAME) || name.startsWith(PRIM_INTEGER_NAME) || name.startsWith(PRIM_CHAR_NAME) || name.startsWith(PRIM_SHORT_NAME) ? new PrimitiveArrayType(name) : new ArrayType(name);
        } else if (stateless) {
            datatype = new StateLessBeanType(type);
        }
        datatype.setUniqueName(UniqueName);
        return datatype;
    }
}

