/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.axis.creation.ui.command;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.ServletType;
import org.eclipse.jst.j2ee.webapplication.WebType;
import org.eclipse.jst.j2ee.webapplication.WebapplicationFactory;
import org.eclipse.jst.javaee.core.DisplayName;
import org.eclipse.jst.javaee.core.JavaeeFactory;
import org.eclipse.jst.javaee.core.UrlPatternType;
import org.eclipse.jst.javaee.web.ServletMapping;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.javaee.web.WebFactory;
import org.eclipse.jst.ws.internal.axis.creation.ui.AxisCreationUIMessages;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class UpdateWEBXMLCommand
extends AbstractDataModelOperation {
    private IProject serverProject;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IEnvironment environment = this.getEnvironment();
        if (this.serverProject != null) {
            IStatus status = null;
            status = this.addServlet(this.serverProject, this.getAxisServletDescriptor());
            if (status.getSeverity() == 4) {
                environment.getStatusHandler().reportError(status);
                return status;
            }
            this.addServlet(this.serverProject, this.getAdmintServletDescriptor());
            if (status.getSeverity() == 4) {
                environment.getStatusHandler().reportError(status);
                return status;
            }
        }
        return Status.OK_STATUS;
    }

    private ServletDescriptor getAxisServletDescriptor() {
        ServletDescriptor sd = new ServletDescriptor();
        sd._name = "AxisServlet";
        sd._displayName = "Apache-Axis Servlet";
        sd._className = "org.apache.axis.transport.http.AxisServlet";
        sd._mappings = new String[]{"/servlet/AxisServlet", "*.jws", "/services/*"};
        return sd;
    }

    private ServletDescriptor getAdmintServletDescriptor() {
        ServletDescriptor sd = new ServletDescriptor();
        sd._name = "AdminServlet";
        sd._displayName = "Axis Admin Servlet";
        sd._className = "org.apache.axis.transport.http.AdminServlet";
        sd._mappings = new String[]{"/servlet/AdminServlet"};
        sd._loadOnStartup = new Integer(100);
        return sd;
    }

    public IStatus addServlet(final IProject webProject, final ServletDescriptor servletDescriptor) {
        try {
            final IModelProvider provider = ModelProviderManager.getModelProvider((IProject)webProject);
            provider.modify(new Runnable(){

                public void run() {
                    Object object = provider.getModelObject();
                    if (object instanceof WebApp) {
                        WebApp javaeeWebApp = (WebApp)object;
                        UpdateWEBXMLCommand.this.addJavaeeServlet(webProject, servletDescriptor, javaeeWebApp);
                    } else if (object instanceof org.eclipse.jst.j2ee.webapplication.WebApp) {
                        org.eclipse.jst.j2ee.webapplication.WebApp webApp = (org.eclipse.jst.j2ee.webapplication.WebApp)object;
                        UpdateWEBXMLCommand.this.addServlet(webProject, servletDescriptor, webApp);
                    }
                }
            }, null);
            return Status.OK_STATUS;
        }
        catch (Exception e) {
            return StatusUtils.errorStatus((String)AxisCreationUIMessages.MSG_ERROR_UPDATE_WEB_XML, (Throwable)e);
        }
    }

    private void addServlet(IProject webProject, ServletDescriptor servletDescriptor, org.eclipse.jst.j2ee.webapplication.WebApp webapp) {
        EList theServlets = webapp.getServlets();
        int i = 0;
        while (i < theServlets.size()) {
            Servlet aServlet = (Servlet)theServlets.get(i);
            if (aServlet.getServletName().equals(servletDescriptor._name)) {
                return;
            }
            ++i;
        }
        WebapplicationFactory factory = WebapplicationFactory.eINSTANCE;
        Servlet servlet = factory.createServlet();
        ServletType servletType = factory.createServletType();
        servlet.setWebType((WebType)servletType);
        servlet.setServletName(servletDescriptor._name);
        servletType.setClassName(servletDescriptor._className);
        if (servletDescriptor._displayName != null) {
            servlet.setDisplayName(servletDescriptor._displayName);
        }
        if (servletDescriptor._loadOnStartup != null) {
            servlet.setLoadOnStartup(servletDescriptor._loadOnStartup);
        }
        if (servletDescriptor._params != null) {
            Properties properties = servlet.getParamsAsProperties();
            properties.putAll((Map<?, ?>)servletDescriptor._params);
        }
        webapp.getServlets().add((Object)servlet);
        if (servletDescriptor._mappings != null) {
            int i2 = 0;
            while (i2 < servletDescriptor._mappings.length) {
                org.eclipse.jst.j2ee.webapplication.ServletMapping servletMapping = factory.createServletMapping();
                servletMapping.setServlet(servlet);
                servletMapping.setUrlPattern(servletDescriptor._mappings[i2]);
                webapp.getServletMappings().add((Object)servletMapping);
                ++i2;
            }
        }
    }

    private void addJavaeeServlet(IProject webProject, ServletDescriptor servletDescriptor, WebApp webapp) {
        List theServlets = webapp.getServlets();
        int i = 0;
        while (i < theServlets.size()) {
            org.eclipse.jst.javaee.web.Servlet aServlet = (org.eclipse.jst.javaee.web.Servlet)theServlets.get(i);
            if (aServlet.getServletName().equals(servletDescriptor._name)) {
                return;
            }
            ++i;
        }
        WebFactory factory = WebFactory.eINSTANCE;
        org.eclipse.jst.javaee.web.Servlet servlet = factory.createServlet();
        servlet.setServletName(servletDescriptor._name);
        servlet.setServletClass(servletDescriptor._className);
        if (servletDescriptor._displayName != null) {
            DisplayName displayNameObj = JavaeeFactory.eINSTANCE.createDisplayName();
            displayNameObj.setValue(servletDescriptor._displayName);
            servlet.getDisplayNames().add(displayNameObj);
        }
        if (servletDescriptor._loadOnStartup != null) {
            servlet.setLoadOnStartup((Object)servletDescriptor._loadOnStartup);
        }
        webapp.getServlets().add(servlet);
        if (servletDescriptor._mappings != null) {
            int i2 = 0;
            while (i2 < servletDescriptor._mappings.length) {
                ServletMapping servletMapping = factory.createServletMapping();
                servletMapping.setServletName(servlet.getServletName());
                UrlPatternType url = JavaeeFactory.eINSTANCE.createUrlPatternType();
                url.setValue(servletDescriptor._mappings[i2]);
                servletMapping.getUrlPatterns().add(url);
                webapp.getServletMappings().add(servletMapping);
                ++i2;
            }
        }
    }

    public void setServerProject(IProject serverProject) {
        this.serverProject = serverProject;
    }

    public class ServletDescriptor {
        String _name;
        String _className;
        String _displayName;
        Map _params;
        String[] _mappings;
        Integer _loadOnStartup;
    }
}

