/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.details;

import java.util.ArrayList;
import java.util.Collection;
import java.util.ListIterator;
import org.eclipse.jpt.core.context.GeneratedValue;
import org.eclipse.jpt.core.context.GenerationType;
import org.eclipse.jpt.core.context.IdMapping;
import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.ui.internal.details.JptUiDetailsMessages;
import org.eclipse.jpt.ui.internal.widgets.EnumFormComboViewer;
import org.eclipse.jpt.ui.internal.widgets.Pane;
import org.eclipse.jpt.utility.internal.ArrayTools;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.model.value.CompositeListValueModel;
import org.eclipse.jpt.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.utility.model.value.ListValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneratedValueComposite
extends Pane<IdMapping> {
    public GeneratedValueComposite(Pane<? extends IdMapping> parentPane, Composite parent) {
        super(parentPane, parent);
    }

    @Override
    protected void initializeLayout(Composite container) {
        this.addLabeledComposite(container, JptUiDetailsMessages.GeneratedValueComposite_strategy, this.addStrategyComboViewer(container), "org.eclipse.jpt.ui.mapping_generatedValueStrategy");
        this.addLabeledEditableCombo(container, JptUiDetailsMessages.GeneratedValueComposite_generatorName, this.buildGeneratorNameListHolder(), this.buildGeneratorNameHolder(), "org.eclipse.jpt.ui.mapping_generatedValueStrategy");
    }

    private EnumFormComboViewer<GeneratedValue, GenerationType> addStrategyComboViewer(Composite parent) {
        return new EnumFormComboViewer<GeneratedValue, GenerationType>((Pane)this, this.buildGeneratedValueHolder(), parent){

            @Override
            protected void addPropertyNames(Collection<String> propertyNames) {
                super.addPropertyNames(propertyNames);
                propertyNames.add("defaultStrategy");
                propertyNames.add("specifiedStrategy");
            }

            protected GenerationType[] getChoices() {
                return GenerationType.values();
            }

            @Override
            protected GenerationType getDefaultValue() {
                return ((GeneratedValue)this.getSubject()).getDefaultStrategy();
            }

            @Override
            protected String displayString(GenerationType value) {
                return this.buildDisplayString(JptUiDetailsMessages.class, GeneratedValueComposite.this, (Object)value);
            }

            @Override
            protected GenerationType getValue() {
                return ((GeneratedValue)this.getSubject()).getSpecifiedStrategy();
            }

            @Override
            protected void setValue(GenerationType value) {
                GeneratedValueComposite.this.retrieveGeneratedValue().setSpecifiedStrategy(value);
            }
        };
    }

    private PropertyValueModel<GeneratedValue> buildGeneratedValueHolder() {
        return new PropertyAspectAdapter<IdMapping, GeneratedValue>(this.getSubjectHolder(), new String[]{"generatedValue"}){

            protected GeneratedValue buildValue_() {
                return ((IdMapping)GeneratedValueComposite.this.getSubject()).getGeneratedValue();
            }
        };
    }

    protected final WritablePropertyValueModel<String> buildGeneratorNameHolder() {
        return new PropertyAspectAdapter<GeneratedValue, String>(this.buildGeneratedValueHolder(), new String[]{"specifiedGenerator"}){

            protected String buildValue_() {
                return ((GeneratedValue)this.subject).getSpecifiedGenerator();
            }

            public void setValue(String value) {
                if (this.subject != null) {
                    this.setValue_(value);
                    return;
                }
                if (value.length() == 0) {
                    return;
                }
                GeneratedValueComposite.this.retrieveGeneratedValue().setSpecifiedGenerator(value);
            }

            protected void setValue_(String value) {
                if (value.length() == 0) {
                    value = null;
                }
                ((GeneratedValue)this.subject).setSpecifiedGenerator(value);
            }
        };
    }

    protected ListValueModel<String> buildGeneratorNameListHolder() {
        ArrayList<4> list = new ArrayList<4>();
        list.add(new ListAspectAdapter<PersistenceUnit, String>(this.buildPersistenceUnitHolder(), new String[]{"generators"}){

            protected ListIterator<String> listIterator_() {
                return CollectionTools.listIterator((Object[])((String[])ArrayTools.sort((Object[])((PersistenceUnit)this.subject).uniqueGeneratorNames())));
            }
        });
        return new CompositeListValueModel(list);
    }

    protected PropertyValueModel<PersistenceUnit> buildPersistenceUnitHolder() {
        return new PropertyAspectAdapter<IdMapping, PersistenceUnit>(this.getSubjectHolder()){

            protected PersistenceUnit buildValue_() {
                return ((IdMapping)GeneratedValueComposite.this.getSubject()).getPersistenceUnit();
            }
        };
    }

    private GeneratedValue retrieveGeneratedValue() {
        GeneratedValue generatedValue = ((IdMapping)this.getSubject()).getGeneratedValue();
        if (generatedValue == null) {
            generatedValue = ((IdMapping)this.getSubject()).addGeneratedValue();
        }
        return generatedValue;
    }
}

