/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.swt;

import org.eclipse.jpt.ui.internal.swt.AbstractComboModelAdapter;
import org.eclipse.jpt.utility.internal.StringConverter;
import org.eclipse.jpt.utility.model.value.ListValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComboModelAdapter<E>
extends AbstractComboModelAdapter<E> {
    public static <T> ComboModelAdapter<T> adapt(ListValueModel<T> listHolder, WritablePropertyValueModel<T> selectedItemHolder, Combo combo) {
        return ComboModelAdapter.adapt(listHolder, selectedItemHolder, combo, StringConverter.Default.instance());
    }

    public static <T> ComboModelAdapter<T> adapt(ListValueModel<T> listHolder, WritablePropertyValueModel<T> selectedItemHolder, Combo combo, StringConverter<T> stringConverter) {
        return new ComboModelAdapter<T>(listHolder, selectedItemHolder, combo, stringConverter);
    }

    protected ComboModelAdapter(ListValueModel<E> listHolder, WritablePropertyValueModel<E> selectedItemHolder, Combo combo, StringConverter<E> stringConverter) {
        super(listHolder, selectedItemHolder, new SWTComboHolder(combo), stringConverter);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SWTComboHolder
    implements AbstractComboModelAdapter.ComboHolder {
        private final Combo combo;
        private final boolean editable;
        private String selectedItem;

        SWTComboHolder(Combo combo) {
            this.combo = combo;
            this.editable = (combo.getStyle() & 8) == 0;
        }

        @Override
        public void add(String item, int index) {
            this.combo.add(item, index);
            if (this.selectedItem != null && this.selectedItem.equals(item)) {
                this.setText(this.selectedItem);
                this.selectedItem = null;
            }
        }

        @Override
        public void addDisposeListener(DisposeListener disposeListener) {
            this.combo.addDisposeListener(disposeListener);
        }

        @Override
        public void addModifyListener(ModifyListener modifyListener) {
            this.combo.addModifyListener(modifyListener);
        }

        @Override
        public void addSelectionListener(SelectionListener selectionListener) {
            this.combo.addSelectionListener(selectionListener);
        }

        @Override
        public void deselectAll() {
            this.combo.deselectAll();
        }

        @Override
        public int getItemCount() {
            return this.combo.getItemCount();
        }

        @Override
        public String[] getItems() {
            return this.combo.getItems();
        }

        @Override
        public int getSelectionIndex() {
            return this.combo.getSelectionIndex();
        }

        @Override
        public String getText() {
            return this.combo.getText();
        }

        @Override
        public boolean isDisposed() {
            return this.combo.isDisposed();
        }

        @Override
        public boolean isEditable() {
            return this.editable;
        }

        @Override
        public boolean isPopulating() {
            return this.combo.getData("populating") == Boolean.TRUE;
        }

        @Override
        public void remove(int start, int end) {
            this.combo.remove(start, end);
        }

        @Override
        public void removeAll() {
            this.combo.removeAll();
        }

        @Override
        public void removeDisposeListener(DisposeListener disposeListener) {
            this.combo.removeDisposeListener(disposeListener);
        }

        @Override
        public void removeModifyListener(ModifyListener modifyListener) {
            this.combo.removeModifyListener(modifyListener);
        }

        @Override
        public void removeSelectionListener(SelectionListener selectionListener) {
            this.combo.removeSelectionListener(selectionListener);
        }

        @Override
        public void setItem(int index, String item) {
            this.combo.setItem(index, item);
        }

        @Override
        public void setItems(String[] items) {
            this.combo.setItems(items);
        }

        @Override
        public void setPopulating(boolean populating) {
            this.combo.setData("populating", (Object)populating);
        }

        @Override
        public void setText(String item) {
            this.selectedItem = this.combo.getItemCount() == 0 ? item : null;
            this.combo.setText(item);
        }
    }
}

