/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jpt.core.context.AttributeMapping;
import org.eclipse.jpt.core.context.Column;
import org.eclipse.jpt.core.context.ColumnMapping;
import org.eclipse.jpt.core.context.PersistentType;
import org.eclipse.jpt.core.context.RelationshipMapping;
import org.eclipse.jpt.core.context.RelationshipReference;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.context.orm.EntityMappings;
import org.eclipse.jpt.core.context.orm.OrmAttributeMapping;
import org.eclipse.jpt.core.context.orm.OrmBaseEmbeddedMapping;
import org.eclipse.jpt.core.context.orm.OrmBasicMapping;
import org.eclipse.jpt.core.context.orm.OrmColumnMapping;
import org.eclipse.jpt.core.context.orm.OrmEmbeddedIdMapping;
import org.eclipse.jpt.core.context.orm.OrmEmbeddedMapping;
import org.eclipse.jpt.core.context.orm.OrmIdMapping;
import org.eclipse.jpt.core.context.orm.OrmManyToManyMapping;
import org.eclipse.jpt.core.context.orm.OrmManyToOneMapping;
import org.eclipse.jpt.core.context.orm.OrmMultiRelationshipMapping;
import org.eclipse.jpt.core.context.orm.OrmOneToManyMapping;
import org.eclipse.jpt.core.context.orm.OrmOneToOneMapping;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmRelationshipMapping;
import org.eclipse.jpt.core.context.orm.OrmSingleRelationshipMapping;
import org.eclipse.jpt.core.context.orm.OrmTransientMapping;
import org.eclipse.jpt.core.context.orm.OrmTypeMapping;
import org.eclipse.jpt.core.context.orm.OrmVersionMapping;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmXmlContextNode;
import org.eclipse.jpt.core.internal.jpa2.context.SimpleMetamodelField;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.jpa2.context.AttributeMapping2_0;
import org.eclipse.jpt.core.jpa2.context.MetamodelField;
import org.eclipse.jpt.core.jpa2.context.orm.OrmPersistentAttribute2_0;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.orm.XmlAttributeMapping;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.utility.internal.iterators.SingleElementIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrmAttributeMapping<T extends XmlAttributeMapping>
extends AbstractOrmXmlContextNode
implements OrmAttributeMapping,
AttributeMapping2_0 {
    protected String name;
    protected final T resourceAttributeMapping;

    protected AbstractOrmAttributeMapping(OrmPersistentAttribute parent, T resourceAttributeMapping) {
        super(parent);
        this.resourceAttributeMapping = resourceAttributeMapping;
        this.name = this.getResourceMappingName();
    }

    protected JavaPersistentAttribute getJavaPersistentAttribute() {
        return this.getPersistentAttribute().getJavaPersistentAttribute();
    }

    protected JavaResourcePersistentAttribute getJavaResourcePersistentAttribute() {
        return this.getJavaPersistentAttribute().getResourcePersistentAttribute();
    }

    public boolean isVirtual() {
        return this.getPersistentAttribute().isVirtual();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        String old = this.name;
        this.name = name;
        this.resourceAttributeMapping.setName(name);
        this.firePropertyChanged("name", old, name);
        this.getPersistentAttribute().nameChanged(old, name);
    }

    protected void setName_(String name) {
        String old = this.name;
        this.name = name;
        this.firePropertyChanged("name", old, name);
        this.getPersistentAttribute().nameChanged(old, name);
    }

    @Override
    public OrmPersistentAttribute getPersistentAttribute() {
        return (OrmPersistentAttribute)this.getParent();
    }

    protected EntityMappings getEntityMappings() {
        return this.getPersistentAttribute().getOwningPersistentType().getParent();
    }

    protected PersistentType resolvePersistentType(String className) {
        return this.getEntityMappings().resolvePersistentType(className);
    }

    @Override
    public boolean isDefault() {
        return false;
    }

    @Override
    public void initializeFromOrmAttributeMapping(OrmAttributeMapping oldMapping) {
        this.setName(oldMapping.getName());
    }

    public void initializeFromOrmColumnMapping(OrmColumnMapping oldMapping) {
        this.initializeFromOrmAttributeMapping((OrmAttributeMapping)((Object)oldMapping));
    }

    @Override
    public void initializeFromOrmBasicMapping(OrmBasicMapping oldMapping) {
        this.initializeFromOrmColumnMapping(oldMapping);
    }

    @Override
    public void initializeFromOrmIdMapping(OrmIdMapping oldMapping) {
        this.initializeFromOrmColumnMapping(oldMapping);
    }

    @Override
    public void initializeFromOrmTransientMapping(OrmTransientMapping oldMapping) {
        this.initializeFromOrmAttributeMapping(oldMapping);
    }

    public void initializeFromOrmBaseEmbeddedMapping(OrmBaseEmbeddedMapping oldMapping) {
        this.initializeFromOrmAttributeMapping(oldMapping);
    }

    @Override
    public void initializeFromOrmEmbeddedMapping(OrmEmbeddedMapping oldMapping) {
        this.initializeFromOrmBaseEmbeddedMapping(oldMapping);
    }

    @Override
    public void initializeFromOrmEmbeddedIdMapping(OrmEmbeddedIdMapping oldMapping) {
        this.initializeFromOrmBaseEmbeddedMapping(oldMapping);
    }

    @Override
    public void initializeFromOrmVersionMapping(OrmVersionMapping oldMapping) {
        this.initializeFromOrmColumnMapping(oldMapping);
    }

    public void initializeFromOrmRelationshipMapping(OrmRelationshipMapping oldMapping) {
        this.initializeFromOrmAttributeMapping(oldMapping);
    }

    public void initializeFromOrmMultiRelationshipMapping(OrmMultiRelationshipMapping oldMapping) {
        this.initializeFromOrmRelationshipMapping(oldMapping);
    }

    public void initializeFromOrmSingleRelationshipMapping(OrmSingleRelationshipMapping oldMapping) {
        this.initializeFromOrmRelationshipMapping(oldMapping);
    }

    @Override
    public void initializeFromOrmOneToManyMapping(OrmOneToManyMapping oldMapping) {
        this.initializeFromOrmMultiRelationshipMapping(oldMapping);
    }

    @Override
    public void initializeFromOrmManyToOneMapping(OrmManyToOneMapping oldMapping) {
        this.initializeFromOrmSingleRelationshipMapping(oldMapping);
    }

    @Override
    public void initializeFromOrmOneToOneMapping(OrmOneToOneMapping oldMapping) {
        this.initializeFromOrmSingleRelationshipMapping(oldMapping);
    }

    @Override
    public void initializeFromOrmManyToManyMapping(OrmManyToManyMapping oldMapping) {
        this.initializeFromOrmMultiRelationshipMapping(oldMapping);
    }

    @Override
    public String getPrimaryKeyColumnName() {
        return null;
    }

    @Override
    public OrmTypeMapping getTypeMapping() {
        return this.getPersistentAttribute().getOwningTypeMapping();
    }

    @Override
    public boolean isOverridableAttributeMapping() {
        return false;
    }

    @Override
    public boolean isOverridableAssociationMapping() {
        return false;
    }

    @Override
    public boolean isRelationshipOwner() {
        return false;
    }

    @Override
    public boolean isOwnedBy(AttributeMapping mapping) {
        return false;
    }

    @Override
    public Iterator<String> allMappingNames() {
        return this.getName() == null ? EmptyIterator.instance() : new SingleElementIterator((Object)this.getName());
    }

    @Override
    public AttributeMapping resolveAttributeMapping(String attributeName) {
        if (this.getName() != null && this.getName().equals(attributeName)) {
            return this;
        }
        return null;
    }

    @Override
    public Iterator<String> allOverrideableAttributeMappingNames() {
        if (this.isOverridableAttributeMapping() && this.getName() != null) {
            return new SingleElementIterator((Object)this.getName());
        }
        return EmptyIterator.instance();
    }

    @Override
    public Iterator<String> allOverrideableAssociationMappingNames() {
        if (this.isOverridableAssociationMapping() && this.getName() != null) {
            return new SingleElementIterator((Object)this.getName());
        }
        return EmptyIterator.instance();
    }

    @Override
    public Column resolveOverriddenColumn(String attributeName) {
        ColumnMapping columnMapping = this.resolveColumnMapping(attributeName);
        return columnMapping == null ? null : columnMapping.getColumn();
    }

    protected ColumnMapping resolveColumnMapping(String attributeName) {
        AttributeMapping attributeMapping = this.resolveAttributeMapping(attributeName);
        if (attributeMapping != null && attributeMapping.isOverridableAttributeMapping()) {
            return (ColumnMapping)attributeMapping;
        }
        return null;
    }

    @Override
    public RelationshipReference resolveRelationshipReference(String attributeName) {
        RelationshipMapping relationshipMapping = this.resolveRelationshipMapping(attributeName);
        return relationshipMapping == null ? null : relationshipMapping.getRelationshipReference();
    }

    protected RelationshipMapping resolveRelationshipMapping(String attributeName) {
        AttributeMapping attributeMapping = this.resolveAttributeMapping(attributeName);
        if (attributeMapping != null && attributeMapping.isOverridableAssociationMapping()) {
            return (RelationshipMapping)attributeMapping;
        }
        return null;
    }

    public T getResourceAttributeMapping() {
        return this.resourceAttributeMapping;
    }

    @Override
    public void update() {
        this.setName_(this.getResourceMappingName());
    }

    protected String getResourceMappingName() {
        return this.resourceAttributeMapping.getName();
    }

    @Override
    public boolean shouldValidateAgainstDatabase() {
        return this.getTypeMapping().shouldValidateAgainstDatabase();
    }

    @Override
    public boolean contains(int textOffset) {
        return this.resourceAttributeMapping.containsOffset(textOffset);
    }

    @Override
    public TextRange getSelectionTextRange() {
        return this.resourceAttributeMapping.getSelectionTextRange();
    }

    @Override
    public TextRange getValidationTextRange() {
        return this.getPersistentAttribute().isVirtual() ? this.getTypeMapping().getAttributesTextRange() : this.resourceAttributeMapping.getValidationTextRange();
    }

    @Override
    public TextRange getNameTextRange() {
        return this.resourceAttributeMapping.getNameTextRange();
    }

    public void toString(StringBuilder sb) {
        sb.append(this.getName());
    }

    @Override
    public MetamodelField getMetamodelField() {
        String metamodelFieldName = this.getMetamodelFieldName();
        return metamodelFieldName == null ? null : new SimpleMetamodelField(this.getMetamodelFieldModifiers(), this.getMetamodelFieldTypeName(), this.getMetamodelFieldTypeArgumentNames(), metamodelFieldName);
    }

    protected Iterable<String> getMetamodelFieldModifiers() {
        return STANDARD_METAMODEL_FIELD_MODIFIERS;
    }

    protected String getMetamodelFieldTypeName() {
        return "javax.persistence.metamodel.SingularAttribute";
    }

    protected final Iterable<String> getMetamodelFieldTypeArgumentNames() {
        ArrayList<String> typeArgumentNames = new ArrayList<String>(3);
        typeArgumentNames.add(this.getTypeMapping().getPersistentType().getName());
        this.addMetamodelFieldTypeArgumentNamesTo(typeArgumentNames);
        return typeArgumentNames;
    }

    protected void addMetamodelFieldTypeArgumentNamesTo(ArrayList<String> typeArgumentNames) {
        typeArgumentNames.add(this.getMetamodelTypeName());
    }

    @Override
    public String getMetamodelTypeName() {
        return ((OrmPersistentAttribute2_0)this.getPersistentAttribute()).getMetamodelTypeName();
    }

    protected String getMetamodelFieldName() {
        return this.getName();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateAttribute(messages);
        this.validateMapping(messages);
    }

    protected void validateAttribute(List<IMessage> messages) {
        if (StringTools.stringIsEmpty((String)this.name)) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "PERSISTENT_ATTRIBUTE_UNSPECIFIED_NAME", this, this.getValidationTextRange()));
            return;
        }
    }

    protected void validateMapping(List<IMessage> messages) {
        if (!this.getTypeMapping().attributeMappingKeyAllowed(this.getKey())) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "PERSISTENT_ATTRIBUTE_INVALID_MAPPING", new String[]{this.name}, this, this.getValidationTextRange()));
        }
    }
}

