/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.actions;

import java.util.ResourceBundle;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.editors.text.TextEditorActionContributor;
import org.eclipse.ui.texteditor.IStatusField;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorExtension;
import org.eclipse.ui.texteditor.RetargetTextEditorAction;
import org.eclipse.wst.sse.ui.internal.ExtendedEditorActionBuilder;
import org.eclipse.wst.sse.ui.internal.GotoAnnotationAction;
import org.eclipse.wst.sse.ui.internal.IExtendedContributor;
import org.eclipse.wst.sse.ui.internal.ISourceViewerActionBarContributor;
import org.eclipse.wst.sse.ui.internal.SSEUIMessages;
import org.eclipse.wst.sse.ui.internal.ui.OffsetStatusLineContributionItem;

public class ActionContributor
extends TextEditorActionContributor
implements ISourceViewerActionBarContributor,
IExtendedContributor {
    public static final boolean _showDebugStatus = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.wst.sse.ui/actioncontributor/debugstatusfields")) || Platform.inDebugMode() || Platform.inDevelopmentMode();
    private static final String[] EDITOR_IDS = new String[]{"org.eclipse.wst.sse.ui.StructuredTextEditor"};
    protected IExtendedContributor extendedContributor;
    protected RetargetTextEditorAction fAddBlockComment = null;
    protected Separator fCommandsSeparator = null;
    private OffsetStatusLineContributionItem fDebugStatusOffset = null;
    protected MenuManager fExpandSelectionToMenu = null;
    protected GroupMarker fMenuAdditionsGroupMarker = null;
    protected GotoAnnotationAction fNextAnnotation = null;
    protected GotoAnnotationAction fPreviousAnnotation = null;
    protected RetargetTextEditorAction fRemoveBlockComment = null;
    protected RetargetTextEditorAction fShiftLeft = null;
    protected RetargetTextEditorAction fShiftRight = null;
    protected RetargetTextEditorAction fStructureSelectEnclosingAction = null;
    protected RetargetTextEditorAction fStructureSelectHistoryAction = null;
    protected RetargetTextEditorAction fStructureSelectNextAction = null;
    protected RetargetTextEditorAction fStructureSelectPreviousAction = null;
    protected RetargetTextEditorAction fToggleComment = null;
    protected RetargetTextEditorAction fToggleInsertModeAction;
    protected GroupMarker fToolbarAdditionsGroupMarker = null;
    protected Separator fToolbarSeparator = null;
    protected RetargetTextEditorAction fGotoMatchingBracketAction = null;
    static /* synthetic */ Class class$0;

    public ActionContributor() {
        ResourceBundle resourceBundle = SSEUIMessages.getResourceBundle();
        this.fCommandsSeparator = new Separator();
        this.fStructureSelectEnclosingAction = new RetargetTextEditorAction(resourceBundle, "StructureSelectEnclosing_");
        this.fStructureSelectEnclosingAction.setActionDefinitionId("org.eclipse.wst.sse.ui.structure.select.enclosing");
        this.fStructureSelectNextAction = new RetargetTextEditorAction(resourceBundle, "StructureSelectNext_");
        this.fStructureSelectNextAction.setActionDefinitionId("org.eclipse.wst.sse.ui.structure.select.next");
        this.fStructureSelectPreviousAction = new RetargetTextEditorAction(resourceBundle, "StructureSelectPrevious_");
        this.fStructureSelectPreviousAction.setActionDefinitionId("org.eclipse.wst.sse.ui.structure.select.previous");
        this.fStructureSelectHistoryAction = new RetargetTextEditorAction(resourceBundle, "StructureSelectHistory_");
        this.fStructureSelectHistoryAction.setActionDefinitionId("org.eclipse.wst.sse.ui.structure.select.last");
        this.fExpandSelectionToMenu = new MenuManager(SSEUIMessages.ExpandSelectionToMenu_label);
        this.fExpandSelectionToMenu.add((IAction)this.fStructureSelectEnclosingAction);
        this.fExpandSelectionToMenu.add((IAction)this.fStructureSelectNextAction);
        this.fExpandSelectionToMenu.add((IAction)this.fStructureSelectPreviousAction);
        this.fExpandSelectionToMenu.add((IAction)this.fStructureSelectHistoryAction);
        this.fShiftRight = new RetargetTextEditorAction(resourceBundle, "ShiftRight_");
        this.fShiftRight.setActionDefinitionId("org.eclipse.ui.edit.text.shiftRight");
        this.fShiftLeft = new RetargetTextEditorAction(resourceBundle, "ShiftLeft_");
        this.fShiftLeft.setActionDefinitionId("org.eclipse.ui.edit.text.shiftLeft");
        this.fToggleComment = new RetargetTextEditorAction(resourceBundle, "ToggleComment_");
        this.fToggleComment.setActionDefinitionId("org.eclipse.wst.sse.ui.toggle.comment");
        this.fAddBlockComment = new RetargetTextEditorAction(resourceBundle, "AddBlockComment_");
        this.fAddBlockComment.setActionDefinitionId("org.eclipse.wst.sse.ui.add.block.comment");
        this.fRemoveBlockComment = new RetargetTextEditorAction(resourceBundle, "RemoveBlockComment_");
        this.fRemoveBlockComment.setActionDefinitionId("org.eclipse.wst.sse.ui.remove.block.comment");
        this.fPreviousAnnotation = new GotoAnnotationAction("Previous_annotation", false);
        this.fPreviousAnnotation.setActionDefinitionId("org.eclipse.ui.navigate.previous");
        this.fNextAnnotation = new GotoAnnotationAction("Next_annotation", true);
        this.fNextAnnotation.setActionDefinitionId("org.eclipse.ui.navigate.next");
        this.fGotoMatchingBracketAction = new RetargetTextEditorAction(resourceBundle, "GotoMatchingBracket_");
        this.fGotoMatchingBracketAction.setActionDefinitionId("org.eclipse.wst.sse.ui.goto.matching.bracket");
        ExtendedEditorActionBuilder builder = new ExtendedEditorActionBuilder();
        this.extendedContributor = builder.readActionExtensions(this.getExtensionIDs());
        this.fMenuAdditionsGroupMarker = new GroupMarker("MenuAdditions");
        this.fToolbarSeparator = new Separator();
        this.fToolbarAdditionsGroupMarker = new GroupMarker("ToolbarAdditions");
        this.fToggleInsertModeAction = new RetargetTextEditorAction(resourceBundle, "Editor.ToggleInsertMode.", 2);
        this.fToggleInsertModeAction.setActionDefinitionId("org.eclipse.ui.edit.text.toggleInsertMode");
        if (_showDebugStatus) {
            this.fDebugStatusOffset = new OffsetStatusLineContributionItem("Offset", true, 20);
        }
    }

    protected void addToMenu(IMenuManager menu) {
    }

    protected void addToPopupMenu(IMenuManager menu) {
    }

    protected void addToStatusLine(IStatusLineManager manager) {
        if (_showDebugStatus) {
            manager.add((IContributionItem)this.fDebugStatusOffset);
        }
    }

    protected void addToToolBar(IToolBarManager toolBarManager) {
    }

    public void contributeToMenu(IMenuManager menu) {
        super.contributeToMenu(menu);
        IMenuManager editMenu = menu.findMenuUsingPath("edit");
        if (editMenu != null) {
            editMenu.appendToGroup("additions", (IAction)this.fToggleInsertModeAction);
        }
        if (this.extendedContributor != null) {
            this.extendedContributor.contributeToMenu(menu);
        }
    }

    public void contributeToPopupMenu(IMenuManager menu) {
        if (this.extendedContributor != null) {
            this.extendedContributor.contributeToPopupMenu(menu);
        }
    }

    public void contributeToStatusLine(IStatusLineManager manager) {
        super.contributeToStatusLine(manager);
        this.addToStatusLine(manager);
        if (this.extendedContributor != null) {
            this.extendedContributor.contributeToStatusLine(manager);
        }
    }

    public void contributeToToolBar(IToolBarManager toolBarManager) {
        super.contributeToToolBar(toolBarManager);
        if (this.extendedContributor != null) {
            this.extendedContributor.contributeToToolBar(toolBarManager);
        }
    }

    public void dispose() {
        this.setActiveEditor(null);
        super.dispose();
        if (this.extendedContributor != null) {
            this.extendedContributor.dispose();
        }
    }

    protected String[] getExtensionIDs() {
        return EDITOR_IDS;
    }

    protected ITextEditor getTextEditor(IEditorPart editor) {
        ITextEditor textEditor = null;
        if (editor instanceof ITextEditor) {
            textEditor = (ITextEditor)editor;
        }
        if (textEditor == null && editor != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.texteditor.ITextEditor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            textEditor = (ITextEditor)editor.getAdapter((Class)clazz);
        }
        return textEditor;
    }

    public void init(IActionBars bars, IWorkbenchPage page) {
        super.init(bars, page);
    }

    public void setActiveEditor(IEditorPart activeEditor) {
        if (this.getActiveEditorPart() == activeEditor) {
            return;
        }
        super.setActiveEditor(activeEditor);
        ITextEditor textEditor = this.getTextEditor(activeEditor);
        this.fToggleInsertModeAction.setAction(this.getAction(textEditor, "TOGGLE_INSERT_MODE"));
        if (this.extendedContributor != null) {
            this.extendedContributor.setActiveEditor(activeEditor);
        }
        if (_showDebugStatus && textEditor instanceof ITextEditorExtension) {
            ((ITextEditorExtension)textEditor).setStatusField((IStatusField)this.fDebugStatusOffset, "Offset");
            this.fDebugStatusOffset.setActiveEditor(textEditor);
        }
    }

    public void setViewerSpecificContributionsEnabled(boolean enabled) {
        this.fToggleInsertModeAction.setEnabled(enabled);
    }

    public void updateToolbarActions() {
        if (this.extendedContributor != null) {
            this.extendedContributor.updateToolbarActions();
        }
    }
}

