/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.rhino.debugger;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.wst.jsdt.debug.internal.rhino.debugger.RequestHandler;
import org.eclipse.wst.jsdt.debug.internal.rhino.debugger.RhinoDebuggerImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.EventPacket;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.RhinoRequest;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.RhinoResponse;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.RhinoTransportService;
import org.eclipse.wst.jsdt.debug.transport.Connection;
import org.eclipse.wst.jsdt.debug.transport.DebugSession;
import org.eclipse.wst.jsdt.debug.transport.ListenerKey;
import org.eclipse.wst.jsdt.debug.transport.TransportService;
import org.eclipse.wst.jsdt.debug.transport.exception.DisconnectedException;
import org.eclipse.wst.jsdt.debug.transport.exception.TimeoutException;
import org.eclipse.wst.jsdt.debug.transport.packet.Packet;

public class DebugSessionManager {
    private static boolean DEBUG = false;
    private static final String ADDRESS = "address";
    private static final String SOCKET = "socket";
    private static final String TRANSPORT = "transport";
    private final TransportService transportService;
    private final String address;
    private final boolean startSuspended;
    private DebugSession debugSession;
    private Thread debuggerThread;
    private volatile boolean shutdown = false;

    public DebugSessionManager(TransportService transportService, String address, boolean startSuspended, boolean debug) {
        this.transportService = transportService;
        this.address = address;
        this.startSuspended = startSuspended;
        DEBUG = debug;
    }

    static DebugSessionManager create(String configString) {
        Map config = DebugSessionManager.parseConfigString(configString);
        String transport = (String)config.get(TRANSPORT);
        if (!SOCKET.equals(transport)) {
            throw new IllegalArgumentException("Transport service must be 'socket': " + transport);
        }
        RhinoTransportService parsedTransportService = new RhinoTransportService();
        String parsedAddress = (String)config.get(ADDRESS);
        String suspend = (String)config.get("suspend");
        boolean parsedStartSuspended = false;
        if (suspend != null) {
            parsedStartSuspended = Boolean.valueOf(suspend) != false || suspend.trim().equalsIgnoreCase("y");
        }
        String debug = (String)config.get("trace");
        boolean debugging = false;
        if (debug != null) {
            debugging = Boolean.valueOf(debug) != false || debug.trim().equalsIgnoreCase("y");
        }
        return new DebugSessionManager((TransportService)parsedTransportService, parsedAddress, parsedStartSuspended, debugging);
    }

    private static Map parseConfigString(String configString) {
        HashMap<String, String> config = new HashMap<String, String>();
        StringTokenizer tokenizer = new StringTokenizer(configString, ",");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            int equalsIndex = token.indexOf(61);
            if (equalsIndex == -1) {
                config.put(token, null);
                continue;
            }
            config.put(token.substring(0, equalsIndex), token.substring(equalsIndex + 1));
        }
        return config;
    }

    public boolean isStartSuspended() {
        return this.startSuspended;
    }

    public synchronized boolean isConnected() {
        return this.debugSession != null;
    }

    public synchronized void start(RhinoDebuggerImpl debugger) {
        this.debuggerThread = new DebugSessionThread("RhinoDebugger - RhinoRequest Handler", debugger);
        this.debuggerThread.start();
        if (this.startSuspended) {
            try {
                this.wait(300000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public synchronized void stop() {
        this.shutdown = true;
        try {
            this.debuggerThread.interrupt();
            while (this.debuggerThread.isAlive()) {
                this.wait(1000L);
            }
            this.debuggerThread.join();
        }
        catch (InterruptedException interruptedException) {}
    }

    private synchronized void setDebugSession(DebugSession session) {
        if (this.debugSession != session) {
            if (this.debugSession != null) {
                this.debugSession.dispose();
            }
            this.debugSession = session;
            this.notify();
        }
    }

    public synchronized boolean sendEvent(EventPacket event) {
        try {
            if (this.debugSession != null) {
                if (DEBUG) {
                    System.out.println(event);
                }
                this.debugSession.send((Packet)event);
                return true;
            }
        }
        catch (DisconnectedException e) {
            e.printStackTrace();
        }
        return false;
    }

    private void sendDeathEvent() {
        EventPacket event = new EventPacket("vmdeath");
        this.sendEvent(event);
    }

    public class DebugSessionThread
    extends Thread {
        private ListenerKey listenerKey;
        private Connection connection;
        private RequestHandler requestHandler;

        public DebugSessionThread(String name, RhinoDebuggerImpl debugger) {
            super(name);
            this.requestHandler = new RequestHandler(debugger);
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                try {
                    this.listenerKey = DebugSessionManager.this.transportService.startListening(DebugSessionManager.this.address);
                    while (!DebugSessionManager.this.shutdown) {
                        try {
                            this.acceptConnection(10000L);
                        }
                        catch (IOException iOException) {
                            if (this.connection == null) continue;
                        }
                        while (!DebugSessionManager.this.shutdown && this.connection.isOpen()) {
                            try {
                                RhinoRequest request = (RhinoRequest)DebugSessionManager.this.debugSession.receive("request", 1000);
                                if (DEBUG) {
                                    System.out.println(request);
                                }
                                RhinoResponse response = this.requestHandler.handleRequest(request);
                                if (DEBUG) {
                                    System.out.println(response);
                                }
                                DebugSessionManager.this.debugSession.send((Packet)response);
                                continue;
                            }
                            catch (TimeoutException timeoutException) {
                                continue;
                            }
                            catch (DisconnectedException disconnectedException) {}
                            break;
                        }
                        this.closeConnection();
                    }
                }
                catch (IOException iOException) {
                    DebugSessionManager.this.sendDeathEvent();
                }
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                try {
                    if (this.listenerKey == null) throw throwable;
                    DebugSessionManager.this.transportService.stopListening(this.listenerKey);
                    throw throwable;
                }
                catch (IOException iOException) {
                    DebugSessionManager.this.sendDeathEvent();
                }
                throw throwable;
            }
            {
                Object var3_5 = null;
            }
            try {}
            catch (IOException iOException) {
                DebugSessionManager.this.sendDeathEvent();
                return;
            }
            if (this.listenerKey == null) return;
            DebugSessionManager.this.transportService.stopListening(this.listenerKey);
        }

        private void closeConnection() throws IOException {
            if (this.connection != null) {
                DebugSessionManager.this.setDebugSession(null);
                this.connection.close();
                this.connection = null;
            }
        }

        private void acceptConnection(long timeout) throws IOException {
            if (this.connection == null) {
                this.connection = DebugSessionManager.this.transportService.accept(this.listenerKey, timeout, timeout);
                DebugSessionManager.this.setDebugSession(new DebugSession(this.connection));
            }
        }
    }
}

