/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.frameworks.internal.operations;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.common.frameworks.internal.enablement.EnablementManager;
import org.eclipse.wst.common.frameworks.internal.operations.OperationExtension;
import org.eclipse.wst.common.frameworks.internal.operations.OperationExtensionReader;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;

public class ComposedExtendedOperationHolder {
    private ArrayList preOps = null;
    private ArrayList postOps = null;

    protected ComposedExtendedOperationHolder() {
    }

    public static ComposedExtendedOperationHolder createExtendedOperationHolder(String operationID) {
        Collection extensions = (Collection)OperationExtensionReader.getExtensionPoints().get(operationID);
        if (extensions == null) {
            return null;
        }
        ComposedExtendedOperationHolder extOperationHolder = new ComposedExtendedOperationHolder();
        Object preOp = null;
        Object postOp = null;
        OperationExtension currentExt2 = null;
        for (OperationExtension currentExt2 : extensions) {
            if (!EnablementManager.INSTANCE.getIdentifier(currentExt2.getExtensionId(), null).isEnabled()) continue;
            try {
                preOp = currentExt2.getPreOperation();
                if (preOp != null) {
                    extOperationHolder.addPreOperation(preOp);
                }
            }
            catch (CoreException e) {
                WTPCommonPlugin.logError(e);
            }
            try {
                postOp = currentExt2.getPostOperation();
                if (postOp == null) continue;
                extOperationHolder.addPostOperation(postOp);
            }
            catch (CoreException e) {
                WTPCommonPlugin.logError(e);
            }
        }
        return extOperationHolder;
    }

    protected void addPreOperation(Object preOperation) {
        if (this.preOps == null) {
            this.preOps = new ArrayList();
        }
        this.preOps.add(preOperation);
    }

    protected void addPostOperation(Object postOperation) {
        if (this.postOps == null) {
            this.postOps = new ArrayList();
        }
        this.postOps.add(postOperation);
    }

    public boolean hasPreOps() {
        return this.preOps != null;
    }

    public boolean hasPostOps() {
        return this.postOps != null;
    }

    public ArrayList getPostOps() {
        return this.postOps;
    }

    public ArrayList getPreOps() {
        return this.preOps;
    }
}

