/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.details;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jpt.core.context.Entity;
import org.eclipse.jpt.core.context.SecondaryTable;
import org.eclipse.jpt.ui.WidgetFactory;
import org.eclipse.jpt.ui.internal.details.JptUiDetailsMessages;
import org.eclipse.jpt.ui.internal.details.SecondaryTableDialog;
import org.eclipse.jpt.ui.internal.widgets.AddRemovePane;
import org.eclipse.jpt.ui.internal.widgets.Pane;
import org.eclipse.jpt.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.swing.ObjectListSelectionModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSecondaryTablesComposite<T extends Entity>
extends Pane<T> {
    public AbstractSecondaryTablesComposite(Pane<? extends T> parentPane, Composite parent) {
        super(parentPane, parent, false);
    }

    public AbstractSecondaryTablesComposite(PropertyValueModel<? extends T> subjectHolder, Composite parent, WidgetFactory widgetFactory) {
        super(subjectHolder, parent, widgetFactory);
    }

    protected void addSecondaryTableFromDialog(SecondaryTableDialog dialog, ObjectListSelectionModel listSelectionModel) {
        if (dialog.open() != 0) {
            return;
        }
        SecondaryTable secondaryTable = ((Entity)this.getSubject()).addSpecifiedSecondaryTable();
        secondaryTable.setSpecifiedName(dialog.getSelectedTable());
        secondaryTable.setSpecifiedCatalog(dialog.getSelectedCatalog());
        secondaryTable.setSpecifiedSchema(dialog.getSelectedSchema());
        listSelectionModel.setSelectedValue((Object)secondaryTable);
    }

    protected WritablePropertyValueModel<SecondaryTable> buildSecondaryTableHolder() {
        return new SimplePropertyValueModel();
    }

    protected ILabelProvider buildSecondaryTableLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                SecondaryTable secondaryTable = (SecondaryTable)element;
                if (secondaryTable.getName() != null) {
                    return secondaryTable.getName();
                }
                return "";
            }
        };
    }

    protected SecondaryTableDialog buildSecondaryTableDialogForAdd() {
        return new SecondaryTableDialog(this.getShell(), ((Entity)this.getSubject()).getJpaProject(), ((Entity)this.getSubject()).getTable().getDefaultCatalog(), ((Entity)this.getSubject()).getTable().getDefaultSchema());
    }

    protected AddRemovePane.Adapter buildSecondaryTablesAdapter() {
        return new AddRemovePane.AbstractAdapter(){

            @Override
            public void addNewItem(ObjectListSelectionModel listSelectionModel) {
                SecondaryTableDialog dialog = AbstractSecondaryTablesComposite.this.buildSecondaryTableDialogForAdd();
                AbstractSecondaryTablesComposite.this.addSecondaryTableFromDialog(dialog, listSelectionModel);
            }

            @Override
            public boolean hasOptionalButton() {
                return true;
            }

            @Override
            public String optionalButtonText() {
                return JptUiDetailsMessages.SecondaryTablesComposite_edit;
            }

            @Override
            public void optionOnSelection(ObjectListSelectionModel listSelectionModel) {
                SecondaryTable secondaryTable = (SecondaryTable)listSelectionModel.selectedValue();
                SecondaryTableDialog dialog = new SecondaryTableDialog(AbstractSecondaryTablesComposite.this.getShell(), ((Entity)AbstractSecondaryTablesComposite.this.getSubject()).getJpaProject(), secondaryTable);
                AbstractSecondaryTablesComposite.this.editSecondaryTableFromDialog(dialog, secondaryTable);
            }

            @Override
            public void removeSelectedItems(ObjectListSelectionModel listSelectionModel) {
                Entity entity = (Entity)AbstractSecondaryTablesComposite.this.getSubject();
                int[] selectedIndices = listSelectionModel.selectedIndices();
                int index = selectedIndices.length;
                while (--index >= 0) {
                    entity.removeSpecifiedSecondaryTable(selectedIndices[index]);
                }
            }

            @Override
            public boolean enableOptionOnSelectionChange(ObjectListSelectionModel listSelectionModel) {
                if (listSelectionModel.selectedValuesSize() != 1) {
                    return false;
                }
                SecondaryTable secondaryTable = (SecondaryTable)listSelectionModel.selectedValue();
                return !secondaryTable.isVirtual();
            }

            @Override
            public boolean enableRemoveOnSelectionChange(ObjectListSelectionModel listSelectionModel) {
                if (listSelectionModel.selectedValue() == null) {
                    return false;
                }
                SecondaryTable secondaryTable = (SecondaryTable)listSelectionModel.selectedValue();
                return !secondaryTable.isVirtual();
            }
        };
    }

    protected void editSecondaryTableFromDialog(SecondaryTableDialog dialog, SecondaryTable secondaryTable) {
        if (dialog.open() != 0) {
            return;
        }
        secondaryTable.setSpecifiedName(dialog.getSelectedTable());
        secondaryTable.setSpecifiedCatalog(dialog.getSelectedCatalog());
        secondaryTable.setSpecifiedSchema(dialog.getSelectedSchema());
    }
}

