/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.internal.builder;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.wst.common.componentcore.internal.builder.IDependencyGraphUpdateEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyGraphEvent
implements IDependencyGraphUpdateEvent {
    private int type = 0;
    private long modStamp = 0L;
    private Map<IProject, Set<IProject>> addedReferences = null;
    private Map<IProject, Set<IProject>> removedReferences = null;

    @Override
    public int getType() {
        return this.type;
    }

    void setModStamp(long modStamp) {
        this.modStamp = modStamp;
    }

    @Override
    public long getModStamp() {
        return this.modStamp;
    }

    void addRefererence(IProject sourceProject, IProject targetProject) {
        Set<IProject> references;
        if (sourceProject == null) {
            throw new NullPointerException("Source project must not be null.");
        }
        if (targetProject == null) {
            throw new NullPointerException("Target project must not be null.");
        }
        if (this.removedReferences != null && (references = this.removedReferences.get(targetProject)) != null && references.remove(sourceProject)) {
            if (references.isEmpty()) {
                this.removedReferences.remove(targetProject);
                if (this.removedReferences.isEmpty()) {
                    this.removedReferences = null;
                    this.type = (this.type & 1) == 1 ? 1 : 0;
                }
            }
            return;
        }
        if (this.addedReferences == null) {
            this.type |= 1;
            this.addedReferences = new HashMap<IProject, Set<IProject>>();
        }
        if ((references = this.addedReferences.get(targetProject)) == null) {
            references = new HashSet<IProject>();
            this.addedReferences.put(targetProject, references);
        }
        references.add(sourceProject);
    }

    void removeReference(IProject sourceProject, IProject targetProject) {
        Set<IProject> references;
        if (sourceProject == null) {
            throw new NullPointerException("Source project must not be null.");
        }
        if (targetProject == null) {
            throw new NullPointerException("Target project must not be null.");
        }
        if (this.addedReferences != null && (references = this.addedReferences.get(targetProject)) != null && references.remove(sourceProject)) {
            if (references.isEmpty()) {
                this.addedReferences.remove(targetProject);
                if (this.addedReferences.isEmpty()) {
                    this.addedReferences = null;
                    this.type = (this.type & 2) == 2 ? 2 : 0;
                }
            }
            return;
        }
        if (this.removedReferences == null) {
            this.type |= 2;
            this.removedReferences = new HashMap<IProject, Set<IProject>>();
        }
        if ((references = this.removedReferences.get(targetProject)) == null) {
            references = new HashSet<IProject>();
            this.removedReferences.put(targetProject, references);
        }
        references.add(sourceProject);
    }

    @Override
    public Map<IProject, Set<IProject>> getAddedReferences() {
        if (this.addedReferences == null) {
            return Collections.EMPTY_MAP;
        }
        return this.addedReferences;
    }

    @Override
    public Map<IProject, Set<IProject>> getRemovedReferences() {
        if (this.removedReferences == null) {
            return Collections.EMPTY_MAP;
        }
        return this.removedReferences;
    }
}

